/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap.filtering;

import java.util.Collection;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.mindmap.filtering.FilterService;
import org.xmind.ui.internal.mindmap.filtering.FilterViewer;
import org.xmind.ui.internal.mindmap.filtering.IPropertyFilterListener;
import org.xmind.ui.internal.mindmap.filtering.PropertyFilter;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.viewers.CheckListViewer;

public abstract class FilterSection
implements IPropertyFilterListener {
    public static final int NONE = 0;
    public static final int AUTOMATIC = 1;
    public static final int ALWAYS = 2;
    private String sectionTitle;
    private IGraphicalViewer contributingViewer;
    private PropertyFilter filter;
    private Section section;
    private CheckListViewer list;
    private int messagePolicy;
    private Composite messagePart;
    private boolean schedulingRefresh = false;
    private FilterViewer container = null;
    private ScrolledForm form;
    private ResourceManager resources;

    public FilterSection() {
        this(1);
    }

    public FilterViewer getContainer() {
        return this.container;
    }

    public void setContainer(FilterViewer container) {
        this.container = container;
    }

    public FilterSection(int noItemPolicy) {
        this.messagePolicy = noItemPolicy;
    }

    protected void setTitle(String title) {
        this.sectionTitle = title;
        if (this.section != null) {
            this.section.setText(title == null ? "" : title);
        }
    }

    public void createSectionControl(Composite parent, WidgetFactory factory, ScrolledForm form) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        if (this.form != form) {
            this.form = form;
        }
        this.section = factory.createSection(parent, this.getSectionStyle());
        if (this.sectionTitle != null) {
            this.section.setText(this.sectionTitle);
        }
        this.section.setTitleBarBackground(parent.getDisplay().getSystemColor(1));
        this.section.setTitleBarBorderColor(parent.getDisplay().getSystemColor(1));
        Composite client = factory.createComposite((Composite)this.section);
        this.section.setClient((Control)client);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.rightMargin = 0;
        layout.leftMargin = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        client.setLayout((Layout)layout);
        String assistantMessage = this.getMessage();
        if (assistantMessage != null) {
            this.createMessagePart(client, factory, assistantMessage, false);
        }
        this.createList(client);
        this.section.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilterSection.this.handleDispose();
            }
        });
    }

    protected int getSectionStyle() {
        return 18754;
    }

    protected void handleDispose() {
        if (this.filter != null) {
            this.filter.removePropertyFilterListener(this);
            this.filter = null;
        }
    }

    protected String getMessage() {
        return null;
    }

    protected void createMessagePart(Composite parent, WidgetFactory factory, String message, boolean html) {
        this.messagePart = factory.createComposite(parent, 524288);
        this.messagePart.setLayoutData((Object)new TableWrapData(256, 16));
        this.messagePart.setLayout((Layout)new TableWrapLayout());
        FormText text = factory.createFormText(this.messagePart, false);
        text.setWhitespaceNormalized(false);
        text.setLayoutData((Object)new TableWrapData(256, 16));
        text.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#3c3c3c")));
        if ("win32".equals(SWT.getPlatform())) {
            text.setFont(this.resources.createFont(JFaceResources.getDefaultFontDescriptor().increaseHeight(-1)));
        }
        if (message == null) {
            message = "";
        }
        text.setText(message, html, false);
        if (html) {
            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    FilterSection.this.handleMessageHyperlink(e);
                }
            });
        }
    }

    protected void handleMessageHyperlink(HyperlinkEvent e) {
    }

    private void createList(Composite parent) {
        this.list = new CheckListViewer(parent, 0);
        this.list.setContentProvider((IContentProvider)new FilterContentProvider());
        this.list.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.list.setSorter((ViewerSorter)new FilterSorter());
        this.list.addOpenListener((IOpenListener)new FilterOpenHandler());
        this.list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FilterSection.this.reverseSelection(event.getSelection());
            }
        });
        this.list.addCheckStateListener((ICheckStateListener)new FilterCheckHandler());
        this.list.getControl().setLayoutData((Object)new TableWrapData(256, 256));
    }

    public Control getControl() {
        return this.section;
    }

    public CheckListViewer getList() {
        return this.list;
    }

    public IGraphicalViewer getContributingViewer() {
        return this.contributingViewer;
    }

    public void setContributingViewer(IGraphicalViewer viewer) {
        this.contributingViewer = viewer;
        this.refresh();
    }

    protected void setFilter(PropertyFilter filter) {
        if (filter == this.filter) {
            return;
        }
        if (this.filter != null) {
            this.filter.removePropertyFilterListener(this);
        }
        this.filter = filter;
        if (filter != null) {
            filter.addPropertyFilterListener(this);
        }
    }

    protected abstract PropertyFilter findFilter(IGraphicalViewer var1);

    public void refresh() {
        if (this.schedulingRefresh) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (FilterSection.this.getControl() == null || FilterSection.this.getControl().isDisposed()) {
                    return;
                }
                FilterSection.this.internalRefresh();
                FilterSection.this.schedulingRefresh = false;
            }
        });
        this.schedulingRefresh = true;
    }

    protected void internalRefresh() {
        if (this.contributingViewer == null) {
            this.setFilter(null);
        } else {
            this.setFilter(this.findFilter(this.contributingViewer));
        }
        this.refreshList();
        this.refreshMessagePart();
        if (this.section != null && !this.section.isDisposed()) {
            this.section.getParent().layout();
        }
        this.reflow();
    }

    private void refreshList() {
        if (this.list == null || this.list.getControl() == null || this.list.getControl().isDisposed()) {
            return;
        }
        if (this.list.getInput() != this.contributingViewer) {
            this.list.setInput((Object)this.contributingViewer);
        }
        this.list.refresh();
        if (this.filter != null) {
            int heightHint;
            Collection<Object> filters = this.filter.getPropertyFilters();
            int i = 0;
            while (i < this.list.getItemCount()) {
                Object element = this.list.getElementAt(i);
                this.list.setChecked(element, filters.contains(element));
                ++i;
            }
            ((TableWrapData)this.list.getControl().getLayoutData()).heightHint = heightHint = this.list.getItemCount() == 0 ? 10 : -1;
        }
    }

    private void refreshMessagePart() {
        int heightHint;
        if (this.messagePart == null || this.messagePart.isDisposed()) {
            return;
        }
        boolean visible = this.messagePolicy == 0 ? false : (this.messagePolicy == 2 ? this.filter != null : this.filter != null && (this.list == null || this.list.getItemCount() == 0));
        this.messagePart.setVisible(visible);
        ((TableWrapData)this.messagePart.getLayoutData()).heightHint = heightHint = visible ? -1 : 0;
    }

    private void reflow() {
        if (this.form != null && !this.form.isDisposed()) {
            this.form.reflow(true);
        }
    }

    public boolean hasFilter() {
        return this.filter != null && this.filter.hasFilter();
    }

    public void removeFilter() {
        if (this.filter != null) {
            this.filter.removeAllPropertyFilters();
        }
    }

    public PropertyFilter getFilter() {
        return this.filter;
    }

    public void filterChanged(PropertyFilter filter) {
        this.refresh();
    }

    protected void addPropertyFilter(Object element) {
        if (this.filter != null) {
            this.filter.addPropertyFilter(element);
        }
    }

    protected void removePropertyFilter(Object element) {
        if (this.filter != null) {
            this.filter.removePropertyFilter(element);
        }
    }

    protected void reverseSelection(ISelection selection) {
        if (this.contributingViewer != null && this.filter != null && selection instanceof IStructuredSelection) {
            Object propertyFilter = ((IStructuredSelection)selection).getFirstElement();
            FilterService filterService = (FilterService)this.contributingViewer.getService(FilterService.class);
            if (filterService != null && this.filter != null) {
                if (this.filter.hasFilter(propertyFilter)) {
                    this.filter.removePropertyFilter(propertyFilter);
                } else {
                    this.filter.addPropertyFilter(propertyFilter);
                }
            }
        }
    }

    protected abstract Object[] getAllPropertyFilters(IGraphicalViewer var1);

    protected Image getPropertyFilterImage(Object element) {
        return null;
    }

    protected String getPropertyFilterText(Object element) {
        return element == null ? "" : element.toString();
    }

    protected int getPropertyFilterCategory(Object element) {
        return 0;
    }

    private class FilterCheckHandler
    implements ICheckStateListener {
        private FilterCheckHandler() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getChecked()) {
                FilterSection.this.addPropertyFilter(event.getElement());
            } else {
                FilterSection.this.removePropertyFilter(event.getElement());
            }
        }
    }

    protected class FilterContentProvider
    implements IStructuredContentProvider {
        protected FilterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == FilterSection.this.contributingViewer) {
                return FilterSection.this.getAllPropertyFilters(FilterSection.this.contributingViewer);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FilterLabelProvider
    extends LabelProvider {
        private FilterLabelProvider() {
        }

        public Image getImage(Object element) {
            return FilterSection.this.getPropertyFilterImage(element);
        }

        public String getText(Object element) {
            return FilterSection.this.getPropertyFilterText(element);
        }
    }

    private class FilterOpenHandler
    implements IOpenListener {
        private FilterOpenHandler() {
        }

        public void open(OpenEvent event) {
            FilterSection.this.reverseSelection(event.getSelection());
        }
    }

    private class FilterSorter
    extends ViewerSorter {
        private FilterSorter() {
        }

        public int category(Object element) {
            return FilterSection.this.getPropertyFilterCategory(element);
        }
    }
}

