/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.imports.freemind;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.imports.ImportMessages;
import org.xmind.ui.internal.imports.ImportPlugin;
import org.xmind.ui.internal.imports.freemind.FreeMindImporter;
import org.xmind.ui.wizards.AbstractMindMapImportPage;
import org.xmind.ui.wizards.AbstractMindMapImportWizard;
import org.xmind.ui.wizards.MindMapImporter;

public class FreeMindImportWizard
extends AbstractMindMapImportWizard {
    private static final String SETTINGS_ID = "org.xmind.ui.imports.FreeMind";
    private static final String PAGE_ID = "importFreeMind";
    private static final String EXT = "*.mm";
    private FreeMindImportPage page;

    public FreeMindImportWizard() {
        IDialogSettings settings = ImportPlugin.getDefault().getDialogSettings().getSection(SETTINGS_ID);
        if (settings == null) {
            settings = ImportPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_ID);
        }
        this.setDialogSettings(settings);
        this.setWindowTitle(ImportMessages.FreeMindImportWizard_windowTitle);
    }

    public void addPages() {
        this.page = new FreeMindImportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected MindMapImporter createImporter(String sourcePath, IWorkbook targetWorkbook) {
        return new FreeMindImporter(sourcePath, targetWorkbook);
    }

    protected String getApplicationId() {
        return "FreeMind";
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private class FreeMindImportPage
    extends AbstractMindMapImportPage {
        protected FreeMindImportPage() {
            super(FreeMindImportWizard.PAGE_ID, ImportMessages.FreeMindImportPage_title);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            Control destinationControl = this.createDestinationControl(composite);
            destinationControl.setLayoutData((Object)new GridData(4, 4, true, true));
            this.updateStatus();
            parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    FreeMindImportPage.this.openBrowseDialog();
                }
            });
        }

        protected FileDialog createBrowseDialog() {
            FileDialog dialog = super.createBrowseDialog();
            dialog.setFilterExtensions(new String[]{FreeMindImportWizard.EXT});
            dialog.setFilterNames(new String[]{NLS.bind((String)ImportMessages.FreeMindImportPage_FilterName, (Object)FreeMindImportWizard.EXT)});
            return dialog;
        }
    }
}

