/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IAnchorListener;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.draw2d.decoration.IConnectionDecoration;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.decoration.ILineDecoration;
import org.xmind.gef.draw2d.decoration.IShapeDecoration;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.mindmap.DecoratedFeedback;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.ITitleTextPart;
import org.xmind.ui.style.StyleUtils;

public abstract class DecoratedLineFeedback
extends DecoratedFeedback
implements IAnchorListener {
    private IGraphicalPart host;
    private IFigure realLayer;
    private int lineWidthExpansion = 0;
    private Color lineColor = null;
    private int lineStyle = -1;
    private IAnchor sourceAnchor = null;
    private IAnchor targetAnchor = null;

    public DecoratedLineFeedback(IGraphicalPart part) {
        this.host = part;
    }

    public IGraphicalPart getHost() {
        return this.host;
    }

    @Override
    protected DecoratedFeedback.DecoratedFigure createDecoratedFigure() {
        return new TitledDecoratedFigure();
    }

    @Override
    public void addToLayer(IFigure layer) {
        IViewer viewer;
        if (this.realLayer == null && (viewer = this.host.getSite().getViewer()) instanceof IGraphicalViewer) {
            this.realLayer = ((IGraphicalViewer)viewer).getLayer(GEF.LAYER_PRESENTATION);
        }
        if (this.realLayer != null) {
            layer = this.realLayer;
        }
        super.addToLayer(layer);
    }

    @Override
    public void removeFromLayer(IFigure layer) {
        if (this.realLayer != null) {
            layer = this.realLayer;
        }
        super.removeFromLayer(layer);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getLineWidthExpansion() {
        return this.lineWidthExpansion;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    public void setLineWidthExpansion(int expansion) {
        this.lineWidthExpansion = expansion;
    }

    @Override
    protected void updateBounds(IFigure figure) {
        IFigure client = this.host.getFigure();
        int exp = this.calcExpansion();
        Rectangle bounds = client.getBounds().getExpanded(exp, exp);
        Insets ins = Geometry.add((Insets)new Insets(client.getInsets()), (int)exp);
        figure.setBounds(bounds);
        figure.setBorder((Border)new MarginBorder(ins));
    }

    protected int calcExpansion() {
        return this.getLineWidthExpansion();
    }

    @Override
    protected void updateDecoration(IFigure figure, IDecoration decoration) {
        String decorationId = decoration.getId();
        IStyleSelector ss = StyleUtils.getStyleSelector(this.host);
        this.updateDecoration(figure, decoration, decorationId, ss);
        if (decoration instanceof IConnectionDecoration) {
            ((IConnectionDecoration)decoration).reroute(figure);
        }
    }

    protected void updateDecoration(IFigure figure, IDecoration decoration, String decorationId, IStyleSelector ss) {
        if (decoration instanceof IShapeDecoration) {
            decoration.setAlpha(figure, 255);
            ((IShapeDecoration)decoration).setFillAlpha(figure, 0);
            ((IShapeDecoration)decoration).setFillColor(figure, null);
            ((IShapeDecoration)decoration).setGradient(figure, false);
            ((IShapeDecoration)decoration).setLineAlpha(figure, this.getDecorationAlpha(figure, decoration));
        } else {
            decoration.setAlpha(figure, this.getDecorationAlpha(figure, decoration));
        }
        if (decoration instanceof ILineDecoration) {
            Color lineColor = this.getLineColor();
            if (lineColor == null) {
                lineColor = StyleUtils.getColor(this.host, ss, "line-color", decorationId, "#afafaf");
            }
            ((ILineDecoration)decoration).setLineColor(figure, lineColor);
            int lineStyle = this.getLineStyle();
            if (lineStyle == -1) {
                lineStyle = StyleUtils.getLineStyle(this.host, ss, decorationId, 2);
            }
            ((ILineDecoration)decoration).setLineStyle(figure, lineStyle);
            int originalLineWidth = StyleUtils.getInteger(this.host, ss, "line-width", decorationId, 3);
            int lineWidth = originalLineWidth + this.getLineWidthExpansion() * 2;
            ((ILineDecoration)decoration).setLineWidth(figure, lineWidth);
        }
        this.setSourceAnchor(this.getSourceAnchor(this.host), figure, decoration);
        this.setTargetAnchor(this.getTargetAnchor(this.host), figure, decoration);
        if (decoration instanceof ICorneredDecoration) {
            int corner = StyleUtils.getInteger(this.host, ss, "shape-corner", decorationId, 10);
            ((ICorneredDecoration)decoration).setCornerSize(figure, corner);
        }
        decoration.setVisible(figure, this.isDecorationVisible(figure, decoration));
    }

    protected int getDecorationAlpha(IFigure figure, IDecoration decoration) {
        if (this.host.getStatus().isPreSelected() && !this.host.getStatus().isSelected()) {
            return 96;
        }
        return 255;
    }

    protected boolean isDecorationVisible(IFigure figure, IDecoration decoration) {
        return this.host.getFigure().isVisible();
    }

    @Override
    protected void disposeOldDecoration(IFigure figure, IDecoration decoration) {
        this.setSourceAnchor(null, figure, decoration);
        this.setTargetAnchor(null, figure, decoration);
    }

    protected IAnchor getSourceAnchor(IGraphicalPart part) {
        INodePart node;
        if (part instanceof IConnectionPart && (node = ((IConnectionPart)part).getSourceNode()) != null) {
            return node.getSourceAnchor(part);
        }
        return null;
    }

    protected IAnchor getTargetAnchor(IGraphicalPart part) {
        INodePart node;
        if (part instanceof IConnectionPart && (node = ((IConnectionPart)part).getTargetNode()) != null) {
            return node.getTargetAnchor(part);
        }
        return null;
    }

    protected void setSourceAnchor(IAnchor anchor, IFigure figure, IDecoration decoration) {
        if (anchor != this.sourceAnchor) {
            if (this.sourceAnchor != null) {
                this.unhookAnchor(this.sourceAnchor);
            }
            this.sourceAnchor = anchor;
            if (anchor != null) {
                this.hookAnchor(anchor);
            }
            figure.revalidate();
            figure.repaint();
        }
        if (decoration instanceof IConnectionDecoration) {
            ((IConnectionDecoration)decoration).setSourceAnchor(figure, anchor);
        }
    }

    protected void setTargetAnchor(IAnchor anchor, IFigure figure, IDecoration decoration) {
        if (anchor != this.targetAnchor) {
            if (this.targetAnchor != null) {
                this.unhookAnchor(this.targetAnchor);
            }
            this.targetAnchor = anchor;
            if (anchor != null) {
                this.hookAnchor(anchor);
            }
            figure.revalidate();
            figure.repaint();
        }
        if (decoration instanceof IConnectionDecoration) {
            ((IConnectionDecoration)decoration).setTargetAnchor(figure, anchor);
        }
    }

    protected void unhookAnchor(IAnchor anchor) {
        anchor.removeAnchorListener((IAnchorListener)this);
    }

    protected void hookAnchor(IAnchor anchor) {
        anchor.addAnchorListener((IAnchorListener)this);
    }

    public void anchorMoved(IAnchor anchor) {
        if (this.getFigure() != null) {
            this.updateBounds((IFigure)this.getFigure());
        }
    }

    protected class TitledDecoratedFigure
    extends DecoratedFeedback.DecoratedFigure
    implements ITitledFigure {
        protected TitledDecoratedFigure() {
            super(DecoratedLineFeedback.this);
        }

        public ITextFigure getTitle() {
            ITitleTextPart title = (ITitleTextPart)DecoratedLineFeedback.this.host.getAdapter(ITitleTextPart.class);
            if (title != null) {
                return title.getTextFigure();
            }
            return null;
        }

        public void setTitle(ITextFigure title) {
        }
    }
}

