/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.DialogPane;
import org.xmind.ui.internal.statushandlers.StatusDetails;

public class ErrorDialogPane
extends DialogPane {
    private final StatusAdapter error;
    private final String summary;
    private Text summaryBoard;

    public ErrorDialogPane(StatusAdapter error) {
        this.error = error;
        Throwable cause = StatusDetails.getRootCause((Throwable)error.getStatus().getException());
        if (cause == null) {
            cause = new UnknownError();
        }
        this.summary = NLS.bind((String)MindMapMessages.ErrorDialogPane_summaryBoard_text, (Object[])new Object[]{error.getStatus().getMessage(), cause.getClass().getName(), cause.getLocalizedMessage()});
    }

    @Override
    protected Control createDialogContents(Composite parent) {
        Composite composite = (Composite)super.createDialogContents(parent);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 20;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createSummaryBoard(composite);
        return composite;
    }

    @Override
    protected int getPreferredWidth() {
        return 500;
    }

    private void createSummaryBoard(Composite parent) {
        Composite box = new Composite(parent, 0);
        box.setBackground(parent.getBackground());
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        box.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 10;
        box.setLayout((Layout)gridLayout);
        this.createIcon(box);
        this.createSummaryBox(box);
    }

    private void createIcon(Composite parent) {
        Label iconLabel = new Label(parent, 0);
        iconLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
        iconLabel.setBackground(parent.getBackground());
        iconLabel.setImage(parent.getDisplay().getSystemImage(1));
    }

    private void createSummaryBox(Composite parent) {
        this.summaryBoard = new Text(parent, 74);
        this.summaryBoard.setBackground(parent.getBackground());
        this.applyFont((Control)this.summaryBoard);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        this.summaryBoard.setLayoutData((Object)gridData);
        if (this.summary != null) {
            this.summaryBoard.setText(this.summary);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.summaryBoard = null;
    }

    @Override
    public void setFocus() {
        if (this.summaryBoard != null && !this.summaryBoard.isDisposed()) {
            this.summaryBoard.setFocus();
        }
    }

    @Override
    protected void createButtonsForButtonBar(Composite buttonBar) {
        this.createButton(buttonBar, 0, MindMapMessages.EncryptDialogPane_detailsButton_label, false);
        this.createButton(buttonBar, 12, IDialogConstants.CLOSE_LABEL, false);
        this.getButton(0).setEnabled(this.error != null);
    }

    @Override
    protected boolean closePressed() {
        this.setReturnCode(1);
        this.close();
        return true;
    }

    @Override
    protected boolean okPressed() {
        this.showDetails();
        return true;
    }

    private void showDetails() {
        StatusManager.getManager().handle(this.error, 2);
    }

    @Override
    protected void escapeKeyPressed() {
        this.triggerButton(12);
    }
}

