/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.ui.internal.IconTipContributorManager;
import org.xmind.ui.internal.InfoItemContributorManager;
import org.xmind.ui.internal.mindmap.IconTip;
import org.xmind.ui.internal.mindmap.TopicPart;
import org.xmind.ui.mindmap.IIconTipContributor;
import org.xmind.ui.mindmap.IInfoItemContributor;

public class TopicInfoItemManager {
    private TopicPart topicPart;
    private Map<IInfoItemContributor, IconTip> contributorToModel = new HashMap<IInfoItemContributor, IconTip>();

    public TopicInfoItemManager(TopicPart topicPart) {
        this.topicPart = topicPart;
    }

    public List<IconTip> getIconTips() {
        ISheet sheet;
        List<IInfoItemContributor> bothContributors;
        List<IInfoItemContributor> contributors2;
        ArrayList<IconTip> iconTips = new ArrayList<IconTip>();
        ITopic topic = this.topicPart.getTopic();
        List<IIconTipContributor> contributors = IconTipContributorManager.getInstance().getContributors();
        if (!contributors.isEmpty()) {
            for (IIconTipContributor contributor : contributors) {
                IAction action = contributor.createAction(this.topicPart, topic);
                if (action == null) continue;
                iconTips.add(new IconTip(topic, contributor, action));
            }
        }
        if (!(contributors2 = InfoItemContributorManager.getInstance().getContributors()).isEmpty()) {
            for (IInfoItemContributor contributor : contributors2) {
                IconTip oldIconTip = this.contributorToModel.get(contributor);
                if (oldIconTip != null && !contributor.isModified(this.topicPart, topic, oldIconTip.getAction())) {
                    iconTips.add(oldIconTip);
                    continue;
                }
                IconTip iconTip = null;
                IAction action = contributor.createAction(this.topicPart, topic);
                if (action != null) {
                    iconTip = new IconTip(topic, contributor, action);
                    iconTips.add(iconTip);
                }
                if (iconTip != null) {
                    this.contributorToModel.put(contributor, iconTip);
                    continue;
                }
                this.contributorToModel.remove(contributor);
            }
        }
        if (!(bothContributors = InfoItemContributorManager.getInstance().getBothContributors()).isEmpty() && (sheet = topic.getOwnedSheet()) != null) {
            for (IInfoItemContributor contributor : bothContributors) {
                IAction action;
                IconTip oldIconTip = this.contributorToModel.get(contributor);
                if (oldIconTip != null && !contributor.isModified(this.topicPart, topic, oldIconTip.getAction())) {
                    iconTips.add(oldIconTip);
                    continue;
                }
                IconTip iconTip = null;
                String infoItemMode = null;
                String type = contributor.getId();
                if (type != null && !"".equals(type)) {
                    List entries = sheet.getSettings().getEntries("info-items/info-item");
                    for (ISettingEntry entry : entries) {
                        String t = entry.getAttribute("type");
                        if (!type.equals(t)) continue;
                        infoItemMode = entry.getAttribute("mode");
                    }
                }
                if (infoItemMode == null || "".equals(infoItemMode)) {
                    infoItemMode = contributor.getDefaultMode();
                }
                if (("icon".equals(infoItemMode) || !contributor.isCardModeAvailable(topic, this.topicPart)) && (action = contributor.createAction(this.topicPart, topic)) != null) {
                    iconTip = new IconTip(topic, contributor, action);
                    iconTips.add(iconTip);
                }
                if (iconTip != null) {
                    this.contributorToModel.put(contributor, iconTip);
                    continue;
                }
                this.contributorToModel.remove(contributor);
            }
        }
        return iconTips;
    }

    public void topicDeactivated() {
        this.contributorToModel.clear();
    }
}

