/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.cathy.internal.dashboard.NewFromStructuresDashboardPage;
import org.xmind.cathy.internal.dashboard.NewFromTemplatesDashboardPage;
import org.xmind.ui.internal.dashboard.pages.DashboardPage;
import org.xmind.ui.internal.dashboard.pages.IDashboardContext;
import org.xmind.ui.internal.dashboard.pages.IDashboardPage;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.tabfolder.MTabBar;
import org.xmind.ui.tabfolder.MTabBarItem;
import org.xmind.ui.util.IStyleProvider;
import org.xmind.ui.util.StyleProvider;

public class NewFileDashboardPage
extends DashboardPage
implements IAdaptable {
    private Control control = null;
    private ResourceManager resourceManager = null;
    private Composite titleBar = null;
    private Composite rightBar = null;
    private MTabBar tabBar = null;
    private Composite pageContainer = null;
    private List<IDashboardPage> pages = new ArrayList<IDashboardPage>();

    @PostConstruct
    private void init(IDashboardContext dashboardContext) {
        NewFromStructuresDashboardPage structurePage = new NewFromStructuresDashboardPage();
        structurePage.setTitle(WorkbenchMessages.DashboardBlankPage_name);
        structurePage.setDescription(WorkbenchMessages.DashboardBlankPage_message);
        structurePage.setContext(dashboardContext);
        this.pages.add((IDashboardPage)structurePage);
        NewFromTemplatesDashboardPage templatePage = new NewFromTemplatesDashboardPage();
        templatePage.setTitle(WorkbenchMessages.DashboardTemplatesPage_name);
        templatePage.setDescription(WorkbenchMessages.DashboardTemplatesPage_message);
        templatePage.setContext(dashboardContext);
        templatePage.registerAvailableCommands();
        this.pages.add((IDashboardPage)templatePage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(1).applyTo(composite);
        Control titleBar = this.createTitleBar(composite);
        GridDataFactory.fillDefaults().hint(-1, 44).align(4, 4).grab(true, false).applyTo(titleBar);
        Label separator = new Label(composite, 258);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)separator);
        Control pageContainer = this.createPageContainer(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(pageContainer);
        this.control = composite;
        for (IDashboardPage page : this.pages) {
            MTabBarItem item = new MTabBarItem(this.tabBar, 16);
            item.setText(page.getTitle());
            item.setData((Object)page);
        }
        this.setTitleBarComponentLayoutData();
        this.showPage(this.tabBar.getItem(0));
    }

    private void setTitleBarComponentLayoutData() {
        FormData tabData = new FormData();
        Point tabSize = this.tabBar.computeSize(-1, -1);
        tabData.left = new FormAttachment(50, -tabSize.x / 2);
        tabData.top = new FormAttachment(50, -tabSize.y / 2);
        tabData.bottom = new FormAttachment(50, tabSize.y / 2);
        this.tabBar.setLayoutData((Object)tabData);
        FormData rightData = new FormData();
        rightData.top = new FormAttachment(0, 0);
        rightData.right = new FormAttachment(100, 0);
        rightData.bottom = new FormAttachment(100, 0);
        this.rightBar.setLayoutData((Object)rightData);
    }

    private Control createTitleBar(Composite parent) {
        this.titleBar = new Composite(parent, 0);
        FormLayout titleBarLayout = new FormLayout();
        titleBarLayout.marginWidth = 10;
        titleBarLayout.marginHeight = 0;
        titleBarLayout.marginRight = 15;
        this.titleBar.setLayout((Layout)titleBarLayout);
        this.titleBar.setForeground(parent.getForeground());
        this.titleBar.setBackground((Color)JFaceResources.getResources().get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ececec")));
        Control titleLabel = this.createLeftTitleBarControl(this.titleBar);
        FormData leftData = new FormData();
        leftData.top = new FormAttachment(0, 0);
        leftData.left = new FormAttachment(0, 0);
        leftData.bottom = new FormAttachment(100, 0);
        titleLabel.setLayoutData((Object)leftData);
        this.createCentralContainer(this.titleBar);
        this.createRightBar(this.titleBar);
        return this.titleBar;
    }

    private Control createLeftTitleBarControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(3, 0).applyTo(composite);
        Label titleNameLabel = new Label(composite, 64);
        titleNameLabel.setBackground(composite.getBackground());
        titleNameLabel.setForeground(composite.getForeground());
        titleNameLabel.setFont((Font)JFaceResources.getResources().get((DeviceResourceDescriptor)JFaceResources.getHeaderFontDescriptor().increaseHeight(-1)));
        titleNameLabel.setText(WorkbenchMessages.NewFileDashboardPage_leftTitleBar_text);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)titleNameLabel);
        return composite;
    }

    private Control createCentralContainer(Composite parent) {
        this.tabBar = new MTabBar(parent, 0);
        this.tabBar.setBackground(parent.getDisplay().getSystemColor(37));
        this.tabBar.setStyleProvider((IStyleProvider)new SegmentBarStyleProvider());
        this.tabBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewFileDashboardPage.this.showPage((MTabBarItem)event.item);
            }
        });
        return this.tabBar;
    }

    private Control createRightBar(Composite composite) {
        this.rightBar = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.rightBar);
        this.createImportButton(this.rightBar);
        return this.rightBar;
    }

    private void createImportButton(Composite parent) {
        final Label importBtton = new Label(parent, 0);
        importBtton.setBackground(parent.getBackground());
        importBtton.setToolTipText(WorkbenchMessages.NewFileDashboardPage_Import_button);
        importBtton.setImage((Image)this.resourceManager.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"dashboard/new/button_import.png")));
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(true, true).applyTo((Control)importBtton);
        final IAction addTemplateAction = this.getAddTemplateAction();
        importBtton.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                addTemplateAction.run();
            }
        });
        importBtton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                importBtton.setImage((Image)NewFileDashboardPage.this.resourceManager.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"dashboard/new/button_import.png")));
            }

            public void mouseEnter(MouseEvent e) {
                importBtton.setImage((Image)NewFileDashboardPage.this.resourceManager.get((DeviceResourceDescriptor)CathyPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"dashboard/new/button_import_hover.png")));
            }
        });
    }

    private IAction getAddTemplateAction() {
        Action addTemplateAction = new Action(WorkbenchMessages.NewFileDashboardPage_AddTemplates_label){

            public void run() {
                FileDialog dialog = new FileDialog(NewFileDashboardPage.this.getShell(), 4096);
                String ext = "*.xmt";
                dialog.setFilterExtensions(new String[]{ext});
                dialog.setFilterNames(new String[]{NLS.bind((String)"{0} ({1})", (Object)WorkbenchMessages.NewFileDashboardPage_TemplateFilterName_label, (Object)ext)});
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                final File templateFile = new File(path);
                if (templateFile != null && templateFile.exists()) {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            MindMapUI.getResourceManager().addUserTemplateFromWorkbookURI(templateFile.toURI());
                        }
                    });
                }
            }
        };
        addTemplateAction.setToolTipText(WorkbenchMessages.NewFileDashboardPage_AddTemplates_tooltip);
        return addTemplateAction;
    }

    private Control createPageContainer(Composite parent) {
        this.pageContainer = new Composite(parent, 0);
        this.pageContainer.setBackground(parent.getBackground());
        this.pageContainer.setLayout((Layout)new StackLayout());
        return this.pageContainer;
    }

    private void showPage(MTabBarItem item) {
        if (this.pageContainer == null || this.pageContainer.isDisposed()) {
            return;
        }
        StackLayout layout = (StackLayout)this.pageContainer.getLayout();
        if (item == null) {
            layout.topControl = null;
            this.pageContainer.layout(true);
            return;
        }
        IDashboardPage page = (IDashboardPage)item.getData();
        if (page != null) {
            if (page.getControl() == null) {
                page.createControl(this.pageContainer);
            }
            layout.topControl = page.getControl();
            this.pageContainer.layout(true);
            this.updateTitleBar();
        }
        this.getContext().setSelectionProvider(this.getAdapter(ISelectionProvider.class));
    }

    public void dispose() {
        if (this.pages != null) {
            for (IDashboardPage page : this.pages) {
                page.dispose();
            }
            this.pages.clear();
            this.pages = null;
        }
        super.dispose();
    }

    private void updateTitleBar() {
        MTabBarItem item = this.tabBar.getSelection();
        IDashboardPage page = (IDashboardPage)item.getData();
        if (page instanceof NewFromTemplatesDashboardPage) {
            this.rightBar.setVisible(true);
        } else if (page instanceof NewFromStructuresDashboardPage) {
            this.rightBar.setVisible(false);
        }
        this.titleBar.layout(true);
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        IDashboardPage page;
        MTabBarItem item = this.tabBar.getSelection();
        if (item != null && (page = (IDashboardPage)item.getData()) != null) {
            page.setFocus();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        MTabBarItem item = this.tabBar.getSelection();
        IDashboardPage page = (IDashboardPage)item.getData();
        if (page instanceof IAdaptable) {
            return (T)((IAdaptable)page).getAdapter(adapter);
        }
        return null;
    }

    private class SegmentBarStyleProvider
    extends StyleProvider {
        private SegmentBarStyleProvider() {
        }

        public Font getFont(Object widget, String key) {
            if (widget instanceof MTabBarItem && "text".equals(key)) {
                return (Font)NewFileDashboardPage.this.resourceManager.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().setHeight(Util.isMac() ? 10 : 12));
            }
            return super.getFont(widget, key);
        }

        public int getWidth(Object widget, String key, int defaultValue) {
            if (widget instanceof MTabBarItem) {
                if (key == null) {
                    return 100;
                }
            } else if (widget instanceof MTabBar) {
                if ("border".equals(key)) {
                    return 1;
                }
                if ("separator".equals(key)) {
                    return 1;
                }
                if ("corner".equals(key)) {
                    return 6;
                }
            }
            return super.getWidth(widget, key, defaultValue);
        }

        public int getHeight(Object widget, String key, int defaultValue) {
            if (widget instanceof MTabBarItem) {
                if (key == null) {
                    return 26;
                }
            } else if (widget instanceof MTabBar) {
                if ("border".equals(key)) {
                    return 1;
                }
                if ("separator".equals(key)) {
                    return 1;
                }
                if ("corner".equals(key)) {
                    return 6;
                }
            }
            return super.getHeight(widget, key, defaultValue);
        }

        public int getPosition(Object widget, String key, int defaultValue) {
            if (widget instanceof MTabBarItem && "text".equals(key)) {
                return 1024;
            }
            return super.getPosition(widget, key, defaultValue);
        }

        public Color getColor(Object widget, String key) {
            if (widget instanceof MTabBarItem) {
                MTabBarItem item = (MTabBarItem)widget;
                if ("fill".equals(key)) {
                    if (item.isSelected()) {
                        return (Color)NewFileDashboardPage.this.resourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)"#6B6A6B")));
                    }
                } else if ("text".equals(key)) {
                    if (item.isSelected()) {
                        return (Color)NewFileDashboardPage.this.resourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)"#FFFFFF")));
                    }
                    return (Color)NewFileDashboardPage.this.resourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)"#2B2A2B")));
                }
            } else if (widget instanceof MTabBar && ("border".equals(key) || "separator".equals(key))) {
                return (Color)NewFileDashboardPage.this.resourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)"#A6A6A6")));
            }
            return super.getColor(widget, key);
        }

        public int getAlpha(Object widget, String key, int defaultValue) {
            if (widget instanceof MTabBar && "border".equals(key)) {
                return 192;
            }
            return super.getAlpha(widget, key, defaultValue);
        }
    }
}

