/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.ui.preference.PreferenceFieldEditorPageSection;
import org.xmind.ui.resources.ColorUtils;

public class LanguagePreferencePageSection
extends PreferenceFieldEditorPageSection
implements IWorkbenchPreferencePage,
MouseListener {
    private static final String LANGUAGE_OSGI_NL_KEY = "osgi.nl";
    private static final String LOADED_LANGUAGES_URL = "platform:/plugin/org.xmind.cathy/resource/langs.properties";
    private Properties supportLanguageProperties;
    private String oldLangKey = null;
    private String newLangKey = null;
    private Properties configIniProperties;
    private Label langLabel;
    private LocalResourceManager resource;
    private static final String blue = "#0070D8";
    private static final String[] supportedLangsKey = new String[]{"en_US", "de", "fr", "zh_CN", "zh_TW", "ja", "ko", "da", "es", "sl", "it"};
    private Map<Composite, String> langMap = null;

    public void init(IWorkbench workbench) {
        this.configIniProperties = this.loadProperties(this.getConfigFile());
        this.supportLanguageProperties = this.loadProperties(this.getSupportLanguageFile());
        if (this.oldLangKey == null) {
            String languageKey = this.configIniProperties.getProperty(LANGUAGE_OSGI_NL_KEY);
            this.oldLangKey = languageKey != null ? languageKey : System.getProperty(LANGUAGE_OSGI_NL_KEY);
        }
    }

    protected Control createContents(Composite parent) {
        String langString;
        if (this.resource == null) {
            this.resource = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        }
        Composite topContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)topContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(topContainer);
        Label describe = new Label(topContainer, 0);
        describe.setText(WorkbenchMessages.ChangeLanguageTo_description);
        this.langLabel = new Label(topContainer, 0);
        if (this.supportLanguageProperties == null) {
            this.supportLanguageProperties = this.loadProperties(this.getSupportLanguageFile());
        }
        langString = (langString = this.supportLanguageProperties.getProperty(this.oldLangKey)) != null ? langString : " ";
        this.langLabel.setText(langString);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.langLabel);
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        if (parentLayout != null) {
            parentLayout.verticalSpacing = 10;
        }
        Composite container = this.createLangContainer(parent, 3);
        this.initLangMap(container);
        this.initByOldLangKey();
        return container;
    }

    private void initLangMap(Composite container) {
        if (this.langMap == null) {
            this.langMap = new HashMap<Composite, String>();
        }
        String[] stringArray = supportedLangsKey;
        int n = supportedLangsKey.length;
        int n2 = 0;
        while (n2 < n) {
            Control[] children;
            String lang = stringArray[n2];
            Composite langComposite = this.createLang(container, this.supportLanguageProperties.getProperty(lang));
            langComposite.addMouseListener((MouseListener)this);
            Control[] controlArray = children = langComposite.getChildren();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                Control child = controlArray[n4];
                child.addMouseListener((MouseListener)this);
                ++n4;
            }
            this.langMap.put(langComposite, lang);
            ++n2;
        }
    }

    private void initByOldLangKey() {
        if (this.langMap != null && this.langMap.containsValue(this.oldLangKey)) {
            for (Map.Entry<Composite, String> item : this.langMap.entrySet()) {
                if (!this.oldLangKey.equals(item.getValue())) continue;
                Composite composite = item.getKey();
                this.changeControlBack(composite, (Color)this.resource.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)blue)), ColorConstants.white);
            }
        }
    }

    private Composite createLangContainer(Composite parent, int cols) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().equalWidth(true).spacing(8, 10).numColumns(cols).applyTo(container);
        return container;
    }

    private Composite createLang(Composite parent, String lang) {
        Composite panel = new Composite(parent, 2048);
        panel.setBackground(ColorConstants.white);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(panel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Label langLabel = new Label(panel, 0);
        langLabel.setText(lang);
        langLabel.setBackground(ColorConstants.white);
        return panel;
    }

    private File getSupportLanguageFile() {
        try {
            URL url = FileLocator.find((URL)new URL(LOADED_LANGUAGES_URL));
            File supportLanguageFile = new File(FileLocator.toFileURL((URL)url).getPath());
            return supportLanguageFile;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties(File file) {
        if (file == null) return null;
        if (!file.exists()) return null;
        if (!file.canRead()) return null;
        try {
            Properties properties2;
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file), 1024);
            try {
                Properties properties = new Properties();
                properties.load(stream);
                properties2 = properties;
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
                return properties2;
            }
            catch (IOException iOException) {}
            return properties2;
        }
        catch (IOException iOException) {}
        return null;
    }

    private File getConfigFile() {
        URL configDir = Platform.getConfigurationLocation().getURL();
        try {
            URL configIni = new URL(configDir, "config.ini");
            File file = new File(configIni.getFile());
            return file;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void storeProperties(Properties properties, File file) {
        if (file != null && file.exists() && file.canWrite()) {
            try {
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file), 1024);
                try {
                    properties.store(stream, "Store properties into file.");
                }
                catch (Throwable throwable) {
                    try {
                        ((OutputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {}
        }
    }

    protected void performDefaults() {
        this.configIniProperties.put(LANGUAGE_OSGI_NL_KEY, System.getProperty(LANGUAGE_OSGI_NL_KEY));
        String lang = System.getProperty(LANGUAGE_OSGI_NL_KEY);
        if (this.langMap != null && this.langMap.containsValue(lang)) {
            this.clearLangSelection();
            this.newLangKey = lang;
            for (Map.Entry<Composite, String> item : this.langMap.entrySet()) {
                if (!lang.equals(item.getValue())) continue;
                Composite composite = item.getKey();
                this.changeControlBack(composite, (Color)this.resource.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)blue)), ColorConstants.white);
            }
        }
        this.storeProperties(this.configIniProperties, this.getConfigFile());
        super.performDefaults();
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        if (this.newLangKey != null && !this.oldLangKey.equals(this.newLangKey)) {
            String message = WorkbenchMessages.LanguagePrefPage_ConfirmToRestart2_description;
            MessageDialog confirmDialog = new MessageDialog(this.getShell(), WorkbenchMessages.ConfirmToRestart_title, null, message, 5, new String[]{WorkbenchMessages.LanguagePrefPage_ConfirmToRestart2_defaultButton, WorkbenchMessages.LanguagePrefPage_ConfirmToRestart_laterButton}, 0);
            int restart = confirmDialog.open();
            if (restart == -1) {
                return false;
            }
            this.configIniProperties.put(LANGUAGE_OSGI_NL_KEY, this.newLangKey);
            this.storeProperties(this.configIniProperties, this.getConfigFile());
            if (restart == 0) {
                PlatformUI.getWorkbench().restart();
            }
        }
        return true;
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.mouseDown(e);
        this.performOk();
    }

    public void mouseDown(MouseEvent e) {
        Composite composite = null;
        Object object = e.getSource();
        if (object != null && object instanceof Control) {
            if (object instanceof Composite) {
                composite = (Composite)object;
            } else if (object instanceof Label) {
                composite = ((Label)object).getParent();
            }
        }
        this.changeLangSelection(composite);
    }

    public void mouseUp(MouseEvent e) {
    }

    private void changeLangSelection(Composite composite) {
        if (composite != null) {
            this.clearLangSelection();
            this.newLangKey = null;
            this.changeControlBack(composite, (Color)this.resource.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)blue)), ColorConstants.white);
            if (this.langMap.containsKey(composite)) {
                this.newLangKey = this.langMap.get(composite);
                this.langLabel.setText(this.supportLanguageProperties.getProperty(this.newLangKey));
            }
        }
    }

    private void clearLangSelection() {
        for (Map.Entry<Composite, String> it : this.langMap.entrySet()) {
            this.changeControlBack(it.getKey(), ColorConstants.white, ColorConstants.black);
        }
    }

    private void changeControlBack(Composite composite, Color color, Color fontColor) {
        Control[] children;
        composite.setBackground(color);
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setBackground(color);
            child.setForeground(fontColor);
            ++n2;
        }
    }

    protected void createFieldEditors() {
    }
}

