/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.converter.FallbackStringToObjectConverter;
import org.junit.jupiter.params.converter.StringToBooleanConverter;
import org.junit.jupiter.params.converter.StringToCharacterConverter;
import org.junit.jupiter.params.converter.StringToClassConverter;
import org.junit.jupiter.params.converter.StringToCommonJavaTypesConverter;
import org.junit.jupiter.params.converter.StringToEnumConverter;
import org.junit.jupiter.params.converter.StringToJavaTimeConverter;
import org.junit.jupiter.params.converter.StringToNumberConverter;
import org.junit.jupiter.params.converter.StringToObjectConverter;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.0")
public class DefaultArgumentConverter
implements ArgumentConverter {
    public static final DefaultArgumentConverter INSTANCE = new DefaultArgumentConverter();
    private static final List<StringToObjectConverter> stringToObjectConverters = Collections.unmodifiableList(Arrays.asList(new StringToBooleanConverter(), new StringToCharacterConverter(), new StringToNumberConverter(), new StringToClassConverter(), new StringToEnumConverter(), new StringToJavaTimeConverter(), new StringToCommonJavaTypesConverter(), new FallbackStringToObjectConverter()));

    private DefaultArgumentConverter() {
    }

    @Override
    public final Object convert(Object source, ParameterContext context) {
        Class<?> targetType = context.getParameter().getType();
        return this.convert(source, targetType, context);
    }

    public final Object convert(Object source, Class<?> targetType, ParameterContext context) {
        if (source == null) {
            if (targetType.isPrimitive()) {
                throw new ArgumentConversionException("Cannot convert null to primitive value of type " + targetType.getTypeName());
            }
            return null;
        }
        if (ReflectionUtils.isAssignableTo((Object)source, targetType)) {
            return source;
        }
        if (source instanceof String) {
            Class<?> targetTypeToUse = DefaultArgumentConverter.toWrapperType(targetType);
            Optional<StringToObjectConverter> converter = stringToObjectConverters.stream().filter(candidate -> candidate.canConvert(targetTypeToUse)).findFirst();
            if (converter.isPresent()) {
                Class<?> declaringClass = context.getDeclaringExecutable().getDeclaringClass();
                ClassLoader classLoader = ClassLoaderUtils.getClassLoader(declaringClass);
                try {
                    return converter.get().convert((String)source, targetTypeToUse, classLoader);
                }
                catch (Exception ex) {
                    if (ex instanceof ArgumentConversionException) {
                        throw (ArgumentConversionException)((Object)ex);
                    }
                    throw new ArgumentConversionException("Failed to convert String \"" + source + "\" to type " + targetType.getTypeName(), ex);
                }
            }
        }
        throw new ArgumentConversionException(String.format("No built-in converter for source type %s and target type %s", source.getClass().getTypeName(), targetType.getTypeName()));
    }

    private static Class<?> toWrapperType(Class<?> targetType) {
        Class<?> wrapperType = ReflectionUtils.getWrapperType(targetType);
        return wrapperType != null ? wrapperType : targetType;
    }
}

