/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.dita.dost.invoker.Arguments;
import org.dita.dost.invoker.Main;
import org.dita.dost.invoker.UsageBuilder;

public class InitArguments
extends Arguments {
    String template;
    Path output;
    boolean list = false;

    @Override
    InitArguments parse(String[] arguments) {
        String arg;
        ArrayDeque<String> args = new ArrayDeque<String>(Arrays.asList(arguments));
        while (!args.isEmpty() && !(arg = (String)args.pop()).equals("init")) {
            if (arg.startsWith("-")) {
                this.parseCommonOptions(arg, args);
                continue;
            }
            this.template = arg;
        }
        while (!args.isEmpty()) {
            arg = (String)args.pop();
            if (this.isLongForm(arg, "-output") || arg.equals("-o")) {
                this.handleArgOutput(arg, args);
                continue;
            }
            if (this.isLongForm(arg, "-list")) {
                this.list = true;
                continue;
            }
            if (arg.startsWith("-")) {
                this.parseCommonOptions(arg, args);
                continue;
            }
            this.template = arg;
        }
        if (this.msgOutputLevel < 2) {
            this.emacsMode = true;
        }
        return this;
    }

    private void handleArgOutput(String arg, Deque<String> args) {
        Map.Entry<String, String> entry = this.parse(arg, args);
        if (entry.getValue() == null || entry.getValue().isBlank()) {
            throw new BuildException(Main.locale.getString("init.error.output"));
        }
        this.output = Paths.get(entry.getValue(), new String[0]).toAbsolutePath();
    }

    private void handleSubcommandInit(String arg, Deque<String> args) {
        String value = args.peek();
        value = value != null && !value.startsWith("-") ? args.pop() : null;
        this.template = value;
    }

    @Override
    String getUsage(boolean compact) {
        return UsageBuilder.builder(compact, this.useColor).usage(Main.locale.getString("init.usage")).usage(Main.locale.getString("init.usage.list")).arguments(null, null, "template", Main.locale.getString("init.argument.template")).options("o", "output", "dir", Main.locale.getString("init.option.output")).options(null, "list", null, Main.locale.getString("init.option.list")).build();
    }
}

