/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.nativeplatform.toolchain.internal.gcc.metadata;

import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.xcode.MacOSSdkPathLocator;

import java.io.File;

public class SystemLibraryDiscovery {
    private final MacOSSdkPathLocator macOSSdkPathLocator;

    public SystemLibraryDiscovery(MacOSSdkPathLocator macOSSdkPathLocator) {
        this.macOSSdkPathLocator = macOSSdkPathLocator;
    }

    public String[] compilerProbeArgs(NativePlatformInternal target) {
        if (!target.getOperatingSystem().isMacOsX()) {
            return new String[0];
        }
        File sdkDir = macOSSdkPathLocator.find();
        return new String[]{"-isysroot", sdkDir.getAbsolutePath()};
    }
}
