/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolveExceptionContextualizer;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.DefaultVisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedLocalComponentsResult;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.specs.Spec;

public class ErrorHandlingConfigurationResolver
implements ConfigurationResolver {
    private final ConfigurationResolver delegate;
    private final ResolveExceptionContextualizer exceptionMapper;

    public ErrorHandlingConfigurationResolver(ConfigurationResolver delegate, ResolveExceptionContextualizer exceptionMapper) {
        this.delegate = delegate;
        this.exceptionMapper = exceptionMapper;
    }

    @Override
    public List<ResolutionAwareRepository> getRepositories() {
        return this.delegate.getRepositories();
    }

    @Override
    public ResolverResults resolveBuildDependencies(ResolveContext resolveContext) {
        try {
            return this.delegate.resolveBuildDependencies(resolveContext);
        }
        catch (Exception e) {
            return new BrokenResolverResults(this.exceptionMapper.contextualize(e, resolveContext));
        }
    }

    @Override
    public ResolverResults resolveGraph(ResolveContext resolveContext) throws ResolveException {
        ResolverResults results;
        try {
            results = this.delegate.resolveGraph(resolveContext);
        }
        catch (Exception e) {
            return new BrokenResolverResults(this.exceptionMapper.contextualize(e, resolveContext));
        }
        ErrorHandlingResolvedConfiguration wrappedConfiguration = new ErrorHandlingResolvedConfiguration(results.getResolvedConfiguration(), resolveContext, this.exceptionMapper);
        return DefaultResolverResults.graphResolved(results.getVisitedGraph(), results.getResolvedLocalComponents(), wrappedConfiguration, results.getVisitedArtifacts());
    }

    private static class BrokenResolvedConfiguration
    implements ResolvedConfiguration {
        private final ResolveException failure;

        public BrokenResolvedConfiguration(ResolveException failure) {
            this.failure = failure;
        }

        public boolean hasError() {
            return true;
        }

        public LenientConfiguration getLenientConfiguration() {
            throw this.failure;
        }

        public void rethrowFailure() throws ResolveException {
            throw this.failure;
        }

        public Set<File> getFiles() throws ResolveException {
            throw this.failure;
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
            throw this.failure;
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            throw this.failure;
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            throw this.failure;
        }

        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            throw this.failure;
        }
    }

    private static class BrokenMinimalResolutionResult
    implements MinimalResolutionResult {
        private final ResolveException failure;

        public BrokenMinimalResolutionResult(ResolveException failure) {
            this.failure = failure;
        }

        @Override
        public Supplier<ResolvedComponentResult> getRootSource() {
            return () -> {
                throw this.failure;
            };
        }

        @Override
        public ImmutableAttributes getRequestedAttributes() {
            throw this.failure;
        }
    }

    @VisibleForTesting
    public static class BrokenResolverResults
    implements ResolverResults {
        private final ResolveException failure;

        public BrokenResolverResults(ResolveException failure) {
            this.failure = failure;
        }

        @Override
        public ResolvedConfiguration getResolvedConfiguration() {
            return new BrokenResolvedConfiguration(this.failure);
        }

        @Override
        public VisitedGraphResults getVisitedGraph() {
            return new DefaultVisitedGraphResults(new BrokenMinimalResolutionResult(this.failure), Collections.emptySet(), this.failure);
        }

        @Override
        public VisitedArtifactSet getVisitedArtifacts() {
            throw this.failure;
        }

        @Override
        public ResolvedLocalComponentsResult getResolvedLocalComponents() {
            throw this.failure;
        }
    }

    private static class ErrorHandlingResolvedConfiguration
    implements ResolvedConfiguration {
        private final ResolvedConfiguration resolvedConfiguration;
        private final ResolveContext resolveContext;
        private final ResolveExceptionContextualizer contextualizer;

        public ErrorHandlingResolvedConfiguration(ResolvedConfiguration resolvedConfiguration, ResolveContext resolveContext, ResolveExceptionContextualizer contextualizer) {
            this.resolvedConfiguration = resolvedConfiguration;
            this.resolveContext = resolveContext;
            this.contextualizer = contextualizer;
        }

        public boolean hasError() {
            return this.resolvedConfiguration.hasError();
        }

        public LenientConfiguration getLenientConfiguration() {
            try {
                return new ErrorHandlingLenientConfiguration(this.resolvedConfiguration.getLenientConfiguration(), this.resolveContext, this.contextualizer);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public void rethrowFailure() throws ResolveException {
            try {
                this.resolvedConfiguration.rethrowFailure();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<File> getFiles() throws ResolveException {
            try {
                return this.resolvedConfiguration.getFiles();
            }
            catch (ResolveException e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFiles(dependencySpec);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            try {
                return this.resolvedConfiguration.getResolvedArtifacts();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }
    }

    private static class ErrorHandlingLenientConfiguration
    implements LenientConfiguration {
        private final LenientConfiguration lenientConfiguration;
        private final ResolveContext resolveContext;
        private final ResolveExceptionContextualizer contextualizer;

        private ErrorHandlingLenientConfiguration(LenientConfiguration lenientConfiguration, ResolveContext resolveContext, ResolveExceptionContextualizer contextualizer) {
            this.lenientConfiguration = lenientConfiguration;
            this.resolveContext = resolveContext;
            this.contextualizer = contextualizer;
        }

        public Set<ResolvedArtifact> getArtifacts() {
            try {
                return this.lenientConfiguration.getArtifacts();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getArtifacts(dependencySpec);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
            try {
                return this.lenientConfiguration.getFirstLevelModuleDependencies();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getAllModuleDependencies() {
            try {
                return this.lenientConfiguration.getAllModuleDependencies();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
            try {
                return this.lenientConfiguration.getUnresolvedModuleDependencies();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<File> getFiles() {
            try {
                return this.lenientConfiguration.getFiles();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getFiles(dependencySpec);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }
    }
}

