// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_MODULES_SCHEDULER_TASK_ATTRIBUTION_INFO_IMPL_H_
#define THIRD_PARTY_BLINK_RENDERER_MODULES_SCHEDULER_TASK_ATTRIBUTION_INFO_IMPL_H_

#include "third_party/blink/public/common/scheduler/task_attribution_id.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/modules/scheduler/script_wrappable_task_state.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/scheduler/public/task_attribution_info.h"
#include "third_party/blink/renderer/platform/wtf/casting.h"

namespace blink {
class AbortSignal;
class DOMTaskSignal;

class MODULES_EXPORT TaskAttributionInfoImpl final
    : public ScriptWrappableTaskState,
      public scheduler::TaskAttributionInfo {
 public:
  explicit TaskAttributionInfoImpl(scheduler::TaskAttributionId id);

  // `ScriptWrappableTaskState` implementation:
  AbortSignal* AbortSource() override;
  DOMTaskSignal* PrioritySource() override;
  scheduler::TaskAttributionInfo* GetTaskAttributionInfo() override;

  // `scheduler::TaskAttributionInfo` implementation:
  scheduler::TaskAttributionId Id() const override;

  void Trace(Visitor*) const override;

 private:
  const scheduler::TaskAttributionId id_;
};

// `TaskAttributionInfoImpl` is the only implementation of
// `scheduler::TaskAttributionInfo`, so this cast is always safe.
template <>
struct DowncastTraits<TaskAttributionInfoImpl> {
  static bool AllowFrom(const scheduler::TaskAttributionInfo&) { return true; }
};

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_MODULES_SCHEDULER_TASK_ATTRIBUTION_INFO_IMPL_H_
