/*
 * Decompiled with CFR 0.152.
 */
package plugin.network.gui;

import gmgen.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import pcgen.core.SettingsHandler;
import pcgen.system.LanguageBundle;
import plugin.network.NetworkModel;

public class PreferencesNetworkingPanel
extends PreferencesPanel {
    private NetworkModel model;
    private JPanel serverPanel;
    private JPanel clientPanel;
    private JTextField serverPort;
    private JTextField userName;

    public PreferencesNetworkingPanel(NetworkModel model) {
        this.initComponents();
        this.model = model;
        this.initPreferences();
    }

    public void setPortNumber(int port) {
        this.serverPort.setText(Integer.toString(port));
    }

    public int getPortNumber() {
        int port = 80;
        try {
            port = Integer.parseInt(this.serverPort.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public void setUserName(String username) {
        this.userName.setText(username);
    }

    public String getUserName() {
        return this.userName.getText();
    }

    public void applyPreferences() {
        SettingsHandler.setGMGenOption((String)"Network.port", (int)this.getPortNumber());
        SettingsHandler.setGMGenOption((String)"Network.username", (String)this.getUserName());
        this.model.applyPrefs();
    }

    public void initPreferences() {
        this.setPortNumber(SettingsHandler.getGMGenOption((String)"Network.port", (int)80));
        this.setUserName(SettingsHandler.getGMGenOption((String)"Network.username", (String)LanguageBundle.getString((String)"in_player")));
    }

    public String toString() {
        return LanguageBundle.getString((String)"in_plugin_network");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.serverPort = new JTextField(4);
        this.userName = new JTextField(10);
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        this.serverPanel = new JPanel();
        this.serverPanel.setLayout(new BoxLayout(this.serverPanel, 1));
        this.serverPanel.setBorder(new TitledBorder(LanguageBundle.getString((String)"in_plugin_network_server")));
        JLabel portLabel = new JLabel();
        portLabel.setText(LanguageBundle.getString((String)"in_plugin_network_port"));
        JPanel line1 = new JPanel();
        line1.setLayout(new FlowLayout(0));
        line1.add(portLabel);
        line1.add(this.serverPort);
        this.serverPanel.add(line1);
        topPanel.add(this.serverPanel);
        this.clientPanel = new JPanel();
        this.clientPanel.setLayout(new BoxLayout(this.clientPanel, 1));
        this.clientPanel.setBorder(new TitledBorder(LanguageBundle.getString((String)"in_plugin_network_client")));
        JLabel userLabel = new JLabel();
        userLabel.setText(LanguageBundle.getString((String)"in_plugin_network_username"));
        JPanel line2 = new JPanel();
        line2.setLayout(new FlowLayout(0));
        line2.add(userLabel);
        line2.add(this.userName);
        this.clientPanel.add(line2);
        topPanel.add(this.clientPanel);
        borderPanel.add((Component)topPanel, "North");
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setViewportView(borderPanel);
        this.add(jScrollPane1, "Center");
    }
}

