/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.spell;

import java.util.Collection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.PrimitiveToken;

public class SpellBookToken
implements PrimitiveToken<Spell>,
PrimitiveFilter<Spell> {
    private static final Class<Spell> SPELL_CLASS = Spell.class;
    private String spellbook;
    private CDOMReference<Spell> allSpells;

    public boolean initialize(LoadContext context, Class<Spell> cl, String value, String args) {
        if (args != null) {
            return false;
        }
        this.spellbook = value;
        this.allSpells = context.getReferenceContext().getCDOMAllReference(SPELL_CLASS);
        return true;
    }

    public String getTokenName() {
        return "SPELLBOOK";
    }

    public Class<Spell> getReferenceClass() {
        return SPELL_CLASS;
    }

    public String getLSTformat(boolean useAny) {
        return this.getTokenName() + "=" + this.spellbook;
    }

    public boolean allow(PlayerCharacter pc, Spell spell) {
        return pc.hasSpellInSpellbook(spell, this.spellbook);
    }

    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SpellBookToken) {
            SpellBookToken other = (SpellBookToken)obj;
            if (this.spellbook == null) {
                return other.spellbook == null;
            }
            return this.spellbook.equals(other.spellbook);
        }
        return false;
    }

    public int hashCode() {
        return this.spellbook == null ? -7 : this.spellbook.hashCode();
    }

    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<Spell, R> c) {
        return c.convert(this.allSpells, (PrimitiveFilter)this);
    }
}

