/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.util.Logging;

public final class LstFileLoader {
    public static final char LINE_COMMENT_CHAR = '#';
    public static final String LINE_SEPARATOR_REGEXP = "(\r\n?|\n)";

    private LstFileLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder readFromURI(URI uri) throws PersistenceLayerException {
        URL url;
        if (uri == null) {
            throw new PersistenceLayerException("LstFileLoader.readFromURI() received a null uri parameter!");
        }
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new PersistenceLayerException("LstFileLoader.readFromURI() could not convert parameter to a URL: " + e.getLocalizedMessage());
        }
        InputStream inputStream = null;
        StringBuilder dataBuffer = null;
        try {
            if (!CoreUtility.isNetURL(url) || SettingsHandler.isLoadURLs()) {
                char[] b;
                long fileSize;
                int size = 2048;
                if ("file".equals(url.getProtocol()) && (fileSize = new File(url.getPath()).length()) > 0L) {
                    size = (int)fileSize;
                }
                dataBuffer = new StringBuilder(size);
                inputStream = url.openStream();
                InputStreamReader ir = new InputStreamReader(inputStream, "UTF-8");
                int n = ir.read(b = new char[512], 0, 1);
                if (n == 1 && b[0] != '\ufeff') {
                    dataBuffer.append(b, 0, 1);
                }
                while ((n = ir.read(b)) > 0) {
                    dataBuffer.append(b, 0, n);
                }
            } else {
                ShowMessageDelegate.showMessageDialog("Preferences are currently set to NOT allow\nloading of sources from web links. \n" + url + " is a web link", "PCGen", MessageType.ERROR);
            }
        }
        catch (IOException ioe) {
            Logging.errorPrint("ERROR:" + url + "\n" + "Exception type:" + ioe.getClass().getName() + "\n" + "Message:" + ioe.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e2) {
                    Logging.errorPrint("Can't close inputStream in LstSystemLoader.initFile", e2);
                }
            }
        }
        return dataBuffer == null ? new StringBuilder() : dataBuffer;
    }
}

