/*
 * Decompiled with CFR 0.152.
 */
package pcgen.output.library;

import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;

public final class ObjectWrapperLibrary {
    private static final ObjectWrapperLibrary INSTANCE = new ObjectWrapperLibrary();
    private final List<ObjectWrapper> list = new ArrayList<ObjectWrapper>();

    private ObjectWrapperLibrary() {
    }

    public void add(ObjectWrapper ow) {
        if (ow == null) {
            throw new IllegalArgumentException("ObjectWrapper to add must not be null");
        }
        this.list.add(ow);
    }

    public TemplateModel wrap(Object o) throws TemplateModelException {
        for (ObjectWrapper ow : this.list) {
            try {
                return ow.wrap(o);
            }
            catch (TemplateModelException e) {
            }
        }
        throw new TemplateModelException("Unable to find wrapping for " + o.getClass());
    }

    public static ObjectWrapperLibrary getInstance() {
        return INSTANCE;
    }
}

