/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.base.util.DoubleKeyMap;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.tabs.AbilitiesInfoTab;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.CharacterSheetInfoTab;
import pcgen.gui2.tabs.ClassInfoTab;
import pcgen.gui2.tabs.CompanionInfoTab;
import pcgen.gui2.tabs.DescriptionInfoTab;
import pcgen.gui2.tabs.DomainInfoTab;
import pcgen.gui2.tabs.InventoryInfoTab;
import pcgen.gui2.tabs.RaceInfoTab;
import pcgen.gui2.tabs.SkillInfoTab;
import pcgen.gui2.tabs.SpellsInfoTab;
import pcgen.gui2.tabs.SummaryInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.TempBonusInfoTab;
import pcgen.gui2.tabs.TemplateInfoTab;
import pcgen.gui2.tabs.TodoHandler;
import pcgen.gui2.tools.CharacterSelectionListener;
import pcgen.gui2.util.DisplayAwareTab;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

public final class InfoTabbedPane
extends JTabbedPane
implements CharacterSelectionListener,
ChangeListener {
    public static final int SUMMARY_TAB = 0;
    public static final int RACE_TAB = 1;
    public static final int TEMPLATE_TAB = 2;
    public static final int CLASS_TAB = 3;
    public static final int SKILL_TAB = 4;
    public static final int ABILITIES_TAB = 5;
    public static final int DOMAIN_TAB = 6;
    public static final int SPELLS_TAB = 7;
    public static final int INVENTORY_TAB = 8;
    public static final int DESCRIPTION_TAB = 9;
    public static final int CHARACTER_SHEET_TAB = 10;
    private final DoubleKeyMap<CharacterFacade, CharacterInfoTab, CharacterInfoTab.ModelMap> stateMap;
    private final Map<CharacterFacade, Integer> tabSelectionMap;
    private final TabModelService modelService;
    private final List<CharacterInfoTab> fullTabList = new ArrayList<CharacterInfoTab>();
    private CharacterFacade currentCharacter = null;

    public InfoTabbedPane() {
        this.stateMap = new DoubleKeyMap();
        this.tabSelectionMap = new WeakHashMap<CharacterFacade, Integer>();
        this.modelService = new TabModelService();
        this.initComponent();
    }

    public void clearStateMap() {
        if (this.currentCharacter != null) {
            Map states = this.stateMap.getMapFor((Object)this.currentCharacter);
            for (CharacterInfoTab tab : states.keySet()) {
                tab.storeModels((CharacterInfoTab.ModelMap)states.get(tab));
            }
        }
        this.stateMap.clear();
        this.tabSelectionMap.clear();
        this.currentCharacter = null;
    }

    private void initComponent() {
        this.setTabPlacement(1);
        SummaryInfoTab tab = new SummaryInfoTab();
        this.addTab(tab);
        tab.addPropertyChangeListener(new TabActionListener(tab));
        this.addTab(new RaceInfoTab());
        this.addTab(new TemplateInfoTab());
        this.addTab(new ClassInfoTab());
        this.addTab(new SkillInfoTab());
        this.addTab(new AbilitiesInfoTab());
        this.addTab(new DomainInfoTab());
        this.addTab(new SpellsInfoTab());
        this.addTab(new InventoryInfoTab());
        this.addTab(new DescriptionInfoTab());
        this.addTab(new TempBonusInfoTab());
        this.addTab(new CompanionInfoTab());
        this.addTab(new CharacterSheetInfoTab());
        this.addChangeListener(this);
    }

    private <T extends Component> void addTab(T tab) {
        TabTitle tabTitle = ((CharacterInfoTab)((Object)tab)).getTabTitle();
        String title = (String)tabTitle.getValue("title");
        String tooltip = (String)tabTitle.getValue("tooltip");
        Icon icon = (Icon)tabTitle.getValue("icon");
        this.addTab(title, icon, tab, tooltip);
        this.fullTabList.add((CharacterInfoTab)((Object)tab));
        tabTitle.addPropertyChangeListener(new TabActionListener(tab));
    }

    @Override
    public void setCharacter(CharacterFacade character) {
        Map states;
        this.modelService.cancelRestoreTasks();
        if (!this.stateMap.containsKey((Object)character)) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                CharacterInfoTab tab = (CharacterInfoTab)((Object)this.getComponentAt(i));
                CharacterInfoTab.ModelMap models = tab.createModels(character);
                this.stateMap.put((Object)character, (Object)tab, (Object)models);
            }
            String key = "initialTab";
            key = UIPropertyContext.createCharacterPropertyKey(character, key);
            int startingTab = UIPropertyContext.getInstance().getInt(key, 0);
            this.tabSelectionMap.put(character, startingTab);
        }
        if (this.currentCharacter != null) {
            states = this.stateMap.getMapFor((Object)this.currentCharacter);
            this.modelService.storeModels(states);
            this.tabSelectionMap.put(this.currentCharacter, this.getSelectedIndex());
        }
        this.currentCharacter = character;
        states = this.stateMap.getMapFor((Object)character);
        this.updateTabsForCharacter(character);
        int selectedIndex = this.tabSelectionMap.get(character);
        this.modelService.restoreModels(states, selectedIndex);
    }

    private void updateTabsForCharacter(CharacterFacade character) {
        GameModeFacade gameMode = character.getDataSet().getGameMode();
        int tabIndex = 0;
        for (CharacterInfoTab charInfoTab : this.fullTabList) {
            TabTitle tabTitle = charInfoTab.getTabTitle();
            Tab tab = tabTitle.getTab();
            String newName = gameMode.getTabName(tab);
            if (!newName.equals(tabTitle.getValue("title"))) {
                tabTitle.putValue("title", newName);
            }
            if (gameMode.getTabShown(tab)) {
                if (this.getComponentAt(tabIndex) != charInfoTab) {
                    String title = (String)tabTitle.getValue("title");
                    String tooltip = (String)tabTitle.getValue("tooltip");
                    Icon icon = (Icon)tabTitle.getValue("icon");
                    this.insertTab(title, icon, (Component)((Object)charInfoTab), tooltip, tabIndex);
                }
                ++tabIndex;
                continue;
            }
            if (this.getComponentAt(tabIndex) != charInfoTab) continue;
            this.remove(tabIndex);
        }
    }

    private void switchTabsAndAdviseTodo(String[] dest) {
        Tab tab = Tab.valueOf(dest[0]);
        String tabName = this.currentCharacter.getDataSet().getGameMode().getTabName(tab);
        Component selTab = null;
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!tabName.equals(this.getTitleAt(i))) continue;
            this.setSelectedIndex(i);
            selTab = this.getComponent(i);
            break;
        }
        if (selTab == null) {
            Logging.errorPrint("Failed to find tab " + tabName);
            return;
        }
        if (selTab instanceof JTabbedPane && dest.length > 2) {
            JTabbedPane tabPane = (JTabbedPane)selTab;
            for (int i = 0; i < tabPane.getTabCount(); ++i) {
                if (!dest[2].equals(tabPane.getTitleAt(i))) continue;
                tabPane.setSelectedIndex(i);
                break;
            }
        }
        if (selTab instanceof TodoHandler) {
            ((TodoHandler)((Object)selTab)).adviseTodo(dest[1]);
        } else {
            String message = LanguageBundle.getFormattedString("in_todoUseField", dest[1]);
            JOptionPane.showMessageDialog(selTab, message, LanguageBundle.getString("in_tipsString"), 1);
        }
    }

    private void handleDisplayAware() {
        Component comp = this.getSelectedComponent();
        if (comp instanceof DisplayAwareTab) {
            ((DisplayAwareTab)((Object)comp)).tabSelected();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.handleDisplayAware();
    }

    public void characterRemoved(CharacterFacade character) {
        this.stateMap.removeAll((Object)character);
    }

    private class TabActionListener
    implements PropertyChangeListener {
        private Component component;

        public TabActionListener(Component component) {
            this.component = component;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int index = InfoTabbedPane.this.indexOfComponent(this.component);
            if (index < 0) {
                return;
            }
            String propName = evt.getPropertyName();
            if ("title".equals(propName)) {
                InfoTabbedPane.this.setTitleAt(index, (String)evt.getNewValue());
            } else if ("icon".equals(propName)) {
                InfoTabbedPane.this.setIconAt(index, (Icon)evt.getNewValue());
            } else if ("tooltip".equals(propName)) {
                InfoTabbedPane.this.setToolTipTextAt(index, (String)evt.getNewValue());
            } else if ("enabled".equals(propName)) {
                InfoTabbedPane.this.setEnabledAt(index, (Boolean)evt.getNewValue());
            } else if ("SwitchTabs".equals(propName)) {
                String destString = (String)evt.getNewValue();
                String[] dest = destString.split("/");
                InfoTabbedPane.this.switchTabsAndAdviseTodo(dest);
            }
        }
    }

    private class TabModelService
    extends ThreadPoolExecutor
    implements Comparator<CharacterInfoTab> {
        private final Map<CharacterInfoTab, Long> timingMap;
        private final Queue<CharacterInfoTab> storeQueue;
        private final Queue<Future<?>> restoreQueue;

        public TabModelService() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setPriority(5);
                    thread.setName("tab-info-thread");
                    return thread;
                }
            });
            this.timingMap = new HashMap<CharacterInfoTab, Long>();
            this.storeQueue = new LinkedList<CharacterInfoTab>();
            this.restoreQueue = new LinkedList();
        }

        @Override
        public int compare(CharacterInfoTab o1, CharacterInfoTab o2) {
            if (this.timingMap.containsKey(o1) && this.timingMap.containsKey(o2)) {
                long dif = this.timingMap.get(o1) - this.timingMap.get(o2);
                if (dif < 0L) {
                    return -1;
                }
                if (dif > 0L) {
                    return 1;
                }
            } else {
                if (this.timingMap.containsKey(o1)) {
                    return 1;
                }
                if (this.timingMap.containsKey(o2)) {
                    return -1;
                }
            }
            return 0;
        }

        private void restoreTab(CharacterInfoTab infoTab, CharacterInfoTab.ModelMap models) {
            long starttime = System.nanoTime();
            infoTab.restoreModels(models);
            long time = System.nanoTime() - starttime;
            this.timingMap.put(infoTab, time);
            this.storeQueue.add(infoTab);
        }

        public void restoreModels(Map<CharacterInfoTab, CharacterInfoTab.ModelMap> states, int selectedIndex) {
            CharacterInfoTab firstTab = (CharacterInfoTab)((Object)InfoTabbedPane.this.getComponentAt(selectedIndex));
            this.restoreTab(firstTab, states.get(firstTab));
            int oldSelectedIndex = InfoTabbedPane.this.getSelectedIndex();
            InfoTabbedPane.this.setSelectedIndex(selectedIndex);
            if (oldSelectedIndex == selectedIndex) {
                InfoTabbedPane.this.handleDisplayAware();
            }
            PriorityQueue<CharacterInfoTab> queue = new PriorityQueue<CharacterInfoTab>(states.keySet().size(), this);
            queue.addAll(states.keySet());
            queue.remove(firstTab);
            while (!queue.isEmpty()) {
                CharacterInfoTab infoTab = queue.poll();
                CharacterInfoTab.ModelMap models = states.get(infoTab);
                this.restoreQueue.add(this.submit(new RestoreModelsTask(infoTab, models)));
            }
        }

        public void storeModels(Map<CharacterInfoTab, CharacterInfoTab.ModelMap> states) {
            while (!this.storeQueue.isEmpty()) {
                CharacterInfoTab infoTab = this.storeQueue.poll();
                infoTab.storeModels(states.get(infoTab));
            }
        }

        public void cancelRestoreTasks() {
            while (!this.restoreQueue.isEmpty()) {
                this.restoreQueue.poll().cancel(true);
            }
        }

        private class RestoreModelsTask
        implements Runnable {
            private final CharacterInfoTab infoTab;
            private final CharacterInfoTab.ModelMap models;
            private boolean executed;

            public RestoreModelsTask(CharacterInfoTab infoTab, CharacterInfoTab.ModelMap models) {
                this.infoTab = infoTab;
                this.models = models;
                this.executed = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (!RestoreModelsTask.this.executed) {
                                TabModelService.this.restoreTab(RestoreModelsTask.this.infoTab, RestoreModelsTask.this.models);
                            }
                        }
                    });
                }
                catch (InterruptedException ex) {
                }
                catch (InvocationTargetException ex) {
                    Logging.errorPrint(null, ex.getCause());
                }
                finally {
                    this.executed = true;
                }
            }
        }
    }
}

