/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.ChangeProf;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.Globals;
import pcgen.core.WeaponProf;
import pcgen.rules.context.AbstractReferenceContext;

public class ChangeProfFacet
extends AbstractSourcedListFacet<CharID, ChangeProf>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        List<ChangeProf> list = cdo.getListFor(ListKey.CHANGEPROF);
        if (list != null) {
            this.addAll(dfce.getCharID(), list, cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public List<WeaponProf> getWeaponProfsInTarget(CharID id, CDOMGroupRef<WeaponProf> master) {
        String type = master.getLSTformat(false);
        if (!type.startsWith("TYPE=")) {
            throw new IllegalArgumentException("Cannot get targets for: " + type);
        }
        AbstractReferenceContext ref = Globals.getContext().getReferenceContext();
        ArrayList<WeaponProf> aList = new ArrayList<WeaponProf>();
        List<WeaponProf> weaponProfsOfType = Globals.getPObjectsOfType(ref.getConstructedCDOMObjects(WeaponProf.class), type);
        for (ChangeProf cp : this.getSet(id)) {
            if (cp.getResult().equals(master)) {
                aList.addAll(cp.getSource().getContainedObjects());
                continue;
            }
            if (weaponProfsOfType == null) continue;
            weaponProfsOfType.removeAll(cp.getSource().getContainedObjects());
        }
        aList.addAll(weaponProfsOfType);
        return aList;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }
}

