/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Dice;
import gmgen.plugin.SystemAttribute;
import gmgen.plugin.SystemInitiative;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;

public class PcgSystemInitiative
extends SystemInitiative {
    protected final PlayerCharacter pc;
    private final CharacterDisplay display;

    public PcgSystemInitiative(PlayerCharacter pc) {
        this.pc = pc;
        this.display = pc.getDisplay();
        PCStat stat = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, "DEX");
        this.attribute = new SystemAttribute("Dexterity", pc.getTotalStatFor(stat));
        this.bonus = 0;
        this.die = new Dice(1, 20);
    }

    @Override
    public SystemAttribute getAttribute() {
        PCStat stat = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, "DEX");
        return new SystemAttribute("Dexterity", this.pc.getTotalStatFor(stat));
    }

    @Override
    public void setBonus(int bonus) {
        this.bonus = bonus - this.display.initiativeMod();
        this.setCurrentInitiative(this.roll + this.getModifier() + this.mod);
    }

    @Override
    public int getBonus() {
        PCStat dex = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, "DEX");
        return this.display.initiativeMod() - this.pc.getStatModFor(dex) + this.bonus;
    }

    @Override
    public int getModifier() {
        return this.display.initiativeMod() + this.bonus;
    }
}

