/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.pe;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import net.charabia.jsmoothgen.pe.PEFile;

public class PEOldMSHeader
implements Cloneable {
    int e_cblp;
    int e_cp;
    int e_crlc;
    int e_cparhdr;
    int e_minalloc;
    int e_maxalloc;
    int e_ss;
    int e_sp;
    int e_csum;
    int e_ip;
    int e_cs;
    int e_lfarlc;
    int e_ovno;
    int[] e_res = new int[4];
    int e_oemid;
    int e_oeminfo;
    int[] e_res2 = new int[10];
    long e_lfanew;
    private PEFile m_pe;

    public PEOldMSHeader(PEFile pe) {
        this.m_pe = pe;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void read() throws IOException {
        int i;
        FileChannel ch = this.m_pe.getChannel();
        ByteBuffer mz = ByteBuffer.allocate(64);
        mz.order(ByteOrder.LITTLE_ENDIAN);
        ch.read(mz, 0L);
        mz.position(0);
        byte m = mz.get();
        byte z = mz.get();
        if (m != 77 || z == 90) {
            // empty if block
        }
        this.e_cblp = mz.getShort();
        this.e_cp = mz.getShort();
        this.e_crlc = mz.getShort();
        this.e_cparhdr = mz.getShort();
        this.e_minalloc = mz.getShort();
        this.e_maxalloc = mz.getShort();
        this.e_ss = mz.getShort();
        this.e_sp = mz.getShort();
        this.e_csum = mz.getShort();
        this.e_ip = mz.getShort();
        this.e_cs = mz.getShort();
        this.e_lfarlc = mz.getShort();
        this.e_ovno = mz.getShort();
        for (i = 0; i < 4; ++i) {
            this.e_res[i] = mz.getShort();
        }
        this.e_oemid = mz.getShort();
        this.e_oeminfo = mz.getShort();
        for (i = 0; i < 10; ++i) {
            this.e_res2[i] = mz.getShort();
        }
        this.e_lfanew = mz.getInt();
    }

    public void dump(PrintStream out) {
        out.println("MSHeader:");
        out.println("e_cblp: " + this.e_cblp + " // Bytes on last page of file //  2");
        out.println("e_cp: " + this.e_cp + " // Pages in file //  4");
        out.println("e_crlc: " + this.e_crlc + " // Relocations //  6");
        out.println("e_cparhdr: " + this.e_cparhdr + " // Size of header in paragraphs //  8");
        out.println("e_minalloc: " + this.e_minalloc + " // Minimum extra paragraphs needed //  A");
        out.println("e_maxalloc: " + this.e_maxalloc + " // Maximum extra paragraphs needed //  C");
        out.println("e_ss: " + this.e_ss + " // Initial (relative) SS value //  E");
        out.println("e_sp: " + this.e_sp + " // Initial SP value // 10");
        out.println("e_csum: " + this.e_csum + " // Checksum // 12");
        out.println("e_ip: " + this.e_ip + " // Initial IP value // 14");
        out.println("e_cs: " + this.e_cs + " // Initial (relative) CS value // 16");
        out.println("e_lfarlc: " + this.e_lfarlc + " // File address of relocation table // 18");
        out.println("e_ovno: " + this.e_ovno + " // Overlay number // 1A");
        out.println("e_oemid: " + this.e_oemid + " // OEM identifier (for e_oeminfo) // 24");
        out.println("e_oeminfo: " + this.e_oeminfo + " // OEM information; e_oemid specific // 26");
        out.println("e_lfanew: " + this.e_lfanew + " // File address of new exe header // 3C");
    }

    public ByteBuffer get() {
        int i;
        ByteBuffer mz = ByteBuffer.allocate(64);
        mz.order(ByteOrder.LITTLE_ENDIAN);
        mz.position(0);
        mz.put((byte)77);
        mz.put((byte)90);
        mz.putShort((short)this.e_cblp);
        mz.putShort((short)this.e_cp);
        mz.putShort((short)this.e_crlc);
        mz.putShort((short)this.e_cparhdr);
        mz.putShort((short)this.e_minalloc);
        mz.putShort((short)this.e_maxalloc);
        mz.putShort((short)this.e_ss);
        mz.putShort((short)this.e_sp);
        mz.putShort((short)this.e_csum);
        mz.putShort((short)this.e_ip);
        mz.putShort((short)this.e_cs);
        mz.putShort((short)this.e_lfarlc);
        mz.putShort((short)this.e_ovno);
        for (i = 0; i < 4; ++i) {
            mz.putShort((short)this.e_res[i]);
        }
        mz.putShort((short)this.e_oemid);
        mz.putShort((short)this.e_oeminfo);
        for (i = 0; i < 10; ++i) {
            mz.putShort((short)this.e_res2[i]);
        }
        mz.putInt((int)this.e_lfanew);
        mz.position(0);
        return mz;
    }
}

