/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.ActiveBasicButtonListener;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalButtonUI;

public class PlasticButtonUI
extends MetalButtonUI {
    private static final PlasticButtonUI INSTANCE = new PlasticButtonUI();
    private boolean borderPaintsFocus;
    private Insets focusInsets;

    public static ComponentUI createUI(JComponent b) {
        return INSTANCE;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.borderPaintsFocus = Boolean.TRUE.equals(UIManager.get(this.getPropertyPrefix() + "borderPaintsFocus"));
        this.focusInsets = UIManager.getInsets(this.getPropertyPrefix() + "focusInsets");
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new ActiveBasicButtonListener(b);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            AbstractButton b = (AbstractButton)c;
            if (this.isToolBarButton(b)) {
                c.setOpaque(false);
            } else if (b.isContentAreaFilled()) {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
                if (this.is3D(b)) {
                    Rectangle r = new Rectangle(1, 1, c.getWidth() - 2, c.getHeight() - 1);
                    PlasticUtils.add3DEffekt(g, r);
                }
            }
        }
        this.paint(g, c);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (this.borderPaintsFocus) {
            return;
        }
        int x = this.focusInsets.left;
        int y = this.focusInsets.top;
        int w = b.getWidth() - x - this.focusInsets.right;
        int h = b.getHeight() - y - this.focusInsets.bottom;
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
    }

    protected boolean isToolBarButton(AbstractButton b) {
        Container parent = b.getParent();
        return parent != null && (parent instanceof JToolBar || parent.getParent() instanceof JToolBar);
    }

    protected boolean is3D(AbstractButton b) {
        ButtonModel model = b.getModel();
        return PlasticUtils.is3D("Button.") && b.isBorderPainted() && model.isEnabled() && (!model.isPressed() || !model.isArmed());
    }
}

