/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.style;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.dialogs.core.style.Style;
import com.jgoodies.dialogs.core.style.StylePolicies;
import com.jgoodies.dialogs.core.style.StylePolicy;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public final class StyleManager {
    private static StylePolicy stylePolicy;
    private static Style style;
    private static LookAndFeel cachedLookAndFeel;

    private StyleManager() {
    }

    public static StylePolicy getStylePolicy() {
        return stylePolicy;
    }

    public static void setStylePolicy(StylePolicy newStylePolicy) {
        stylePolicy = Preconditions.checkNotNull(newStylePolicy, "The %s must not be null.", "style policy");
        StyleManager.getStyle();
    }

    public static Style getStyle() {
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        if (cachedLookAndFeel != currentLookAndFeel) {
            StyleManager.updateStyle(style);
            cachedLookAndFeel = currentLookAndFeel;
        }
        return style;
    }

    public static void setStyle(Style newStyle) {
        StyleManager.updateStyle(StyleManager.getStyle(), newStyle);
    }

    private static void updateStyle(Style oldStyle) {
        Style newStyle = StyleManager.getStylePolicy().getStyle(UIManager.getLookAndFeel());
        StyleManager.updateStyle(oldStyle, newStyle);
    }

    private static void updateStyle(Style oldStyle, Style newStyle) {
        if (oldStyle == newStyle) {
            return;
        }
        if (oldStyle != null) {
            oldStyle.uninitialize();
        }
        if (newStyle != null) {
            newStyle.initialize();
            newStyle.install(UIManager.getDefaults());
        }
        style = newStyle;
    }

    static {
        StyleManager.setStylePolicy(StylePolicies.getDefaultPolicy());
    }
}

