/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.wizard;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.action.ActionBean;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.CoreDialogResources;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.dialogs.core.pane.wizard.DefaultWizardPageModel;
import com.jgoodies.dialogs.core.pane.wizard.WizardModel;
import com.jgoodies.dialogs.core.pane.wizard.WizardPage;
import com.jgoodies.dialogs.core.pane.wizard.WizardPageModel;
import java.awt.event.ActionEvent;
import java.util.EventObject;

public abstract class AbstractWizardPageModel<WM extends WizardModel>
extends ActionBean
implements WizardPageModel {
    private final WM wizardModel;
    private final boolean backVisible;
    private boolean backEnabled;
    private final boolean nextVisible;
    private boolean nextEnabled;
    private String nextText;
    private final boolean finishVisible;
    private boolean finishEnabled;
    private String finishText;
    private final boolean cancelVisible;
    private boolean cancelEnabled;
    private String cancelText;
    private boolean cancelAllowed;

    public AbstractWizardPageModel(WM wizardModel, Buttons buttons) {
        this.wizardModel = (WizardModel)Preconditions.checkNotNull(wizardModel, "The %s must not be null.", "wizard model");
        Preconditions.checkNotNull(buttons, "The %s must not be null.", "button setup");
        this.backVisible = buttons.backVisible;
        this.backEnabled = buttons.backEnabled;
        this.nextVisible = buttons.nextVisible;
        this.nextEnabled = buttons.nextEnabled;
        this.nextText = buttons.nextText;
        this.finishVisible = buttons.finishVisible;
        this.finishEnabled = buttons.finishEnabled;
        this.finishText = buttons.finishText;
        this.cancelVisible = buttons.cancelVisible;
        this.cancelEnabled = buttons.cancelEnabled;
        this.cancelText = buttons.cancelText;
        this.cancelAllowed = buttons.cancelAllowed;
    }

    @Override
    public void onPageActivating() {
    }

    @Override
    public void onPageActivated() {
    }

    @Override
    public void onPageDeactivating() {
    }

    @Override
    public void onBackPerformed(ActionEvent evt) {
        this.goBack();
    }

    @Override
    public void onNextPerformed(ActionEvent evt) {
        this.goNext();
    }

    @Override
    public void onFinishPerformed(ActionEvent evt) {
        this.doFinish(evt);
    }

    @Override
    public void onCancelPerformed(ActionEvent evt) {
        this.doCancel(evt);
    }

    @Override
    public void onWindowClosing(EventObject evt) {
        if (this.isCancelVisible() && this.isCancelEnabled() || this.isCancelAllowed()) {
            this.onCancelPerformed(new ActionEvent(evt.getSource(), 1001, "window closing"));
        } else {
            this.rejectWindowClosing(evt);
        }
    }

    protected void rejectWindowClosing(EventObject evt) {
        ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(evt)).title(CoreDialogResources.getString("dialogs.wizard.rejectWindowClosing.title"), new Object[0])).mainInstructionText(CoreDialogResources.getString("dialogs.wizard.rejectWindowClosing.mainInstruction"), new Object[0]).contentText(CoreDialogResources.getString("dialogs.wizard.rejectWindowClosing.supplementalInstruction"), new Object[0]).commitCommands(CommandValue.CLOSE).cancelAllowed(true).preferredWidth(PreferredWidth.MEDIUM)).showDialog();
    }

    public void goBack() {
        WizardPage backPage = this.getBackPage();
        Preconditions.checkState(backPage != null, "Cannot go back to a null page; previous page must not be null.");
        this.getWizardModel().setWizardPage(backPage);
    }

    public void goNext() {
        WizardPage newPage = this.getNextPage();
        Preconditions.checkState(newPage != null, "Cannot go forward to a null page; next page must not be null.");
        WizardPage oldPage = this.getWizardModel().getWizardPage();
        if (newPage.getPageModel() instanceof DefaultWizardPageModel) {
            ((DefaultWizardPageModel)newPage.getPageModel()).setPreviousPage(oldPage);
        }
        this.getWizardModel().setWizardPage(newPage);
    }

    protected abstract WizardPage getBackPage();

    protected abstract WizardPage getNextPage();

    public void doFinish(EventObject evt) {
        this.getWizardModel().onFinishPerformed(evt);
    }

    public void doCancel(EventObject evt) {
        this.getWizardModel().onCancelPerformed(evt);
    }

    public final WM getWizardModel() {
        return this.wizardModel;
    }

    @Override
    public final boolean isBackEnabled() {
        return this.backEnabled;
    }

    public final void setBackEnabled(boolean newValue) {
        boolean oldValue = this.isBackEnabled();
        this.backEnabled = newValue;
        this.firePropertyChange("backEnabled", oldValue, newValue);
    }

    @Override
    public final boolean isBackVisible() {
        return this.backVisible;
    }

    @Override
    public final boolean isNextEnabled() {
        return this.nextEnabled;
    }

    public final void setNextEnabled(boolean newValue) {
        boolean oldValue = this.isNextEnabled();
        this.nextEnabled = newValue;
        this.firePropertyChange("nextEnabled", oldValue, newValue);
    }

    @Override
    public final boolean isNextVisible() {
        return this.nextVisible;
    }

    @Override
    public final String getNextText() {
        return this.nextText;
    }

    public final void setNextText(String newText) {
        Preconditions.checkNotBlank(newText, "The %s must not be null, empty, or whitespace.", "Next text");
        String oldText = this.getNextText();
        this.nextText = newText;
        this.firePropertyChange("nextText", oldText, newText);
    }

    public final void setNextText(CommandValue nextValue) {
        this.setNextText(nextValue.getMarkedText());
    }

    @Override
    public final boolean isFinishEnabled() {
        return this.finishEnabled;
    }

    public final void setFinishEnabled(boolean newValue) {
        boolean oldValue = this.isFinishEnabled();
        this.finishEnabled = newValue;
        this.firePropertyChange("finishEnabled", oldValue, newValue);
    }

    @Override
    public final boolean isFinishVisible() {
        return this.finishVisible;
    }

    @Override
    public final String getFinishText() {
        return this.finishText;
    }

    public final void setFinishText(String newText) {
        Preconditions.checkNotBlank(newText, "The %s must not be null, empty, or whitespace.", "Finish text");
        String oldText = this.getFinishText();
        this.finishText = newText;
        this.firePropertyChange("finishText", oldText, newText);
    }

    public final void setFinishText(CommandValue finishValue) {
        this.setFinishText(finishValue.getMarkedText());
    }

    @Override
    public final boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public final void setCancelEnabled(boolean newValue) {
        boolean oldValue = this.isCancelEnabled();
        this.cancelEnabled = newValue;
        this.firePropertyChange("cancelEnabled", oldValue, newValue);
    }

    @Override
    public final boolean isCancelVisible() {
        return this.cancelVisible;
    }

    @Override
    public final String getCancelText() {
        return this.cancelText;
    }

    public final void setCancelText(String newText) {
        Preconditions.checkNotBlank(newText, "The %s must not be null, empty, or whitespace.", "Cancel text");
        String oldText = this.getCancelText();
        this.cancelText = newText;
        this.firePropertyChange("cancelText", oldText, newText);
    }

    public final void setCancelText(CommandValue cancelValue) {
        this.setCancelText(cancelValue.getMarkedText());
    }

    @Override
    public final boolean isCancelAllowed() {
        return this.cancelAllowed;
    }

    public final void setCancelAllowed(boolean newValue) {
        boolean oldValue = this.isCancelAllowed();
        this.cancelAllowed = newValue;
        this.firePropertyChange("cancelAllowed", oldValue, newValue);
    }

    public static final class Buttons {
        private boolean backVisible = false;
        private boolean backEnabled = true;
        private boolean nextVisible = false;
        private boolean nextEnabled = true;
        private String nextText;
        private boolean finishVisible = false;
        private boolean finishEnabled = true;
        private String finishText;
        private boolean cancelVisible = false;
        private boolean cancelEnabled = true;
        private String cancelText;
        private boolean cancelAllowed = true;

        public Buttons(WizardButton ... visibleButtons) {
            Preconditions.checkNotNull(visibleButtons, "The %s must not be null.", "set of visible buttons");
            this.nextText = CoreDialogResources.getString("common.wizard.next");
            this.finishText = CoreDialogResources.getString("common.wizard.finish");
            this.cancelText = CommandValue.CANCEL.getMarkedText();
            this.configureVisibilityAndInitialEnablement(visibleButtons);
        }

        public Buttons backVisible(boolean visible) {
            this.backVisible = visible;
            return this;
        }

        public Buttons backEnabled(boolean enabled) {
            this.backEnabled = enabled;
            return this;
        }

        public Buttons nextVisible(boolean visible) {
            this.nextVisible = visible;
            return this;
        }

        public Buttons nextEnabled(boolean enabled) {
            this.nextEnabled = enabled;
            return this;
        }

        public Buttons nextText(String text) {
            this.nextText = text;
            return this;
        }

        public Buttons nextText(CommandValue value) {
            return this.nextText(value.getMarkedText());
        }

        public Buttons finishVisible(boolean visible) {
            this.finishVisible = visible;
            return this;
        }

        public Buttons finishEnabled(boolean enabled) {
            this.finishEnabled = enabled;
            return this;
        }

        public Buttons finishText(String text) {
            this.finishText = text;
            return this;
        }

        public Buttons finishText(CommandValue value) {
            return this.finishText(value.getMarkedText());
        }

        public Buttons cancelVisible(boolean visible) {
            this.cancelVisible = visible;
            return this;
        }

        public Buttons cancelEnabled(boolean enabled) {
            this.cancelEnabled = enabled;
            return this;
        }

        public Buttons cancelText(String text) {
            this.cancelText = text;
            return this;
        }

        public Buttons cancelText(CommandValue value) {
            return this.cancelText(value.getMarkedText());
        }

        public Buttons cancelAllowed(boolean allowed) {
            this.cancelAllowed = allowed;
            return this;
        }

        private void configureVisibilityAndInitialEnablement(WizardButton ... visibleButtons) {
            block10: for (WizardButton wizardButton : visibleButtons) {
                switch (wizardButton) {
                    case BACK: {
                        this.backVisible = true;
                        continue block10;
                    }
                    case BACK_DISABLED: {
                        this.backVisible = true;
                        this.backEnabled = false;
                        continue block10;
                    }
                    case NEXT: {
                        this.nextVisible = true;
                        continue block10;
                    }
                    case NEXT_DISABLED: {
                        this.nextVisible = true;
                        this.nextEnabled = false;
                        continue block10;
                    }
                    case FINISH: {
                        this.finishVisible = true;
                        continue block10;
                    }
                    case FINISH_DISABLED: {
                        this.finishVisible = true;
                        this.finishEnabled = false;
                        continue block10;
                    }
                    case CANCEL: {
                        this.cancelVisible = true;
                        continue block10;
                    }
                    case CANCEL_DISABLED: {
                        this.cancelVisible = true;
                        this.cancelEnabled = false;
                        continue block10;
                    }
                    default: {
                        throw new IllegalStateException("Unknown button type: " + (Object)((Object)wizardButton));
                    }
                }
            }
        }
    }

    public static enum WizardButton {
        BACK,
        BACK_DISABLED,
        NEXT,
        NEXT_DISABLED,
        FINISH,
        FINISH_DISABLED,
        CANCEL,
        CANCEL_DISABLED;

    }
}

