/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.spockframework.util.ReflectionUtil;

public abstract class HamcrestFacade {
    private static final boolean hamcrestAvailable = ReflectionUtil.isClassAvailable("org.hamcrest.Matcher");

    public static boolean isMatcher(Object obj) {
        return hamcrestAvailable && HamcrestFacadeImpl.isMatcher(obj);
    }

    public static boolean matches(Object matcher, Object value) {
        return HamcrestFacadeImpl.matches(matcher, value);
    }

    public static String getFailureDescription(Object matcher, Object value, String message) {
        return HamcrestFacadeImpl.getFailureDescription(matcher, value, message);
    }

    private static abstract class HamcrestFacadeImpl {
        static final Method describeMismatchMethod = ReflectionUtil.getMethodByName(Matcher.class, "describeMismatch");

        private HamcrestFacadeImpl() {
        }

        static boolean isMatcher(Object obj) {
            return obj instanceof Matcher;
        }

        static boolean matches(Object matcher, Object value) {
            return ((Matcher)matcher).matches(value);
        }

        static String getFailureDescription(Object matcher, Object value, String message) {
            StringDescription description = new StringDescription();
            if (message != null) {
                description.appendText(message);
                description.appendText("\n\n");
            }
            description.appendText("Expected: ").appendDescriptionOf((SelfDescribing)((Matcher)matcher));
            if (describeMismatchMethod == null) {
                description.appendText("\n     got: ").appendValue(value);
            } else {
                description.appendText("\n     but: ");
                ReflectionUtil.invokeMethod(matcher, describeMismatchMethod, value, description);
            }
            return description.toString();
        }
    }
}

