/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.Closeable;
import org.apache.tools.ant.BuildListener;
import org.gradle.api.Project;
import org.gradle.api.internal.project.AntBuilderFactory;
import org.gradle.api.internal.project.DefaultAntBuilder;
import org.gradle.api.internal.project.ant.AntLoggingAdapter;
import org.gradle.api.internal.project.ant.AntLoggingAdapterFactory;
import org.gradle.internal.concurrent.CompositeStoppable;

public class DefaultAntBuilderFactory
implements AntBuilderFactory,
Closeable {
    private final Project project;
    private final AntLoggingAdapterFactory loggingAdapterFactory;
    private final CompositeStoppable stoppable = new CompositeStoppable();

    public DefaultAntBuilderFactory(Project project, AntLoggingAdapterFactory loggingAdapterFactory) {
        this.project = project;
        this.loggingAdapterFactory = loggingAdapterFactory;
    }

    @Override
    public DefaultAntBuilder createAntBuilder() {
        AntLoggingAdapter loggingAdapter = (AntLoggingAdapter)this.loggingAdapterFactory.create();
        DefaultAntBuilder antBuilder = new DefaultAntBuilder(this.project, loggingAdapter);
        antBuilder.getProject().setBaseDir(this.project.getProjectDir());
        antBuilder.getProject().removeBuildListener((BuildListener)antBuilder.getProject().getBuildListeners().get(0));
        antBuilder.getProject().addBuildListener((BuildListener)loggingAdapter);
        this.stoppable.add((Object)antBuilder);
        return antBuilder;
    }

    @Override
    public void close() {
        this.stoppable.stop();
    }
}

