/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.AbstractPrologEngine;
import com.declarativa.interprolog.PrologImplementationPeer;
import com.declarativa.interprolog.PrologOperatorsContext;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.Recognizer;
import java.io.File;
import java.util.Properties;

public class YAPPeer
extends PrologImplementationPeer {
    public YAPPeer(AbstractPrologEngine abstractPrologEngine) {
        super(abstractPrologEngine);
        this.operators = new PrologOperatorsContext(PrologOperatorsContext.standardCommonOperators);
        this.systemName = "YAP";
    }

    public String getBinDirectoryProperty(Properties properties) {
        return properties.getProperty("YAP_BIN_DIRECTORY");
    }

    public String executablePath(String string) {
        return String.valueOf(string) + File.separator + "yap";
    }

    public String fetchPrologNumericVersion() {
        Object[] objectArray = this.engine.deterministicGoal("current_prolog_flag(version,V),atom_codes(V,[Y,A,P,Dash|Number]),atom_codes(Version,Number)", "[string(Version)]");
        return (String)objectArray[0];
    }

    public String[] alternativePrologExtensions(String string) {
        if (string.indexOf(46) != -1) {
            throw new IPException("Bad use of alternativePrologExtensions");
        }
        return new String[]{String.valueOf(string) + ".yap"};
    }

    public String prologBinToBaseDirectory(String string) {
        int n = (string = string.trim()).lastIndexOf(String.valueOf(File.separator) + "bin" + File.separator);
        if (n == -1) {
            throw new IPException("Can not determine base directory from " + string);
        }
        if ((string = string.substring(0, n)).endsWith(File.separator)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public Recognizer makePromptRecognizer() {
        return new Recognizer("?-");
    }

    public Recognizer makeBreakRecognizer() {
        return new Recognizer(" ?-");
    }

    public String interprologFilename() {
        return "yap/interprolog.yap";
    }

    public String visualizationFilename() {
        return "visualization.P";
    }

    public String unescapedFilePath(String string) {
        if (File.separatorChar != '\\' || string.indexOf(File.separator) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == File.separatorChar) {
                stringBuffer.append(c);
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isInterrupt(Object object) {
        return object.toString().indexOf("interprolog_interrupt") != -1;
    }
}

