/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.PrologEngineTest;
import com.declarativa.interprolog.PrologOutputListener;
import com.declarativa.interprolog.SubprocessEngine;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.IPPrologError;
import junit.framework.Assert;

public abstract class SubprocessEngineTest
extends PrologEngineTest {
    StringBuffer buffer;

    public SubprocessEngineTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.engine = this.buildNewEngine();
        this.thisID = this.engine.registerJavaObject((Object)this);
        this.loadTestFile();
        this.engine.waitUntilAvailable();
    }

    protected void tearDown() throws Exception {
        this.engine.shutdown();
    }

    public void testDeterministicGoal() {
        super.testDeterministicGoal();
        try {
            this.engine.waitUntilAvailable();
            this.engine.deterministicGoal("nowaythisisdefined");
            Assert.fail((String)"should raise an IPException... with undefined predicate message");
        }
        catch (IPException iPException) {
            Assert.assertTrue((String)"No more listeners", (((SubprocessEngine)this.engine).errorTrigger.numberListeners() == 0 ? 1 : 0) != 0);
        }
    }

    public void testManyEngines() {
        SubprocessEngine[] subprocessEngineArray = new SubprocessEngine[4];
        int n = 0;
        while (n < subprocessEngineArray.length) {
            subprocessEngineArray[n] = (SubprocessEngine)this.buildNewEngine();
            ++n;
        }
        int n2 = 0;
        while (n2 < subprocessEngineArray.length) {
            subprocessEngineArray[n2].waitUntilAvailable();
            ++n2;
        }
        int n3 = 0;
        while (n3 < subprocessEngineArray.length) {
            Assert.assertTrue((boolean)subprocessEngineArray[n3].deterministicGoal("true"));
            ++n3;
        }
        int n4 = 0;
        while (n4 < subprocessEngineArray.length) {
            subprocessEngineArray[n4].shutdown();
            ++n4;
        }
    }

    public void testOutputListening() {
        this.buffer = new StringBuffer();
        1 var1_1 = new 1();
        Assert.assertEquals((int)0, (int)((SubprocessEngine)this.engine).listeners.size());
        ((SubprocessEngine)this.engine).addPrologOutputListener(var1_1);
        Assert.assertEquals((int)1, (int)((SubprocessEngine)this.engine).listeners.size());
        this.engine.deterministicGoal("write('hello,'), write(' tester'), nl");
        this.engine.waitUntilAvailable();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.toString());
        }
        Assert.assertTrue((String)"printed something", (this.buffer.toString().indexOf("hello, tester") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"available", (boolean)this.engine.isAvailable());
        Assert.assertTrue((String)"detecting regular and break prompts", (boolean)((SubprocessEngine)this.engine).isDetectingPromptAndBreak());
        try {
            this.engine.deterministicGoal("thisIsUndefined");
            Assert.fail((String)"should have thrown exception showing undefined predicate");
        }
        catch (IPPrologError iPPrologError) {}
        this.engine.waitUntilAvailable();
        this.engine.waitUntilAvailable();
        ((SubprocessEngine)this.engine).removePrologOutputListener(var1_1);
        Assert.assertEquals((int)0, (int)((SubprocessEngine)this.engine).listeners.size());
    }

    private final class 1
    implements PrologOutputListener {
        public void print(String string) {
            SubprocessEngineTest.this.buffer.append(string);
        }

        /* synthetic */ 1() {
        }
    }
}

