/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;
import com.sun.j3d.utils.behaviors.interpolators.KBRotPosScaleSplinePathInterpolator;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import java.awt.Color;
import java.util.Iterator;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.ScaleInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TransparencyInterpolator;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import megamek.client.ui.AWT.boardview3d.BoardModel;
import megamek.client.ui.AWT.boardview3d.C;
import megamek.client.ui.AWT.boardview3d.EntityGroup;
import megamek.client.ui.AWT.boardview3d.LabelModel;
import megamek.client.ui.AWT.boardview3d.TileTextureManager;
import megamek.client.ui.AWT.boardview3d.ViewTransform;
import megamek.client.ui.AWT.util.PlayerColors;
import megamek.common.BattleArmor;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.UnitLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityModel
extends BranchGroup {
    Alpha alpha;
    TransformGroup facing;
    TransformGroup label;
    TransformGroup mech;

    static final Vector3d location(IHex iHex, Coords coords, int n, double d) {
        Vector3d vector3d = new Vector3d((Tuple3d)BoardModel.getHexLocation(coords, iHex.getElevation() + n));
        vector3d.z += d / 2.0 + 0.1;
        return vector3d;
    }

    static final Vector3d labelLocation(IHex iHex, Coords coords, int n) {
        return new Vector3d((Tuple3d)BoardModel.getHexLocation(coords, iHex.getElevation() + (n < 0 ? 0 : n)));
    }

    static final double facing(int n) {
        return -1.0471975511965976 * (double)n;
    }

    static final double pitch(Entity entity) {
        if (entity.isProne() && entity instanceof Mech) {
            return -1.5707963267948966;
        }
        return 0.0;
    }

    static final Vector3d scale(Entity entity) {
        if (entity.isProne() && entity instanceof Mech) {
            return new Vector3d(12.0, EntityModel.height(entity), 12.0);
        }
        return new Vector3d(12.0, 12.0, EntityModel.height(entity));
    }

    static final double height(Entity entity) {
        double d = 6.0 * (double)(entity.height() + 1);
        if (entity instanceof Infantry) {
            d = 2.0;
        }
        if (entity instanceof BattleArmor) {
            d = 3.0;
        }
        if (entity.isDestroyed()) {
            d = 1.0;
        }
        return d;
    }

    public EntityModel(Entity entity, TileTextureManager tileTextureManager, ViewTransform viewTransform, IGame iGame) {
        Shape3D shape3D;
        TransparencyInterpolator transparencyInterpolator;
        TransparencyAttributes transparencyAttributes;
        Appearance appearance;
        int n;
        Coords coords = entity.getPosition();
        IHex iHex = iGame.getBoard().getHex(coords);
        int n2 = entity.getElevation();
        int n3 = entity.getFacing();
        if (n3 == -1) {
            n3 = 0;
        }
        if ((n = entity.getSecondaryFacing()) == -1) {
            n = n3;
        }
        Color color = PlayerColors.getColor(entity.getOwner().getColorIndex());
        Color3f color3f = new Color3f(color);
        color3f.scale(0.5f);
        Color3f color3f2 = new Color3f(color);
        color3f2.scale(0.3f);
        Vector3d vector3d = EntityModel.scale(entity);
        Shape3D shape3D2 = tileTextureManager.getModel(entity);
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(EntityModel.pitch(entity));
        transform3D.setScale(vector3d);
        this.mech = new TransformGroup(transform3D);
        this.mech.addChild((Node)shape3D2);
        this.mech.setCapability(18);
        shape3D2 = new Transform3D();
        shape3D2.rotZ(EntityModel.facing(n3));
        shape3D2.setTranslation(EntityModel.location(iHex, coords, n2, EntityModel.height(entity)));
        this.facing = new TransformGroup((Transform3D)shape3D2);
        this.facing.setCapability(18);
        this.facing.addChild((Node)this.mech);
        if (entity.getECMRange() != -1) {
            int n4 = entity.getECMRange();
            appearance = new Appearance();
            appearance.setColoringAttributes(new ColoringAttributes(color3f, 2));
            transparencyAttributes = new TransparencyAttributes(2, 0.9f);
            transparencyAttributes.setCapability(3);
            appearance.setTransparencyAttributes(transparencyAttributes);
            transparencyInterpolator = new TransparencyInterpolator(C.halfAlpha, transparencyAttributes, 0.9f, 0.97f);
            transparencyInterpolator.setSchedulingBounds((Bounds)BoardModel.bounds);
            this.addChild((Node)transparencyInterpolator);
            appearance.setPolygonAttributes(C.noCull);
            shape3D = EntityModel.makeECMArea(n4);
            shape3D.setAppearance(appearance);
            shape3D.setPickable(false);
            this.facing.addChild((Node)shape3D);
            shape3D = EntityModel.makeECMBorder(n4);
            shape3D.setAppearance(appearance);
            shape3D.setPickable(false);
            this.facing.addChild((Node)shape3D);
            appearance = new Appearance();
            appearance.setColoringAttributes(new ColoringAttributes(color3f, 2));
            appearance.setLineAttributes(C.defLine);
            shape3D = EntityModel.makeECMOutline(n4);
            shape3D.setAppearance(appearance);
            shape3D.setPickable(false);
            this.facing.addChild((Node)shape3D);
        }
        transform3D = new Appearance();
        transform3D.setMaterial(new Material(new Color3f(color), C.black, color3f, C.white, 64.0f));
        appearance = new Cone();
        appearance.setAppearance((Appearance)transform3D);
        if (n3 != n) {
            transparencyAttributes = new TransformGroup();
            transparencyAttributes.setCapability(18);
            transparencyInterpolator = new ScaleInterpolator(C.dblAlpha, (TransformGroup)transparencyAttributes);
            transparencyInterpolator.setSchedulingBounds((Bounds)BoardModel.bounds);
            transparencyInterpolator.setMinimumScale(0.8f);
            transparencyInterpolator.setMaximumScale(1.25f);
            transparencyAttributes.addChild((Node)appearance);
            shape3D = new Transform3D();
            shape3D.rotZ(EntityModel.facing(n - n3));
            Vector3d vector3d2 = new Vector3d(0.0, 12.5, 0.0);
            shape3D.transform(vector3d2);
            shape3D.setTranslation(vector3d2);
            TransformGroup transformGroup = new TransformGroup((Transform3D)shape3D);
            transformGroup.addChild((Node)transparencyAttributes);
            transformGroup.addChild((Node)transparencyInterpolator);
            this.facing.addChild((Node)transformGroup);
        }
        this.label = new TransformGroup(new Transform3D(C.nullRot, EntityModel.labelLocation(iHex, coords, n2), 1.0));
        this.label.addChild(viewTransform.makeViewRelative((Node)new LabelModel(entity.getShortName(), C.white, color3f, LabelModel.BOLD), 13.5));
        this.label.setPickable(false);
        this.label.setCapability(18);
        this.addChild((Node)this.facing);
        this.addChild((Node)this.label);
        this.setCapability(17);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setUserData(entity);
    }

    void move(final Entity entity, Vector<UnitLocation> vector, IBoard iBoard) {
        UnitLocation unitLocation2;
        final int n = vector.size();
        KBKeyFrame[] kBKeyFrameArray = new KBKeyFrame[n + 1];
        KBKeyFrame[] kBKeyFrameArray2 = new KBKeyFrame[n + 1];
        KBKeyFrame[] kBKeyFrameArray3 = new KBKeyFrame[n + 1];
        int n2 = 0;
        Point3f point3f = new Point3f(1.0f, 1.0f, 1.0f);
        Point3f point3f2 = new Point3f();
        final Entity entity2 = (Entity)this.getUserData();
        final int n3 = entity2.isProne() ? 1 : n;
        float f = (float)(-EntityModel.pitch(entity2));
        float f2 = (float)(-EntityModel.pitch(entity));
        Point3f point3f3 = new Point3f((Tuple3d)EntityModel.scale(entity2));
        final Point3f point3f4 = new Point3f((Tuple3d)EntityModel.scale(entity));
        IHex iHex = iBoard.getHex(entity2.getPosition());
        int n4 = entity2.getFacing();
        if (n4 == -1) {
            n4 = 0;
        }
        kBKeyFrameArray[n2] = new KBKeyFrame((float)n2 * 1.0f / (float)n, 0, new Point3f((Tuple3d)EntityModel.location(iHex, entity2.getPosition(), entity2.getElevation(), EntityModel.height(n2 < n3 ? entity2 : entity))), 0.0f, 0.0f, (float)EntityModel.facing(n4), point3f, -1.0f, -0.7f, 0.2f);
        kBKeyFrameArray2[n2] = new KBKeyFrame((float)n2 * 1.0f / (float)n, 0, new Point3f((Tuple3d)EntityModel.labelLocation(iHex, entity2.getPosition(), entity2.getElevation())), 0.0f, 0.0f, 0.0f, point3f, -1.0f, -0.7f, 0.2f);
        kBKeyFrameArray3[n2] = new KBKeyFrame((float)n2 * 1.0f / (float)n, 0, point3f2, 0.0f, n2 < n3 ? f : f2, 0.0f, n2 < n3 ? point3f3 : point3f4, -1.0f, -0.7f, 0.2f);
        ++n2;
        for (UnitLocation unitLocation2 : vector) {
            iHex = iBoard.getHex(unitLocation2.getCoords());
            n4 = unitLocation2.getFacing();
            if (n4 == -1) {
                n4 = 0;
            }
            kBKeyFrameArray[n2] = new KBKeyFrame((float)n2 * 1.0f / (float)n, 0, new Point3f((Tuple3d)EntityModel.location(iHex, unitLocation2.getCoords(), unitLocation2.getElevation(), EntityModel.height(n2 < n3 ? entity2 : entity))), 0.0f, 0.0f, (float)EntityModel.facing(n4), point3f, -1.0f, -0.7f, 0.2f);
            kBKeyFrameArray2[n2] = new KBKeyFrame((float)n2 * 1.0f / (float)n, 0, new Point3f((Tuple3d)EntityModel.labelLocation(iHex, unitLocation2.getCoords(), unitLocation2.getElevation())), 0.0f, 0.0f, 0.0f, point3f, -1.0f, -0.7f, 0.2f);
            kBKeyFrameArray3[n2] = new KBKeyFrame((float)n2 * 1.0f / (float)n, 0, point3f2, 0.0f, n2 < n3 ? f : f2, 0.0f, n2 < n3 ? point3f3 : point3f4, -1.0f, -0.7f, 0.2f);
            ++n2;
        }
        this.setUserData(entity);
        this.alpha = new Alpha(1, (long)(500 * vector.size()));
        Iterator<UnitLocation> iterator = new KBRotPosScaleSplinePathInterpolator(this.alpha, this.facing, new Transform3D(), kBKeyFrameArray){

            public void computeTransform(float f, Transform3D transform3D) {
                super.computeTransform(f, transform3D);
                Vector3d vector3d = new Vector3d();
                transform3D.get(vector3d);
                Point3d point3d = new Point3d((Tuple3d)vector3d);
                double d = EntityModel.height((int)((float)n * f) < n3 ? entity2 : entity);
                point3d.z = point3d.z - d / 2.0 + (d - 6.0) + 3.0;
                EntityGroup entityGroup = (EntityGroup)this.getParent().getParent().getParent();
                if (f < 0.999f) {
                    entityGroup.removeC3LinksFor(entity);
                    entityGroup.addC3LinksFor(entity, point3d);
                } else {
                    entityGroup.update(entity);
                }
            }
        };
        unitLocation2 = new KBRotPosScaleSplinePathInterpolator(this.alpha, this.label, new Transform3D(), kBKeyFrameArray2);
        KBRotPosScaleSplinePathInterpolator kBRotPosScaleSplinePathInterpolator = new KBRotPosScaleSplinePathInterpolator(this.alpha, this.mech, new Transform3D(), kBKeyFrameArray3){

            public void computeTransform(float f, Transform3D transform3D) {
                if (f < 0.999f) {
                    super.computeTransform(f, transform3D);
                } else {
                    transform3D.rotX(EntityModel.pitch(entity));
                    transform3D.setScale(new Vector3d((Tuple3f)point3f4));
                }
            }
        };
        iterator.setSchedulingBounds((Bounds)BoardModel.bounds);
        unitLocation2.setSchedulingBounds((Bounds)BoardModel.bounds);
        kBRotPosScaleSplinePathInterpolator.setSchedulingBounds((Bounds)BoardModel.bounds);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild(iterator);
        branchGroup.addChild((Node)unitLocation2);
        branchGroup.addChild((Node)kBRotPosScaleSplinePathInterpolator);
        this.addChild((Node)branchGroup);
        this.alpha.setStartTime(System.currentTimeMillis() + 1000L);
    }

    private static final double[] makeECMCoords(int n) {
        double[] dArray = new double[18 * (2 * n + 1) + 3];
        int n2 = 0;
        double[] dArray2 = new double[]{(double)(-n) * 1.5 * BoardModel.HEX_SIDE_LENGTH - BoardModel.HEX_SIDE_LENGTH, (double)n * 30.0 / 2.0, 60.0};
        n2 = EntityModel.makeECMPart(n, n2, dArray, dArray2, -BoardModel.HEX_SIDE_LENGTH / 2.0, BoardModel.HEX_SIDE_LENGTH / 2.0, -15.0, -15.0);
        n2 = EntityModel.makeECMPart(n, n2, dArray, dArray2, BoardModel.HEX_SIDE_LENGTH / 2.0, BoardModel.HEX_SIDE_LENGTH, -15.0, 0.0);
        n2 = EntityModel.makeECMPart(n, n2, dArray, dArray2, BoardModel.HEX_SIDE_LENGTH, BoardModel.HEX_SIDE_LENGTH / 2.0, 0.0, 15.0);
        n2 = EntityModel.makeECMPart(n, n2, dArray, dArray2, BoardModel.HEX_SIDE_LENGTH / 2.0, -BoardModel.HEX_SIDE_LENGTH / 2.0, 15.0, 15.0);
        n2 = EntityModel.makeECMPart(n, n2, dArray, dArray2, -BoardModel.HEX_SIDE_LENGTH / 2.0, -BoardModel.HEX_SIDE_LENGTH, 15.0, 0.0);
        n2 = EntityModel.makeECMPart(n, n2, dArray, dArray2, -BoardModel.HEX_SIDE_LENGTH, -BoardModel.HEX_SIDE_LENGTH / 2.0, 0.0, -15.0);
        dArray[n2++] = dArray[0];
        dArray[n2++] = dArray[1];
        dArray[n2++] = dArray[2];
        return dArray;
    }

    private static final Shape3D makeECMArea(int n) {
        double[] dArray = EntityModel.makeECMCoords(n);
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(dArray);
        geometryInfo.setStripCounts(new int[]{dArray.length / 3});
        geometryInfo.setContourCounts(new int[]{1});
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geometryInfo);
        Stripifier stripifier = new Stripifier();
        stripifier.stripify(geometryInfo);
        return new Shape3D((Geometry)geometryInfo.getGeometryArray());
    }

    private static final Shape3D makeECMBorder(int n) {
        double[] dArray = EntityModel.makeECMCoords(n);
        double[] dArray2 = new double[dArray.length * 2];
        int n2 = 0;
        for (int i = 0; i < dArray.length; i += 3) {
            dArray2[n2++] = dArray[i];
            dArray2[n2++] = dArray[i + 1];
            dArray2[n2++] = dArray[i + 2];
            dArray2[n2++] = dArray[i];
            dArray2[n2++] = dArray[i + 1];
            dArray2[n2++] = -dArray[i + 2];
        }
        GeometryInfo geometryInfo = new GeometryInfo(4);
        geometryInfo.setCoordinates(dArray2);
        geometryInfo.setStripCounts(new int[]{dArray2.length / 3});
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geometryInfo);
        Stripifier stripifier = new Stripifier();
        stripifier.stripify(geometryInfo);
        return new Shape3D((Geometry)geometryInfo.getGeometryArray());
    }

    private static final Shape3D makeECMOutline(int n) {
        double[] dArray = EntityModel.makeECMCoords(n);
        LineStripArray lineStripArray = new LineStripArray(dArray.length, 1, new int[]{dArray.length / 3});
        lineStripArray.setCoordinates(0, dArray);
        return new Shape3D((Geometry)lineStripArray);
    }

    private static final int makeECMPart(int n, int n2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        dArray[n2++] = dArray2[0];
        dArray2[0] = dArray2[0] + d2;
        dArray[n2++] = dArray2[1];
        dArray2[1] = dArray2[1] + d4;
        dArray[n2++] = dArray2[2];
        for (int i = 0; i < n; ++i) {
            dArray[n2++] = dArray2[0];
            dArray2[0] = dArray2[0] + d;
            dArray[n2++] = dArray2[1];
            dArray2[1] = dArray2[1] + d3;
            dArray[n2++] = dArray2[2];
            dArray[n2++] = dArray2[0];
            dArray2[0] = dArray2[0] + d2;
            dArray[n2++] = dArray2[1];
            dArray2[1] = dArray2[1] + d4;
            dArray[n2++] = dArray2[2];
        }
        return n2;
    }

    boolean isMoving() {
        return this.alpha != null && !this.alpha.finished();
    }
}

