/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.provider.LockableSetProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.language.LibraryDependencies;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.DefaultLibraryDependencies;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.internal.DefaultSwiftComponent;
import org.gradle.language.swift.internal.DefaultSwiftSharedLibrary;
import org.gradle.language.swift.internal.DefaultSwiftStaticLibrary;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultSwiftLibrary
extends DefaultSwiftComponent
implements SwiftLibrary {
    private final ObjectFactory objectFactory;
    private final LockableSetProperty<Linkage> linkage;
    private final ConfigurationContainer configurations;
    private final Property<SwiftBinary> developmentBinary;
    private final DefaultLibraryDependencies dependencies;

    @Inject
    public DefaultSwiftLibrary(String name, ObjectFactory objectFactory, FileOperations fileOperations, ConfigurationContainer configurations) {
        super(name, fileOperations, objectFactory);
        this.objectFactory = objectFactory;
        this.configurations = configurations;
        this.developmentBinary = objectFactory.property(SwiftBinary.class);
        this.linkage = new LockableSetProperty(objectFactory.setProperty(Linkage.class));
        this.linkage.add((Object)Linkage.SHARED);
        this.dependencies = (DefaultLibraryDependencies)objectFactory.newInstance(DefaultLibraryDependencies.class, new Object[]{this.getNames().withSuffix("implementation"), this.getNames().withSuffix("api")});
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((String)"Swift library", (String)this.getName());
    }

    @Override
    public Configuration getImplementationDependencies() {
        return this.dependencies.getImplementationDependencies();
    }

    @Override
    public LibraryDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super LibraryDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    public SwiftStaticLibrary addStaticLibrary(String nameSuffix, boolean testable, SwiftPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, NativeVariantIdentity identity) {
        SwiftStaticLibrary result = (SwiftStaticLibrary)this.objectFactory.newInstance(DefaultSwiftStaticLibrary.class, new Object[]{this.getNames().append(nameSuffix), this.getModule(), testable, this.getSwiftSource(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity});
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    public SwiftSharedLibrary addSharedLibrary(String nameSuffix, boolean testable, SwiftPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, NativeVariantIdentity identity) {
        SwiftSharedLibrary result = (SwiftSharedLibrary)this.objectFactory.newInstance(DefaultSwiftSharedLibrary.class, new Object[]{this.getNames().append(nameSuffix), this.getModule(), testable, this.getSwiftSource(), this.configurations, this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity});
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    @Override
    public Configuration getApiDependencies() {
        return this.dependencies.getApiDependencies();
    }

    public Property<SwiftBinary> getDevelopmentBinary() {
        return this.developmentBinary;
    }

    public LockableSetProperty<Linkage> getLinkage() {
        return this.linkage;
    }
}

