/* Copyright (c) 1995 by Internet Software Consortium
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET SOFTWARE
 * CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* eventlib_p.h - private interfaces for eventlib
 * vix 09sep95 [initial]
 *
 * $Id: eventlib_p.h,v 1.1 1995/09/17 05:30:26 vixie Exp $
 */

#ifndef _EVENTLIB_P_H
#define _EVENTLIB_P_H

#include <sys/param.h>
#include <sys/types.h>

#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "eventlib_p.h"

#ifdef DEBUG
extern int evDebugLev;
#define	DPRINTF(l,a)	if (l <= evDebugLev) printf a
#else
#define DPRINTF(l,a)
#endif

#define ERR(e)		for (;;) { errno = (e); return (-1); }
#define OK(x)		if ((x) < 0) ERR(errno) else NULL;
#define	NEW(p)		if (((p) = malloc(sizeof *(p))) != NULL) \
				memset((p), 0xF5, sizeof *(p));
#define OKNEW(p)	if (!((p) = malloc(sizeof *(p)))) { \
				errno = ENOMEM; \
				return (-1); \
			} else \
				memset((p), 0xF5, sizeof *(p));

typedef struct evTimer {
	evTimerFunc	func;
	void		*uap;
	struct timeval	due, inter;
	struct evTimer	*next;
} evTimer;

typedef struct evFile {
	evFileFunc	func;
	void		*uap;
	int		fd;
	int		eventmask;
	struct evFile	*next;
} evFile;

typedef struct evSignal {
	evSignalFunc	func;
	void		*uap;
	int		sig;
	struct sigaction oact;
	struct evSignal *next;
} evSignal;

typedef struct {
	/* Timers. */
	evTimer		*timers;
	/* Files. */
	evFile	*files, *fdNext;
	fd_set		rdLast, rdNext;
	fd_set		wrLast, wrNext;
	fd_set		exLast, exNext;
	fd_set		nonblockBefore;
	int		fdMax, fdCount;
	/* Signals. */
	evSignal	*signals;
	sigset_t	blockedBefore;
} evContext_p;

typedef struct {
	enum {Timer, File, Signal} type;
	union {
		struct {
			evTimer		*this;
		} timer;
		struct {
			evFile		*this;
			int		eventmask;
		} file;
		struct {
			evSignal	*this;
		} signal;
	} u;
} evEvent_p;

/* timers.c */
#define evRelinkTimers __evRelinkTimers
int evRelinkTimers(evContext_p *ctx, evTimer *del, evTimer *add);

#endif /*_EVENTLIB_P_H*/
