/*
   Copyright (c) 2013 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2013:DUAL/GPL:standard
    
    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:
    
       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.
    
    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.
    
    :> 
*/             

#ifndef __SBPM_H_INCLUDED
#define __SBPM_H_INCLUDED

/*  File automatically generated by Reggae at 15/08/2013  10:55:11   */

#include "access_macros.h"
#include "packing.h"
#include "rdp_map.h"

/*****************************************************************************************/
/* The SRAM BPM (SBPM) is responsible for managing the pool of free SRAM buffers.   The  */
/* buffers are linked to each other in a linked list (each buffer points to the next buf */
/* fer).     The linked list is kept in a dedicated SRAM. Two kinds of linked lists are  */
/* kept:       	* Free buffers list - each time a buffer is given to one of the users, i */
/* t will be the buffer at the head of the list and the next buffer in the list          */
/*  will be marked as the new head. Each time a buffer is freed by one of the users, it  */
/* will be linked back to the list as the new tail.       	* Packet linked list - a list */
/*  per packet which hold the order of buffers in which each packet is stored.    The SB */
/* PM also supports flow control and decoupling of upstream/downstream/local switching r */
/* esources by managing buffers counters and configurable thresholds per user group.  Fo */
/* r maximum utilization of the memory for different packet size the allocation of memor */
/* y is handled in chunks of 128 bytes.                                                  */
/*****************************************************************************************/

/*****************************************************************************************/
/* Blocks offsets                                                                        */
/*****************************************************************************************/
/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define SBPM_BLOCK_REGS_OFFSET 	( 0x00000000 )
#define SBPM_BLOCK_REGS_ADDRESS	( SBPM_BLOCK_OFFSET + SBPM_BLOCK_REGS_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* init_free_list                                                                        */
/* request for building the free list using HW accelerator                               */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_INIT_FREE_LIST_RDY_DEFAULT_VALUE                           ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_RDY_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_BSY_NO_REQUEST_VALUE                        ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_BSY_NO_REQUEST_VALUE_RESET_VALUE            ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_BSY_REQUEST_IN_PROGRESS_VALUE               ( 0x1 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_RSV_DEFAULT_VALUE                           ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_RSV_DEFAULT_VALUE_RESET_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_INIT_EN_DEFAULT_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_INIT_EN_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_INIT_NUM_BN_DEFAULT_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_INIT_NUM_BN_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_INIT_HEAD_BN_ADDR_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_INIT_HEAD_BN_ADDR_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_INIT_FREE_LIST_OFFSET ( 0x00000000 )

#define SBPM_BLOCK_REGS_INIT_FREE_LIST_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_INIT_FREE_LIST_OFFSET )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_INIT_FREE_LIST_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_INIT_FREE_LIST_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_INIT_FREE_LIST_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ready */
	uint32_t rdy              	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t bsy              	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv              	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* init_en */
	uint32_t init_en          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* init_num_bn */
	uint32_t init_num_bn      	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* init_head_bn_addr */
	uint32_t init_head_bn_addr	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_INIT_FREE_LIST ;
#else
typedef struct
{	uint32_t init_head_bn_addr	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* init_head_bn_addr */
	uint32_t init_num_bn      	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* init_num_bn */
	uint32_t init_en          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* init_en */
	uint32_t rsv              	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t bsy              	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t rdy              	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ready */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_INIT_FREE_LIST ;
#endif

/*****************************************************************************************/
/* bn_alloc                                                                              */
/* request for a new buffer                                                              */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_BN_ALLOC_RSV2_RSV_VALUE                      ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RSV2_RSV_VALUE_RESET_VALUE          ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_SA_SOURCE_ADDRESS_VALUE             ( 0x6 )
#define SBPM_BLOCK_REGS_BN_ALLOC_SA_SOURCE_ADDRESS_VALUE_RESET_VALUE ( 0x6 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RSV1_DEFAULT_VALUE                  ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RSV1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )


#define SBPM_BLOCK_REGS_BN_ALLOC_OFFSET ( 0x00000004 )

#define SBPM_BLOCK_REGS_BN_ALLOC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_BN_ALLOC_OFFSET )
#define SBPM_BLOCK_REGS_BN_ALLOC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_BN_ALLOC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_BN_ALLOC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_BN_ALLOC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* source_address */
	uint32_t sa  	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_ALLOC ;
#else
typedef struct
{	uint32_t rsv1	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t sa  	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* source_address */
	uint32_t rsv2	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_ALLOC ;
#endif

/*****************************************************************************************/
/* bn_alloc_rply                                                                         */
/* reply for a new buffer alloc                                                          */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_RDY_DEFAULT_VALUE                        ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_RDY_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_BUSY_DEFAULT_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_BUSY_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_RSV_DEFAULT_VALUE                        ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_RSV_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_EXCL_DEFAULT_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_EXCL_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_NACK_DEFAULT_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_NACK_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_ACK_DEFAULT_VALUE                        ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_ACK_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_ALLOC_BN_DEFAULT_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_ALLOC_BN_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_ALLOC_BN_VALID_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_ALLOC_BN_VALID_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_OFFSET ( 0x00000008 )

#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_BN_ALLOC_RPLY_OFFSET )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_BN_ALLOC_RPLY_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_BN_ALLOC_RPLY_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_BN_ALLOC_RPLY_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rdy */
	uint32_t rdy           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t busy          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv           	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* excl */
	uint32_t excl          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* nack */
	uint32_t nack          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack */
	uint32_t ack           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_bn */
	uint32_t alloc_bn      	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_bn_valid */
	uint32_t alloc_bn_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_ALLOC_RPLY ;
#else
typedef struct
{	uint32_t alloc_bn_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_bn_valid */
	uint32_t alloc_bn      	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_bn */
	uint32_t ack           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack */
	uint32_t nack          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* nack */
	uint32_t excl          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* excl */
	uint32_t rsv           	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t busy          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t rdy           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rdy */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_ALLOC_RPLY ;
#endif

/*****************************************************************************************/
/* bn_free_with_contxt_low                                                               */
/* Request for freeing buffers of a packet offline with context (lower 32-bit)           */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_RSV3_RSV2_VALUE                     ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_RSV3_RSV2_VALUE_RESET_VALUE         ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_OFFSET_OFFSET_VALUE                 ( 0x1 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_OFFSET_OFFSET_VALUE_RESET_VALUE     ( 0x1 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_RSV2_RSV_VALUE                      ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_RSV2_RSV_VALUE_RESET_VALUE          ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_SA_SOURCE_ADDRESS_VALUE             ( 0x6 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_SA_SOURCE_ADDRESS_VALUE_RESET_VALUE ( 0x6 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_RSV1_DEFAULT_VALUE                  ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_RSV1_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_HEAD_BN_HEAD_BN_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_HEAD_BN_HEAD_BN_VALUE_RESET_VALUE   ( 0x0 )


#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_OFFSET ( 0x0000000C )

#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_OFFSET )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* offset */
	uint32_t offset 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv2   	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* source_address */
	uint32_t sa     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* head_bn */
	uint32_t head_bn	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW ;
#else
typedef struct
{	uint32_t head_bn	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* head_bn */
	uint32_t rsv1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t sa     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* source_address */
	uint32_t rsv2   	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t offset 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* offset */
	uint32_t rsv3   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW ;
#endif

/*****************************************************************************************/
/* bn_free_with_contxt_high                                                              */
/* Request for freeing buffers of a packet offline with context (higher 32-bit)          */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_RSV_RSERVED_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_RSV_RSERVED_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_LAST_BN_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_LAST_BN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_OFFSET ( 0x00000010 )

#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_OFFSET )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv    	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* last_BN */
	uint32_t last_bn	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH ;
#else
typedef struct
{	uint32_t last_bn	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* last_BN */
	uint32_t rsv    	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH ;
#endif

/*****************************************************************************************/
/* mcst_inc                                                                              */
/* Multicast counter increment. Contains the BN, which is head of the packet to be multi */
/* cast and its counter value                                                            */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_MCST_INC_RSV2_RESERVED_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_RSV2_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_ACK_REQ_ACK_REQ_VALUE               ( 0x1 )
#define SBPM_BLOCK_REGS_MCST_INC_ACK_REQ_ACK_REQ_VALUE_RESET_VALUE   ( 0x1 )
#define SBPM_BLOCK_REGS_MCST_INC_MCST_VAL_MCST_VAL_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_MCST_VAL_MCST_VAL_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_RSV1_RSERVED_VALUE                  ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_RSV1_RSERVED_VALUE_RESET_VALUE      ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_BN_BN_VALUE                         ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_BN_BN_VALUE_RESET_VALUE             ( 0x0 )


#define SBPM_BLOCK_REGS_MCST_INC_OFFSET ( 0x00000014 )

#define SBPM_BLOCK_REGS_MCST_INC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_MCST_INC_OFFSET )
#define SBPM_BLOCK_REGS_MCST_INC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_MCST_INC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_MCST_INC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_MCST_INC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t rsv2    	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack_req */
	uint32_t ack_req 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_val */
	uint32_t mcst_val	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv1    	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bufer_number */
	uint32_t bn      	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_MCST_INC ;
#else
typedef struct
{	uint32_t bn      	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bufer_number */
	uint32_t rsv1    	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t mcst_val	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_val */
	uint32_t ack_req 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack_req */
	uint32_t rsv2    	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_MCST_INC ;
#endif

/*****************************************************************************************/
/* mcst_inc_rply                                                                         */
/* mcst_inc_rply                                                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_MCST_INC_RPLY_RDY_DEFAULT_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_RPLY_RDY_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_RPLY_BSY_DEFAULT_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_RPLY_BSY_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_RPLY_RSV_DEFAULT_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_RPLY_RSV_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_RPLY_MCST_ACK_MCST_ACK_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_MCST_INC_RPLY_MCST_ACK_MCST_ACK_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_MCST_INC_RPLY_OFFSET ( 0x00000018 )

#define SBPM_BLOCK_REGS_MCST_INC_RPLY_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_MCST_INC_RPLY_OFFSET )
#define SBPM_BLOCK_REGS_MCST_INC_RPLY_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_MCST_INC_RPLY_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_MCST_INC_RPLY_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_MCST_INC_RPLY_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ready */
	uint32_t rdy     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t bsy     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv     	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_ack */
	uint32_t mcst_ack	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_MCST_INC_RPLY ;
#else
typedef struct
{	uint32_t mcst_ack	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_ack */
	uint32_t rsv     	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t bsy     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t rdy     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ready */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_MCST_INC_RPLY ;
#endif

/*****************************************************************************************/
/* bn_connect                                                                            */
/* request for connection between two buffers in a linked list. The connection request m */
/* ay be replied with ACK message if the ACK request bit is asserted.  This command is u */
/* sed as write command.                                                                 */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_BN_CONNECT_RSV_DEFAULT_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_RSV_DEFAULT_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_WR_REQ_WR_REQ_VALUE                     ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_WR_REQ_WR_REQ_VALUE_RESET_VALUE         ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_ACK_REQ_ACK_REQ_VALUE                   ( 0x1 )
#define SBPM_BLOCK_REGS_BN_CONNECT_ACK_REQ_ACK_REQ_VALUE_RESET_VALUE       ( 0x1 )
#define SBPM_BLOCK_REGS_BN_CONNECT_POINTED_BN_POINTED_BN_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_POINTED_BN_POINTED_BN_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_BN_BN_VALUE                             ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_BN_BN_VALUE_RESET_VALUE                 ( 0x0 )


#define SBPM_BLOCK_REGS_BN_CONNECT_OFFSET ( 0x0000001C )

#define SBPM_BLOCK_REGS_BN_CONNECT_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_BN_CONNECT_OFFSET )
#define SBPM_BLOCK_REGS_BN_CONNECT_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_BN_CONNECT_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_BN_CONNECT_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_BN_CONNECT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* wr_req */
	uint32_t wr_req    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack_req */
	uint32_t ack_req   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pointed_bn */
	uint32_t pointed_bn	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn */
	uint32_t bn        	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_CONNECT ;
#else
typedef struct
{	uint32_t bn        	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn */
	uint32_t pointed_bn	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pointed_bn */
	uint32_t ack_req   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack_req */
	uint32_t wr_req    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* wr_req */
	uint32_t rsv       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_CONNECT ;
#endif

/*****************************************************************************************/
/* bn_connect_rply                                                                       */
/* bn_connect_rply                                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_RDY_READY_BIT_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_RDY_READY_BIT_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_BUSY_BUSY_BIT_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_BUSY_BUSY_BIT_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_RSV_RSV_VALUE                             ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_RSV_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_CONNECT_ACK_CONNECT_ACK_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_CONNECT_ACK_CONNECT_ACK_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_OFFSET ( 0x00000020 )

#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_BN_CONNECT_RPLY_OFFSET )
#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_BN_CONNECT_RPLY_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_BN_CONNECT_RPLY_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_BN_CONNECT_RPLY_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rdy */
	uint32_t rdy        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t busy       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv        	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_ack */
	uint32_t connect_ack	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_CONNECT_RPLY ;
#else
typedef struct
{	uint32_t connect_ack	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_ack */
	uint32_t rsv        	: 29 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t busy       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t rdy        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rdy */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_CONNECT_RPLY ;
#endif

/*****************************************************************************************/
/* get_next                                                                              */
/* a pointer to a buffer in a packet linked list and request for the next buffer in the  */
/* list  this command is used as read command.                                           */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_GET_NEXT_RSV_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RSV_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_BN_BN_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_BN_BN_VALUE_RESET_VALUE       ( 0x0 )


#define SBPM_BLOCK_REGS_GET_NEXT_OFFSET ( 0x00000024 )

#define SBPM_BLOCK_REGS_GET_NEXT_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_GET_NEXT_OFFSET )
#define SBPM_BLOCK_REGS_GET_NEXT_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_GET_NEXT_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_GET_NEXT_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_GET_NEXT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bufer_number */
	uint32_t bn 	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_GET_NEXT ;
#else
typedef struct
{	uint32_t bn 	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bufer_number */
	uint32_t rsv	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_GET_NEXT ;
#endif

/*****************************************************************************************/
/* get_next_rply                                                                         */
/* get_next_rply                                                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_RDY_RDY_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_RDY_RDY_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_BUSY_BUSY_VALUE                     ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_BUSY_BUSY_VALUE_RESET_VALUE         ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_RSV_DEFAULT_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_RSV_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_MCNT_VAL_MCNT_VAL_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_MCNT_VAL_MCNT_VAL_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_BN_NULL_BN_NULL_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_BN_NULL_BN_NULL_VALUE_RESET_VALUE   ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_CONSTANT_CONSTANT_VALUE             ( 0x8 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_CONSTANT_CONSTANT_VALUE_RESET_VALUE ( 0x8 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_NEXT_BN_NEXT_BN_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_NEXT_BN_NEXT_BN_VALUE_RESET_VALUE   ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_BN_VALID_BN_VALID_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_BN_VALID_BN_VALID_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_OFFSET ( 0x00000028 )

#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_GET_NEXT_RPLY_OFFSET )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_GET_NEXT_RPLY_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_GET_NEXT_RPLY_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_GET_NEXT_RPLY_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rdy */
	uint32_t rdy     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t busy    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv     	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcnt_val */
	uint32_t mcnt_val	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_null */
	uint32_t bn_null 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* constant */
	uint32_t constant	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* next_bn */
	uint32_t next_bn 	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_valid */
	uint32_t bn_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_GET_NEXT_RPLY ;
#else
typedef struct
{	uint32_t bn_valid	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_valid */
	uint32_t next_bn 	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* next_bn */
	uint32_t constant	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* constant */
	uint32_t bn_null 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_null */
	uint32_t mcnt_val	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcnt_val */
	uint32_t rsv     	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t busy    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t rdy     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rdy */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_GET_NEXT_RPLY ;
#endif

/*****************************************************************************************/
/* bn_free_without_contxt                                                                */
/* bn_free_without_contxt                                                                */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_ACK_REQ_DEFAULT_VALUE               ( 0x1 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_ACK_REQ_DEFAULT_VALUE_RESET_VALUE   ( 0x1 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RSV2_RESERVED_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RSV2_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_SA_SOURCE_ADDRESS_VALUE             ( 0x6 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_SA_SOURCE_ADDRESS_VALUE_RESET_VALUE ( 0x6 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RSV1_RSV_VALUE                      ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RSV1_RSV_VALUE_RESET_VALUE          ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_HEAD_BN_HEAD_BN_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_HEAD_BN_HEAD_BN_VALUE_RESET_VALUE   ( 0x0 )


#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_OFFSET ( 0x00000038 )

#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_OFFSET )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ack_req */
	uint32_t ack_req	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv2   	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* source_address */
	uint32_t sa     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* head_bn */
	uint32_t head_bn	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT ;
#else
typedef struct
{	uint32_t head_bn	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* head_bn */
	uint32_t rsv1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t sa     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* source_address */
	uint32_t rsv2   	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ack_req	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack_req */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT ;
#endif

/*****************************************************************************************/
/* bn_free_without_contxt_rply                                                           */
/* bn_free_without_contxt_rply                                                           */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_RDY_READY_BIT_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_RDY_READY_BIT_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_BSY_BUSY_BIT_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_BSY_BUSY_BIT_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_RSV2_RESERVED_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_RSV2_RESERVED_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_EXCL_STAT_EXCL_STAT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_EXCL_STAT_EXCL_STAT_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_NACK_STAT_NACK_STAT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_NACK_STAT_NACK_STAT_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_ACK_STAT_ACK_STATUS_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_ACK_STAT_ACK_STATUS_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_RSV1_RSERVED_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_RSV1_RSERVED_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_FREE_ACK_FREE_ACK_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_FREE_ACK_FREE_ACK_VALUE_RESET_VALUE   ( 0x0 )


#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_OFFSET ( 0x0000003C )

#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_OFFSET )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rdy */
	uint32_t rdy      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bsy */
	uint32_t bsy      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv2     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* excl_stat */
	uint32_t excl_stat	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* nack_stat */
	uint32_t nack_stat	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack_stat */
	uint32_t ack_stat 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1     	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* free_ack */
	uint32_t free_ack 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY ;
#else
typedef struct
{	uint32_t free_ack 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* free_ack */
	uint32_t rsv1     	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ack_stat 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack_stat */
	uint32_t nack_stat	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* nack_stat */
	uint32_t excl_stat	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* excl_stat */
	uint32_t rsv2     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t bsy      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bsy */
	uint32_t rdy      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rdy */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY ;
#endif

/*****************************************************************************************/
/* bn_free_with_contxt_rply                                                              */
/* bn_free_with_contxt_rply                                                              */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_RDY_READY_BIT_VALUE                           ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_RDY_READY_BIT_VALUE_RESET_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_BUSY_BUSY_BIT_VALUE                           ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_BUSY_BUSY_BIT_VALUE_RESET_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_RSV2_RESERVED_VALUE                           ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_RSV2_RESERVED_VALUE_RESET_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_EXCL_STATE_EXCLUSIVE_STATUS_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_EXCL_STATE_EXCLUSIVE_STATUS_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_NACK_STATE_NACK_STATUS_VALUE                  ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_NACK_STATE_NACK_STATUS_VALUE_RESET_VALUE      ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_ACK_STATE_ACK_STATUS_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_ACK_STATE_ACK_STATUS_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_RSV1_RESERVED_VALUE                           ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_RSV1_RESERVED_VALUE_RESET_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_FREE_ACK_FREE_ACK_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_FREE_ACK_FREE_ACK_VALUE_RESET_VALUE           ( 0x0 )


#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_OFFSET ( 0x00000040 )

#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_OFFSET )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rdy */
	uint32_t rdy       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t busy      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv2      	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* excl_satate */
	uint32_t excl_state	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* nack_state */
	uint32_t nack_state	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack_state */
	uint32_t ack_state 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* free_ack */
	uint32_t free_ack  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY ;
#else
typedef struct
{	uint32_t free_ack  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* free_ack */
	uint32_t rsv1      	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ack_state 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ack_state */
	uint32_t nack_state	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* nack_state */
	uint32_t excl_state	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* excl_satate */
	uint32_t rsv2      	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t busy      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t rdy       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rdy */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY ;
#endif

/*****************************************************************************************/
/* SBPM_SP_EN                                                                            */
/* Source Port enable of SBPM allows configuration of active (ENABLED) ports that have d */
/* irect I/F to SBPM block. The client that was defined as disabled port (for example fi */
/* eld of EMAC4 = 0x0) will state in NACK state always till it will be enabled. All BBH  */
/* ports that goes from disable to enable state gets ACK message vaa broad see (SBPM spe */
/* c section 11.3.3)                                                                     */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_SP_EN_RSV4_RSV_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_RSV4_RSV_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH4_SP_EN_DISABLE_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH4_SP_EN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH4_SP_EN_ENABLE_VALUE              ( 0x1 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH3_SP_EN_DISABLE_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH3_SP_EN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH3_SP_EN_ENABLE_VALUE              ( 0x1 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH2_SP_EN_DISABLE_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH2_SP_EN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH2_SP_EN_ENABLE_VALUE              ( 0x1 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH1_SP_EN_DISABLE_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH1_SP_EN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH1_SP_EN_ENABLE_VALUE              ( 0x1 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH0_SP_EN_DISABLE_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH0_SP_EN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_ETH0_SP_EN_ENABLE_VALUE              ( 0x1 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_GPON_SP_EN_DISABLE_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_GPON_SP_EN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_GPON_SP_EN_ENABLE_VALUE              ( 0x1 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_RNRB_SP_EN_DISABLE_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_RNRB_SP_EN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_RNRB_SP_EN_ENABLE_VALUE              ( 0x1 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_RNRA_SP_EN_DISABLE_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_RNRA_SP_EN_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_RNRA_SP_EN_ENABLE_VALUE              ( 0x1 )


#define SBPM_BLOCK_REGS_SBPM_SP_EN_OFFSET ( 0x00000048 )

#define SBPM_BLOCK_REGS_SBPM_SP_EN_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_SP_EN_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_SP_EN_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_SP_EN_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_SP_EN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv4      	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH4_SP_EN */
	uint32_t eth4_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH3_SP_EN */
	uint32_t eth3_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH2_SP_EN */
	uint32_t eth2_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH1_SP_EN */
	uint32_t eth1_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH0_SP_EN */
	uint32_t eth0_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_SP_EN */
	uint32_t gpon_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_SP_EN */
	uint32_t rnrb_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_SP_EN */
	uint32_t rnra_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_SP_EN ;
#else
typedef struct
{	uint32_t rnra_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRA_SP_EN */
	uint32_t rnrb_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNRB_SP_EN */
	uint32_t gpon_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_SP_EN */
	uint32_t eth0_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH0_SP_EN */
	uint32_t eth1_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH1_SP_EN */
	uint32_t eth2_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH2_SP_EN */
	uint32_t eth3_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH3_SP_EN */
	uint32_t eth4_sp_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ETH4_SP_EN */
	uint32_t rsv4      	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_SP_EN ;
#endif

/*****************************************************************************************/
/* Global_Threshold                                                                      */
/* Global Threshold for Allocated Buffers.  SBPM will issue BN in the accepted range upo */
/* n to Global threshold setup.  Ths register also holds global hysteresis value for ACK */
/* /NACK transition setting                                                              */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_RSV2_RSV_VALUE                                             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_RSV2_RSV_VALUE_RESET_VALUE                                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_GL_BAH_GL_BAH_VALUE                                        ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_GL_BAH_GL_BAH_VALUE_RESET_VALUE                            ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_RSV_RSV_VALUE                                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_RSV_RSV_VALUE_RESET_VALUE                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_GL_BAT_GLOBAL_BUFFER_ALLOCATED_THRESHOLD_VALUE             ( 0x3FF )
#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_GL_BAT_GLOBAL_BUFFER_ALLOCATED_THRESHOLD_VALUE_RESET_VALUE ( 0x3FF )


#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_OFFSET ( 0x0000004C )

#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_GL_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_GL_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_GL_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_GL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv2 */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GL_BAH */
	uint32_t gl_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GL_BAT */
	uint32_t gl_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_GL_TRSH ;
#else
typedef struct
{	uint32_t gl_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GL_BAT */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t gl_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GL_BAH */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_GL_TRSH ;
#endif

/*****************************************************************************************/
/* UG0_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG0  Ths register also holds UG0 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_RSV2_RSV_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_RSV2_RSV_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_UG_BAH_UG0_BAH_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_UG_BAH_UG0_BAH_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_UG_BAT_UG0_BAT_VALUE             ( 0x3FF )
#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_UG_BAT_UG0_BAT_VALUE_RESET_VALUE ( 0x3FF )


#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_OFFSET ( 0x00000050 )

#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG0_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG0_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG0_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG0_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG0_TRSH ;
#else
typedef struct
{	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG0_TRSH ;
#endif

/*****************************************************************************************/
/* UG1_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG1  Ths register also holds UG1 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_RSV2_RSV_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_RSV2_RSV_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_UG_BAH_UG0_BAH_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_UG_BAH_UG0_BAH_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_UG_BAT_UG0_BAT_VALUE             ( 0x3FF )
#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_UG_BAT_UG0_BAT_VALUE_RESET_VALUE ( 0x3FF )


#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_OFFSET ( 0x00000054 )

#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG1_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG1_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG1_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG1_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG1_TRSH ;
#else
typedef struct
{	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG1_TRSH ;
#endif

/*****************************************************************************************/
/* UG2_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG2  Ths register also holds UG1 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_RSV2_RSV_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_RSV2_RSV_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_UG_BAH_UG0_BAH_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_UG_BAH_UG0_BAH_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_UG_BAT_UG0_BAT_VALUE             ( 0x3FF )
#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_UG_BAT_UG0_BAT_VALUE_RESET_VALUE ( 0x3FF )


#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_OFFSET ( 0x00000058 )

#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG2_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG2_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG2_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG2_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG2_TRSH ;
#else
typedef struct
{	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG2_TRSH ;
#endif

/*****************************************************************************************/
/* UG3_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG3  Ths register also holds UG3 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_RSV2_RSV_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_RSV2_RSV_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_UG_BAH_UG0_BAH_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_UG_BAH_UG0_BAH_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_UG_BAT_UG0_BAT_VALUE             ( 0x3FF )
#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_UG_BAT_UG0_BAT_VALUE_RESET_VALUE ( 0x3FF )


#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_OFFSET ( 0x0000005C )

#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG3_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG3_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG3_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG3_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG3_TRSH ;
#else
typedef struct
{	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG3_TRSH ;
#endif

/*****************************************************************************************/
/* UG4_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG4  Ths register also holds UG4 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_RSV2_RSV_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_RSV2_RSV_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_UG_BAH_UG0_BAH_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_UG_BAH_UG0_BAH_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_UG_BAT_UG0_BAT_VALUE             ( 0x3FF )
#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_UG_BAT_UG0_BAT_VALUE_RESET_VALUE ( 0x3FF )


#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_OFFSET ( 0x00000060 )

#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG4_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG4_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG4_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG4_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG4_TRSH ;
#else
typedef struct
{	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG4_TRSH ;
#endif

/*****************************************************************************************/
/* UG5_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG5  Ths register also holds UG5 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_RSV2_RSV_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_RSV2_RSV_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_UG_BAH_UG0_BAH_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_UG_BAH_UG0_BAH_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_UG_BAT_UG0_BAT_VALUE             ( 0x3FF )
#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_UG_BAT_UG0_BAT_VALUE_RESET_VALUE ( 0x3FF )


#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_OFFSET ( 0x00000064 )

#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG5_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG5_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG5_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG5_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG5_TRSH ;
#else
typedef struct
{	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG5_TRSH ;
#endif

/*****************************************************************************************/
/* UG6_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG6  Ths register also holds UG6 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_RSV2_RSV_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_RSV2_RSV_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_UG_BAH_UG0_BAH_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_UG_BAH_UG0_BAH_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_UG_BAT_UG0_BAT_VALUE             ( 0x3FF )
#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_UG_BAT_UG0_BAT_VALUE_RESET_VALUE ( 0x3FF )


#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_OFFSET ( 0x00000068 )

#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG6_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG6_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG6_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG6_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG6_TRSH ;
#else
typedef struct
{	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG6_TRSH ;
#endif

/*****************************************************************************************/
/* UG7_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG7  Ths register also holds UG6 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_RSV2_RSV_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_RSV2_RSV_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_UG_BAH_UG0_BAH_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_UG_BAH_UG0_BAH_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_UG_BAT_UG0_BAT_VALUE             ( 0x3FF )
#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_UG_BAT_UG0_BAT_VALUE_RESET_VALUE ( 0x3FF )


#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_OFFSET ( 0x0000006C )

#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG7_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG7_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG7_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG7_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG7_TRSH ;
#else
typedef struct
{	uint32_t ug_bat	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAT */
	uint32_t rsv   	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug_bah	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_BAH */
	uint32_t rsv2  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG7_TRSH ;
#endif

/*****************************************************************************************/
/* User_Group_map_register_0                                                             */
/* Each Source Port is mapped to specified UG. This register is using for mapping of SP  */
/* to UG07                                                                              */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_EMAC3_EMAC3_MAP_VALUE             ( 0x7 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_EMAC3_EMAC3_MAP_VALUE_RESET_VALUE ( 0x7 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_EMAC2_EMAC2_MAP_VALUE             ( 0x6 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_EMAC2_EMAC2_MAP_VALUE_RESET_VALUE ( 0x6 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_EMAC1_EMAC2_MAP_VALUE             ( 0x5 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_EMAC1_EMAC2_MAP_VALUE_RESET_VALUE ( 0x5 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_EMAC0_EMAC0_MAP_VALUE             ( 0x4 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_EMAC0_EMAC0_MAP_VALUE_RESET_VALUE ( 0x4 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_GPON_GPON_MAP_VALUE               ( 0x3 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_GPON_GPON_MAP_VALUE_RESET_VALUE   ( 0x3 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_RNRB_RNR_B_MAP_VALUE              ( 0x2 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_RNRB_RNR_B_MAP_VALUE_RESET_VALUE  ( 0x2 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_RNRA_RNR_A_MAP_VALUE              ( 0x1 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_RNRA_RNR_A_MAP_VALUE_RESET_VALUE  ( 0x1 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_CPU_CPU_MAP_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_CPU_CPU_MAP_VALUE_RESET_VALUE     ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_OFFSET ( 0x00000070 )

#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG_MAP_0_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG_MAP_0_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG_MAP_0_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG_MAP_0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* EMAC3_mapping */
	uint32_t emac3	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC2_mapping */
	uint32_t emac2	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC1_mapping */
	uint32_t emac1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC0_mapping */
	uint32_t emac0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_mapping */
	uint32_t gpon 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_B_mapping */
	uint32_t rnrb 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_A_mapping */
	uint32_t rnra 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CPU_mapping */
	uint32_t cpu  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG_MAP_0 ;
#else
typedef struct
{	uint32_t cpu  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CPU_mapping */
	uint32_t rnra 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_A_mapping */
	uint32_t rnrb 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_B_mapping */
	uint32_t gpon 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_mapping */
	uint32_t emac0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC0_mapping */
	uint32_t emac1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC1_mapping */
	uint32_t emac2	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC2_mapping */
	uint32_t emac3	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC3_mapping */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG_MAP_0 ;
#endif

/*****************************************************************************************/
/* SBPM_dbg                                                                              */
/* SBPM select the debug bus                                                             */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_DBG_RSV_RSV_VALUE                           ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_RSV_RSV_VALUE_RESET_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_SEL_DBG_DEFUALT_VALUE_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_SEL_DBG_DEFUALT_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_DBG_OFFSET ( 0x00000074 )

#define SBPM_BLOCK_REGS_SBPM_DBG_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_DBG_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_DBG_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_DBG_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_DBG_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_DBG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* select */
	uint32_t sel	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_DBG ;
#else
typedef struct
{	uint32_t sel	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* select */
	uint32_t rsv	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_DBG ;
#endif

/*****************************************************************************************/
/* SBPM_UG0_BAC                                                                          */
/* SBPM UG0 allocated BN counter                                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG0_BAC_RSV_RSV_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_BAC_RSV_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_BAC_UG0BAC_BAC_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_BAC_UG0BAC_BAC_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_UG0_BAC_OFFSET ( 0x00000078 )

#define SBPM_BLOCK_REGS_SBPM_UG0_BAC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG0_BAC_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG0_BAC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG0_BAC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG0_BAC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG0_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAC */
	uint32_t ug0bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG0_BAC ;
#else
typedef struct
{	uint32_t ug0bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAC */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG0_BAC ;
#endif

/*****************************************************************************************/
/* SBPM_UG1_BAC                                                                          */
/* SBPM UG1 allocated BN Counter                                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG1_BAC_RSV_RSV_VALUE                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_BAC_RSV_RSV_VALUE_RESET_VALUE       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_BAC_UG1BAC_UG1BAC_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_BAC_UG1BAC_UG1BAC_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_UG1_BAC_OFFSET ( 0x0000007C )

#define SBPM_BLOCK_REGS_SBPM_UG1_BAC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG1_BAC_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG1_BAC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG1_BAC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG1_BAC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG1_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t ug1bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG1_BAC ;
#else
typedef struct
{	uint32_t ug1bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG1_BAC ;
#endif

/*****************************************************************************************/
/* SBPM_UG2_BAC                                                                          */
/* SBPM UG2 allocated BN Counter                                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG2_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_BAC_UG2BAC_UG2_BAC_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_BAC_UG2BAC_UG2_BAC_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_UG2_BAC_OFFSET ( 0x00000080 )

#define SBPM_BLOCK_REGS_SBPM_UG2_BAC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG2_BAC_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG2_BAC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG2_BAC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG2_BAC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG2_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t ug2bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG2_BAC ;
#else
typedef struct
{	uint32_t ug2bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG2_BAC ;
#endif

/*****************************************************************************************/
/* SBPM_UG3_BAC                                                                          */
/* SBPM UG3 allocated BN Counter                                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG3_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_BAC_UG3BAC_UG3_BAC_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_BAC_UG3BAC_UG3_BAC_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_UG3_BAC_OFFSET ( 0x00000084 )

#define SBPM_BLOCK_REGS_SBPM_UG3_BAC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG3_BAC_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG3_BAC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG3_BAC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG3_BAC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG3_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG3_BAC */
	uint32_t ug3bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG3_BAC ;
#else
typedef struct
{	uint32_t ug3bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG3_BAC */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG3_BAC ;
#endif

/*****************************************************************************************/
/* SBPM_UG4_BAC                                                                          */
/* SBPM UG4 allocated BN Counter                                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG4_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_BAC_UG4BAC_UG4_BAC_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_BAC_UG4BAC_UG4_BAC_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_UG4_BAC_OFFSET ( 0x00000088 )

#define SBPM_BLOCK_REGS_SBPM_UG4_BAC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG4_BAC_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG4_BAC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG4_BAC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG4_BAC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG4_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t ug4bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG4_BAC ;
#else
typedef struct
{	uint32_t ug4bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG4_BAC ;
#endif

/*****************************************************************************************/
/* SBPM_UG5_BAC                                                                          */
/* SBPM UG5 allocated BN Counter                                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG5_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_BAC_UG5BAC_UG5_BAC_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_BAC_UG5BAC_UG5_BAC_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_UG5_BAC_OFFSET ( 0x0000008C )

#define SBPM_BLOCK_REGS_SBPM_UG5_BAC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG5_BAC_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG5_BAC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG5_BAC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG5_BAC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG5_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t ug5bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG5_BAC ;
#else
typedef struct
{	uint32_t ug5bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG5_BAC ;
#endif

/*****************************************************************************************/
/* SBPM_UG6_BAC                                                                          */
/* SBPM UG6 allocated BN Counter                                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG6_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_BAC_UG6BAC_UG6_BAC_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_BAC_UG6BAC_UG6_BAC_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_UG6_BAC_OFFSET ( 0x00000090 )

#define SBPM_BLOCK_REGS_SBPM_UG6_BAC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG6_BAC_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG6_BAC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG6_BAC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG6_BAC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG6_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t ug6bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG6_BAC ;
#else
typedef struct
{	uint32_t ug6bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG6_BAC ;
#endif

/*****************************************************************************************/
/* SBPM_UG7_BAC                                                                          */
/* SBPM UG7 allocated BN Counter                                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG7_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_BAC_UG7BAC_UG7_BAC_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_BAC_UG7BAC_UG7_BAC_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_UG7_BAC_OFFSET ( 0x00000094 )

#define SBPM_BLOCK_REGS_SBPM_UG7_BAC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG7_BAC_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG7_BAC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG7_BAC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG7_BAC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG7_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t ug7bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG7_BAC ;
#else
typedef struct
{	uint32_t ug7bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG7_BAC ;
#endif

/*****************************************************************************************/
/* SBPM_GL_BAC                                                                           */
/* SBPM global BN Counter                                                                */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_GL_BAC_RSV_RSV_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_GL_BAC_RSV_RSV_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_GL_BAC_BAC_BAC_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_GL_BAC_BAC_BAC_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_GL_BAC_OFFSET ( 0x00000098 )

#define SBPM_BLOCK_REGS_SBPM_GL_BAC_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_GL_BAC_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_GL_BAC_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_GL_BAC_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_GL_BAC_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_GL_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_GL_BAC ;
#else
typedef struct
{	uint32_t bac	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_GL_BAC ;
#endif

/*****************************************************************************************/
/* SBPM_UG0_Exclusive_threshold                                                          */
/* SBPM UG0 Exclusive high and hysteresis threshold                                      */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_RSV2_RSV2_VALUE                                                            ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_RSV2_RSV2_VALUE_RESET_VALUE                                                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_RSV_RSV_VALUE                                                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_RSV_RSV_VALUE_RESET_VALUE                                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE                 ( 0x300 )
#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE     ( 0x300 )


#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_OFFSET ( 0x0000009C )

#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH ;
#else
typedef struct
{	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* SBPM_UG1_Exclusive_threshold                                                          */
/* SBPM UG1 Exclusive high and hysteresis threshold                                      */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_RSV2_RSV2_VALUE                                                            ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_RSV2_RSV2_VALUE_RESET_VALUE                                                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_RSV_RSV_VALUE                                                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_RSV_RSV_VALUE_RESET_VALUE                                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE                 ( 0x300 )
#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE     ( 0x300 )


#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_OFFSET ( 0x00000100 )

#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH ;
#else
typedef struct
{	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* SBPM_UG2_Exclusive_threshold                                                          */
/* SBPM UG2 Exclusive high and hysteresis threshold                                      */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_RSV2_RSV2_VALUE                                                            ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_RSV2_RSV2_VALUE_RESET_VALUE                                                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_RSV_RSV_VALUE                                                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_RSV_RSV_VALUE_RESET_VALUE                                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE                 ( 0x300 )
#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE     ( 0x300 )


#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_OFFSET ( 0x00000104 )

#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH ;
#else
typedef struct
{	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* SBPM_UG3_Exclusive_threshold                                                          */
/* SBPM UG3 Exclusive high and hysteresis threshold                                      */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_RSV2_RSV2_VALUE                                                            ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_RSV2_RSV2_VALUE_RESET_VALUE                                                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_RSV_RSV_VALUE                                                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_RSV_RSV_VALUE_RESET_VALUE                                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE                 ( 0x300 )
#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE     ( 0x300 )


#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_OFFSET ( 0x00000108 )

#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH ;
#else
typedef struct
{	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* SBPM_UG4_Exclusive_threshold                                                          */
/* SBPM UG4 Exclusive high and hysteresis threshold                                      */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_RSV2_RSV2_VALUE                                                            ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_RSV2_RSV2_VALUE_RESET_VALUE                                                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_RSV_RSV_VALUE                                                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_RSV_RSV_VALUE_RESET_VALUE                                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE                 ( 0x300 )
#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE     ( 0x300 )


#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_OFFSET ( 0x0000010C )

#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH ;
#else
typedef struct
{	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* SBPM_UG5_Exclusive_threshold                                                          */
/* SBPM UG5 Exclusive high and hysteresis threshold                                      */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_RSV2_RSV2_VALUE                                                            ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_RSV2_RSV2_VALUE_RESET_VALUE                                                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_RSV_RSV_VALUE                                                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_RSV_RSV_VALUE_RESET_VALUE                                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE                 ( 0x300 )
#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE     ( 0x300 )


#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_OFFSET ( 0x00000110 )

#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH ;
#else
typedef struct
{	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* SBPM_UG6_Exclusive_threshold                                                          */
/* SBPM UG6 Exclusive high and hysteresis threshold                                      */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_RSV2_RSV2_VALUE                                                            ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_RSV2_RSV2_VALUE_RESET_VALUE                                                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_RSV_RSV_VALUE                                                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_RSV_RSV_VALUE_RESET_VALUE                                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE                 ( 0x300 )
#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE     ( 0x300 )


#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_OFFSET ( 0x00000114 )

#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH ;
#else
typedef struct
{	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* SBPM_UG7_Exclusive_threshold                                                          */
/* SBPM UG7 Exclusive high and hysteresis threshold                                      */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_RSV2_RSV2_VALUE                                                            ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_RSV2_RSV2_VALUE_RESET_VALUE                                                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE             ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_EXCLH_EXCLUSIVE_HYSTERES_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE ( 0x100 )
#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_RSV_RSV_VALUE                                                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_RSV_RSV_VALUE_RESET_VALUE                                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE                 ( 0x300 )
#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_EXCLT_EXCLUSIVE_HIGH_THRESHOLD_FOR_ALLOCATED_BUFFERS_VALUE_RESET_VALUE     ( 0x300 )


#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_OFFSET ( 0x00000118 )

#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH ;
#else
typedef struct
{	uint32_t exclt	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_high_threshold */
	uint32_t rsv  	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t exclh	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* exclusive_histeresis_threshold */
	uint32_t rsv2 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* User_Group_Status_register                                                            */
/* This register is status set of all 8 Ugs: Ack/NACK state and in addition Exclusive st */
/* ate pereach of 8 UGs                                                                  */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_RSV2_RSV_VALUE                         ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_RSV2_RSV_VALUE_RESET_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_UG_EXCL_STTS_UG_STAT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_UG_EXCL_STTS_UG_STAT_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_RSV1_RSV_VALUE                         ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_RSV1_RSV_VALUE_RESET_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_UG_ACK_STTS_UG_STAT_VALUE              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_UG_ACK_STTS_UG_STAT_VALUE_RESET_VALUE  ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_OFFSET ( 0x0000011C )

#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_UG_STATUS_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_UG_STATUS_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_UG_STATUS_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_UG_STATUS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2        	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_EXCL_STTS */
	uint32_t ug_excl_stts	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1        	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_ACK_STTS */
	uint32_t ug_ack_stts 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG_STATUS ;
#else
typedef struct
{	uint32_t ug_ack_stts 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_ACK_STTS */
	uint32_t rsv1        	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ug_excl_stts	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_EXCL_STTS */
	uint32_t rsv2        	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_UG_STATUS ;
#endif

/*****************************************************************************************/
/* SBPM_runner_status_message_control_register                                           */
/* BPM runner status message control register                                            */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_RSV_DEFAULT_VALUE                                                                          ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_RSV_DEFAULT_VALUE_RESET_VALUE                                                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_RNR_STAT_MSG_BASE_ADDR_BASE_ADDRESS_IN_RUNNER_FOR_STATUS_MESSAGE_SENDING_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_RNR_STAT_MSG_BASE_ADDR_BASE_ADDRESS_IN_RUNNER_FOR_STATUS_MESSAGE_SENDING_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_RNR_NUM_RUNNER_A_VALUE                                                                     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_RNR_NUM_RUNNER_A_VALUE_RESET_VALUE                                                         ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_RNR_NUM_RUNNER_B_VALUE                                                                     ( 0x1 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_STAT_MSG_EN_DEFAULT_VALUE                                                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_STAT_MSG_EN_DEFAULT_VALUE_RESET_VALUE                                                      ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_STAT_WKUP_EN_DEFAULT_VALUE                                                                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_STAT_WKUP_EN_DEFAULT_VALUE_RESET_VALUE                                                     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_TASK_NUM_DEFAULT_VALUE                                                                     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_TASK_NUM_DEFAULT_VALUE_RESET_VALUE                                                         ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_OFFSET ( 0x00000120 )

#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv                   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_status_message_base_addr */
	uint32_t rnr_stat_msg_base_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_num */
	uint32_t rnr_num               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* send_status_message_enable */
	uint32_t stat_msg_en           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* send_status_Wake_Up_enable */
	uint32_t stat_wkup_en          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t task_num              	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL ;
#else
typedef struct
{	uint32_t task_num              	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t stat_wkup_en          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* send_status_Wake_Up_enable */
	uint32_t stat_msg_en           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* send_status_message_enable */
	uint32_t rnr_num               	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_num */
	uint32_t rnr_stat_msg_base_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_status_message_base_addr */
	uint32_t rsv                   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL ;
#endif

/*****************************************************************************************/
/* Runner_Target_address_for_Reply_message                                               */
/* Runner Target address for Reply message as results of Alloc request from Runner. The  */
/* register is  for runner A and B                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_RSV_DEFAULT_VALUE                                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_RSV_DEFAULT_VALUE_RESET_VALUE                     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_RNR_REPLY_MSG_BASE_ADDR_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_RNR_REPLY_MSG_BASE_ADDR_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_OFFSET ( 0x00000124 )

#define SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv                    	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Target_address_for_Runner_A_B */
	uint32_t rnr_reply_msg_base_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA ;
#else
typedef struct
{	uint32_t rnr_reply_msg_base_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Target_address_for_Runner_A_B */
	uint32_t rsv                    	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA ;
#endif

/*****************************************************************************************/
/* sbpm_rnr_wkup_rply_set_0                                                              */
/* sbpm_rnr_wkup_rply_set 0                                                              */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_RSV_DEFAULT_VALUE                             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_RSV_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_MCST_WAKE_UP_EN_DEFAULT_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_MCST_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_GET_NEXT_WAKE_UP_EN_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_GET_NEXT_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_CONNECT_WAKE_UP_EN_DEFAULT_VALUE              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_CONNECT_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_ALLOC_WAKE_UP_EN_DEFAULT_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_ALLOC_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_TASK_NUM_DEFAULT_VALUE                        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_TASK_NUM_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_OFFSET ( 0x00000128 )

#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv                	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_wake_up_en */
	uint32_t mcst_wake_up_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_wake_up_en */
	uint32_t get_next_wake_up_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_wake_up_en */
	uint32_t connect_wake_up_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_wake_up_en */
	uint32_t alloc_wake_up_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t task_num           	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0 ;
#else
typedef struct
{	uint32_t task_num           	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t alloc_wake_up_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_wake_up_en */
	uint32_t connect_wake_up_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_wake_up_en */
	uint32_t get_next_wake_up_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_wake_up_en */
	uint32_t mcst_wake_up_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_wake_up_en */
	uint32_t rsv                	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0 ;
#endif

/*****************************************************************************************/
/* sbpm_rnr_wkup_rply_set_1                                                              */
/* sbpm_rnr_wkup_rply_set 1                                                              */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_RSV_DEFAULT_VALUE                             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_RSV_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_MCST_WAKE_UP_EN_DEFAULT_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_MCST_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_GET_NEXT_WAKE_UP_EN_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_GET_NEXT_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_CONNECT_WAKE_UP_EN_DEFAULT_VALUE              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_CONNECT_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_ALLOC_WAKE_UP_EN_DEFAULT_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_ALLOC_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_TASK_NUM_DEFAULT_VALUE                        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_TASK_NUM_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_OFFSET ( 0x0000012C )

#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv                	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_wake_up_en */
	uint32_t mcst_wake_up_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_wake_up_en */
	uint32_t get_next_wake_up_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_wake_up_en */
	uint32_t connect_wake_up_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_wake_up_en */
	uint32_t alloc_wake_up_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t task_num           	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1 ;
#else
typedef struct
{	uint32_t task_num           	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t alloc_wake_up_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_wake_up_en */
	uint32_t connect_wake_up_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_wake_up_en */
	uint32_t get_next_wake_up_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_wake_up_en */
	uint32_t mcst_wake_up_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_wake_up_en */
	uint32_t rsv                	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1 ;
#endif

/*****************************************************************************************/
/* sbpm_rnr_wkup_rply_set_2                                                              */
/* sbpm_rnr_wkup_rply_set 2                                                              */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_RSV_DEFAULT_VALUE                             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_RSV_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_MCST_WAKE_UP_EN_DEFAULT_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_MCST_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_GET_NEXT_WAKE_UP_EN_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_GET_NEXT_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_CONNECT_WAKE_UP_EN_DEFAULT_VALUE              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_CONNECT_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_ALLOC_WAKE_UP_EN_DEFAULT_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_ALLOC_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_TASK_NUM_DEFAULT_VALUE                        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_TASK_NUM_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_OFFSET ( 0x00000130 )

#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv                	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_wake_up_en */
	uint32_t mcst_wake_up_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_wake_up_en */
	uint32_t get_next_wake_up_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_wake_up_en */
	uint32_t connect_wake_up_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_wake_up_en */
	uint32_t alloc_wake_up_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t task_num           	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2 ;
#else
typedef struct
{	uint32_t task_num           	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t alloc_wake_up_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_wake_up_en */
	uint32_t connect_wake_up_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_wake_up_en */
	uint32_t get_next_wake_up_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_wake_up_en */
	uint32_t mcst_wake_up_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_wake_up_en */
	uint32_t rsv                	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2 ;
#endif

/*****************************************************************************************/
/* sbpm_rnr_wkup_rply_set_3                                                              */
/* sbpm_rnr_wkup_rply_set 3                                                              */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_RSV_DEFAULT_VALUE                             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_RSV_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_MCST_WAKE_UP_EN_DEFAULT_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_MCST_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_GET_NEXT_WAKE_UP_EN_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_GET_NEXT_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_CONNECT_WAKE_UP_EN_DEFAULT_VALUE              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_CONNECT_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_ALLOC_WAKE_UP_EN_DEFAULT_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_ALLOC_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_TASK_NUM_DEFAULT_VALUE                        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_TASK_NUM_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_OFFSET ( 0x00000134 )

#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv                	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_wake_up_en */
	uint32_t mcst_wake_up_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_wake_up_en */
	uint32_t get_next_wake_up_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_wake_up_en */
	uint32_t connect_wake_up_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_wake_up_en */
	uint32_t alloc_wake_up_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t task_num           	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3 ;
#else
typedef struct
{	uint32_t task_num           	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t alloc_wake_up_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_wake_up_en */
	uint32_t connect_wake_up_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_wake_up_en */
	uint32_t get_next_wake_up_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_wake_up_en */
	uint32_t mcst_wake_up_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_wake_up_en */
	uint32_t rsv                	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3 ;
#endif

/*****************************************************************************************/
/* error_handling_params                                                                 */
/* Parameters and thresholds used for Error handling: error detection, max search enable */
/*  and threshold, etc.                                                                  */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_RSV_RESERVED_VALUE                            ( 0x0 )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_RSV_RESERVED_VALUE_RESET_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_FREEZE_IN_ERROR_FREEZE_EN_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_FREEZE_IN_ERROR_FREEZE_EN_VALUE_RESET_VALUE   ( 0x0 )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_CHCK_LAST_EN_CHCK_LAST_EN_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_CHCK_LAST_EN_CHCK_LAST_EN_VALUE_RESET_VALUE   ( 0x0 )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_MAX_SEARCH_EN_MAX_SEARCH_EN_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_MAX_SEARCH_EN_MAX_SEARCH_EN_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_SEARCH_DEPTH_SEARCH_DEPTH_VALUE               ( 0x4 )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_SEARCH_DEPTH_SEARCH_DEPTH_VALUE_RESET_VALUE   ( 0x4 )


#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_OFFSET ( 0x00000138 )

#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_OFFSET )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t rsv            	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* freeze_in_error */
	uint32_t freeze_in_error	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* chck_last_en */
	uint32_t chck_last_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_search_en */
	uint32_t max_search_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* search_depth */
	uint32_t search_depth   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS ;
#else
typedef struct
{	uint32_t search_depth   	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* search_depth */
	uint32_t max_search_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_search_en */
	uint32_t chck_last_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* chck_last_en */
	uint32_t freeze_in_error	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* freeze_in_error */
	uint32_t rsv            	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS ;
#endif

/*****************************************************************************************/
/* SBPM_ISR                                                                              */
/* SBPM ISR (Interrupt Status register)                                                  */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_ISR_RSV_RESERVED_VALUE                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ISR_RSV_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ISR_MAX_SEARCH_ERR_MAX_SEARCH_ERR_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ISR_MAX_SEARCH_ERR_MAX_SEARCH_ERR_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ISR_CHECK_LAST_ERR_CHECK_LAST_ERR_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ISR_CHECK_LAST_ERR_CHECK_LAST_ERR_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ISR_MCST_OVERFLOW_MC_OVERFLOW_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ISR_MCST_OVERFLOW_MC_OVERFLOW_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ISR_BAC_UNDERRUN_BAC_UNDERRUN_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ISR_BAC_UNDERRUN_BAC_UNDERRUN_VALUE_RESET_VALUE     ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_ISR_OFFSET ( 0x0000013C )

#define SBPM_BLOCK_REGS_SBPM_ISR_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_ISR_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_ISR_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_ISR_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_ISR_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_ISR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t rsv           	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_search_err */
	uint32_t max_search_err	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* check_last_err */
	uint32_t check_last_err	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_overflow */
	uint32_t mcst_overflow 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bac_underrun */
	uint32_t bac_underrun  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_ISR ;
#else
typedef struct
{	uint32_t bac_underrun  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bac_underrun */
	uint32_t mcst_overflow 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_overflow */
	uint32_t check_last_err	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* check_last_err */
	uint32_t max_search_err	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_search_err */
	uint32_t rsv           	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_ISR ;
#endif

/*****************************************************************************************/
/* SBPM_IER                                                                              */
/* SBPM IER (Interrupt Enable register)                                                  */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_IER_RSV_RESRVED_VALUE                                           ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_RSV_RESRVED_VALUE_RESET_VALUE                               ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_NULL_CONNECT_IRQ_EN_NULL_CONNECT_IRQ_EN_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_NULL_CONNECT_IRQ_EN_NULL_CONNECT_IRQ_EN_VALUE_RESET_VALUE   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_MAX_SRCH_ERR_IRQ_EN_MAX_SRCH_ERR_IRQ_EN_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_MAX_SRCH_ERR_IRQ_EN_MAX_SRCH_ERR_IRQ_EN_VALUE_RESET_VALUE   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_LAST_ERR_IRQ_EN_LAST_ERR_IRQ_EN_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_LAST_ERR_IRQ_EN_LAST_ERR_IRQ_EN_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_MCST_OVERFLW_IRQ_EN__MCST_OVERFLW_IRQ_EN__VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_MCST_OVERFLW_IRQ_EN__MCST_OVERFLW_IRQ_EN__VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_BAC_UNDERRUN_IRQ_EN_BAC_UNDERRUN_IRQ_EN_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IER_BAC_UNDERRUN_IRQ_EN_BAC_UNDERRUN_IRQ_EN_VALUE_RESET_VALUE   ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_IER_OFFSET ( 0x00000140 )

#define SBPM_BLOCK_REGS_SBPM_IER_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_IER_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_IER_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_IER_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_IER_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_IER_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t rsv                 	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* null_connect_irq_en */
	uint32_t null_connect_irq_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_srch_err_irq_en */
	uint32_t max_srch_err_irq_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* last_err_irq_en */
	uint32_t last_err_irq_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_overflow_irq_en */
	uint32_t mcst_overflw_irq_en_	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bac_underrun_irq_en */
	uint32_t bac_underrun_irq_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_IER ;
#else
typedef struct
{	uint32_t bac_underrun_irq_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bac_underrun_irq_en */
	uint32_t mcst_overflw_irq_en_	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_overflow_irq_en */
	uint32_t last_err_irq_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* last_err_irq_en */
	uint32_t max_srch_err_irq_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_srch_err_irq_en */
	uint32_t null_connect_irq_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* null_connect_irq_en */
	uint32_t rsv                 	: 27 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_IER ;
#endif

/*****************************************************************************************/
/* SBPM_ITR                                                                              */
/* SBPM ITR (Interrupt test register)                                                    */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_ITR_RSV_RSV_VALUE                                                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ITR_RSV_RSV_VALUE_RESET_VALUE                                       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ITR_MAX_SRCH_ERR_TEST_IRQ_MAX_SRCH_ERR_TEST_IRQ_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ITR_MAX_SRCH_ERR_TEST_IRQ_MAX_SRCH_ERR_TEST_IRQ_VALUE_RESET_VALUE   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ITR_LAST_ERR_TEST_IRQ_LAST_ERR_TEST_IRQ_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ITR_LAST_ERR_TEST_IRQ_LAST_ERR_TEST_IRQ_VALUE_RESET_VALUE           ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ITR_MCST_OVERFLOW_TEST_IRQ_MCST_OVERFLOW_TEST_IRQ_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ITR_MCST_OVERFLOW_TEST_IRQ_MCST_OVERFLOW_TEST_IRQ_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ITR_BAC_UNDERRUN_TEST_IRQ_BAC_UNDERRUN_TEST_IRQ_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_ITR_BAC_UNDERRUN_TEST_IRQ_BAC_UNDERRUN_TEST_IRQ_VALUE_RESET_VALUE   ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_ITR_OFFSET ( 0x00000144 )

#define SBPM_BLOCK_REGS_SBPM_ITR_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_ITR_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_ITR_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_ITR_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_ITR_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_ITR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t rsv                   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_srch_err_test_irq */
	uint32_t max_srch_err_test_irq 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* last_err_test_irq */
	uint32_t last_err_test_irq     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_overflow_test_irq */
	uint32_t mcst_overflow_test_irq	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bac_underrun_test_irq */
	uint32_t bac_underrun_test_irq 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_ITR ;
#else
typedef struct
{	uint32_t bac_underrun_test_irq 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bac_underrun_test_irq */
	uint32_t mcst_overflow_test_irq	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_overflow_test_irq */
	uint32_t last_err_test_irq     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* last_err_test_irq */
	uint32_t max_srch_err_test_irq 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_srch_err_test_irq */
	uint32_t rsv                   	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_ITR ;
#endif

/*****************************************************************************************/
/* SBPM_IIR_low_register                                                                 */
/* SBPM IIR low (Interrupt information register)                                         */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_IIR_LOW_CMD_DATA_22TO0_CMD_DATA_22_TO0_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IIR_LOW_CMD_DATA_22TO0_CMD_DATA_22_TO0_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IIR_LOW_CMD_TA_CMD_TA_VALUE                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IIR_LOW_CMD_TA_CMD_TA_VALUE_RESET_VALUE                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IIR_LOW_CMD_SA_CMD_SA_VALUE                              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IIR_LOW_CMD_SA_CMD_SA_VALUE_RESET_VALUE                  ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_IIR_LOW_OFFSET ( 0x00000148 )

#define SBPM_BLOCK_REGS_SBPM_IIR_LOW_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_IIR_LOW_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_IIR_LOW_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_IIR_LOW_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_IIR_LOW_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_IIR_LOW_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* cmd_data_22to0 */
	uint32_t cmd_data_22to0	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cmd_ta */
	uint32_t cmd_ta        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cmd_sa */
	uint32_t cmd_sa        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_IIR_LOW ;
#else
typedef struct
{	uint32_t cmd_sa        	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cmd_sa */
	uint32_t cmd_ta        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cmd_ta */
	uint32_t cmd_data_22to0	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cmd_data_22to0 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_IIR_LOW ;
#endif

/*****************************************************************************************/
/* SBPM_IIR_high_register                                                                */
/* SBPM IIR high (Interrupt information register)                                        */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_IIR_HIGH_RSV_CMD_UG_VALUE                                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IIR_HIGH_RSV_CMD_UG_VALUE_RESET_VALUE                      ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IIR_HIGH_CMD_DATA_23TO42_CMD_DATA_23TO39_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_IIR_HIGH_CMD_DATA_23TO42_CMD_DATA_23TO39_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_IIR_HIGH_OFFSET ( 0x0000014C )

#define SBPM_BLOCK_REGS_SBPM_IIR_HIGH_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_IIR_HIGH_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_IIR_HIGH_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_IIR_HIGH_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_IIR_HIGH_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_IIR_HIGH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv            	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cmd_data_23to39 */
	uint32_t cmd_data_23to42	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_IIR_HIGH ;
#else
typedef struct
{	uint32_t cmd_data_23to42	: 20 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cmd_data_23to39 */
	uint32_t rsv            	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_IIR_HIGH ;
#endif

/*****************************************************************************************/
/* SBPM_DBG_VEC0                                                                         */
/* SBPM debug vector0 includes 21 bit of control/state machine of CMD pipe               */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_RSV_RESERVED_VALUE                      ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_RSV_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_RX_FIFO_SA_SA_VALUE                     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_RX_FIFO_SA_SA_VALUE_RESET_VALUE         ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_GN_CNXT_SM_STATE_VALUE                  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_GN_CNXT_SM_STATE_VALUE_RESET_VALUE      ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_FREE_WO_CNXT_SM_STATE_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_FREE_WO_CNXT_SM_STATE_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_FREE_W_CNXT_SM_STATE_VALUE              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_FREE_W_CNXT_SM_STATE_VALUE_RESET_VALUE  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_MCINT_SM_STATE_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_MCINT_SM_STATE_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_CNNCT_SM_STATE_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_CNNCT_SM_STATE_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_ALLOC_SM_STATE_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_ALLOC_SM_STATE_VALUE_RESET_VALUE        ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_OFFSET ( 0x00000150 )

#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_DBG_VEC0_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_DBG_VEC0_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC0_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_DBG_VEC0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t rsv            	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_FIFO_SA */
	uint32_t rx_fifo_sa     	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GN_CNXT_SM */
	uint32_t gn_cnxt_sm     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FREE_WO_CNXT_SM */
	uint32_t free_wo_cnxt_sm	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FREE_W_CNXT_SM */
	uint32_t free_w_cnxt_sm 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MCINC_SM */
	uint32_t mcint_sm       	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CNNCT_SM */
	uint32_t cnnct_sm       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_SM */
	uint32_t alloc_sm       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_DBG_VEC0 ;
#else
typedef struct
{	uint32_t alloc_sm       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ALLOC_SM */
	uint32_t cnnct_sm       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CNNCT_SM */
	uint32_t mcint_sm       	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MCINC_SM */
	uint32_t free_w_cnxt_sm 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FREE_W_CNXT_SM */
	uint32_t free_wo_cnxt_sm	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* FREE_WO_CNXT_SM */
	uint32_t gn_cnxt_sm     	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GN_CNXT_SM */
	uint32_t rx_fifo_sa     	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_FIFO_SA */
	uint32_t rsv            	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_DBG_VEC0 ;
#endif

/*****************************************************************************************/
/* SBPM_DBG_VEC1                                                                         */
/* SBPM debug vector1 includes 21 bit of control/state machine of CMD pipe  				         */
/*                                                                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_DBG_VEC1_RSV_RESERVED_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC1_RSV_RESERVED_VALUE_RESET_VALUE    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC1_RX_FIFO_DATA_SA_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC1_RX_FIFO_DATA_SA_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC1_RX_FIFO_TA_SA_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC1_RX_FIFO_TA_SA_VALUE_RESET_VALUE   ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_DBG_VEC1_OFFSET ( 0x00000154 )

#define SBPM_BLOCK_REGS_SBPM_DBG_VEC1_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_DBG_VEC1_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC1_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_DBG_VEC1_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_DBG_VEC1_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_DBG_VEC1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t rsv         	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_FIFO_DATA */
	uint32_t rx_fifo_data	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_FIFO_TA */
	uint32_t rx_fifo_ta  	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_DBG_VEC1 ;
#else
typedef struct
{	uint32_t rx_fifo_ta  	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_FIFO_TA */
	uint32_t rx_fifo_data	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RX_FIFO_DATA */
	uint32_t rsv         	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_DBG_VEC1 ;
#endif

/*****************************************************************************************/
/* Route_Address0__config                                                                */
/* Route Address 0 config includes ETH0/1 RX/TX                                          */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_RADDR_0_RSV4_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_0_RSV4_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_0_ETH1_TX_RADDR_ETH1_TX_RADDR_VALUE             ( 0x2F )
#define SBPM_BLOCK_REGS_RADDR_0_ETH1_TX_RADDR_ETH1_TX_RADDR_VALUE_RESET_VALUE ( 0x2F )
#define SBPM_BLOCK_REGS_RADDR_0_RSV3_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_0_RSV3_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_0_ETH1_RX_RADDR_ETH1_RX_RADDR_VALUE             ( 0xF )
#define SBPM_BLOCK_REGS_RADDR_0_ETH1_RX_RADDR_ETH1_RX_RADDR_VALUE_RESET_VALUE ( 0xF )
#define SBPM_BLOCK_REGS_RADDR_0_RSV2_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_0_RSV2_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_0_ETH0_TX_RADDR_ETH0_TX_RADDR_VALUE             ( 0x3F )
#define SBPM_BLOCK_REGS_RADDR_0_ETH0_TX_RADDR_ETH0_TX_RADDR_VALUE_RESET_VALUE ( 0x3F )
#define SBPM_BLOCK_REGS_RADDR_0_RSV1_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_0_RSV1_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_0_ETH0_RX_RADDR_ETH0_RX_RADDR_VALUE             ( 0x1F )
#define SBPM_BLOCK_REGS_RADDR_0_ETH0_RX_RADDR_ETH0_RX_RADDR_VALUE_RESET_VALUE ( 0x1F )


#define SBPM_BLOCK_REGS_RADDR_0_OFFSET ( 0x00000158 )

#define SBPM_BLOCK_REGS_RADDR_0_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_RADDR_0_OFFSET )
#define SBPM_BLOCK_REGS_RADDR_0_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_RADDR_0_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_RADDR_0_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_RADDR_0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth1_tx_raddr */
	uint32_t eth1_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth1_rx_raddr */
	uint32_t eth1_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth0_tx_raddr */
	uint32_t eth0_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth0_rx_raddr */
	uint32_t eth0_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_RADDR_0 ;
#else
typedef struct
{	uint32_t eth0_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth0_rx_raddr */
	uint32_t rsv1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t eth0_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth0_tx_raddr */
	uint32_t rsv2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t eth1_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth1_rx_raddr */
	uint32_t rsv3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t eth1_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth1_tx_raddr */
	uint32_t rsv4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_RADDR_0 ;
#endif

/*****************************************************************************************/
/* Route_Address1__config                                                                */
/* Route Address 1 config  includes ETH2/3 RX/TX reg                                     */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_RADDR_1_RSV4_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_1_RSV4_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_1_ETH3_TX_RADDR_ETH3_TX_RADDR_VALUE             ( 0x29 )
#define SBPM_BLOCK_REGS_RADDR_1_ETH3_TX_RADDR_ETH3_TX_RADDR_VALUE_RESET_VALUE ( 0x29 )
#define SBPM_BLOCK_REGS_RADDR_1_RSV3_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_1_RSV3_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_1_ETH3_RX_RADDR_ETH3_RX_ADDR_VALUE              ( 0x9 )
#define SBPM_BLOCK_REGS_RADDR_1_ETH3_RX_RADDR_ETH3_RX_ADDR_VALUE_RESET_VALUE  ( 0x9 )
#define SBPM_BLOCK_REGS_RADDR_1_RSV2_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_1_RSV2_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_1_ETH2_TX_RADDR_ETH2_TX_RADDR_VALUE             ( 0x37 )
#define SBPM_BLOCK_REGS_RADDR_1_ETH2_TX_RADDR_ETH2_TX_RADDR_VALUE_RESET_VALUE ( 0x37 )
#define SBPM_BLOCK_REGS_RADDR_1_RSV1_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_1_RSV1_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_1_ETH2_RX_RADDR_ETH2_RX_RADDR_VALUE             ( 0x17 )
#define SBPM_BLOCK_REGS_RADDR_1_ETH2_RX_RADDR_ETH2_RX_RADDR_VALUE_RESET_VALUE ( 0x17 )


#define SBPM_BLOCK_REGS_RADDR_1_OFFSET ( 0x0000015C )

#define SBPM_BLOCK_REGS_RADDR_1_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_RADDR_1_OFFSET )
#define SBPM_BLOCK_REGS_RADDR_1_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_RADDR_1_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_RADDR_1_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_RADDR_1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth3_tx_raddr */
	uint32_t eth3_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth3_rx_raddr */
	uint32_t eth3_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth2_tx_raddr */
	uint32_t eth2_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth2_rx_raddr */
	uint32_t eth2_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_RADDR_1 ;
#else
typedef struct
{	uint32_t eth2_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth2_rx_raddr */
	uint32_t rsv1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t eth2_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth2_tx_raddr */
	uint32_t rsv2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t eth3_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth3_rx_raddr */
	uint32_t rsv3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t eth3_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth3_tx_raddr */
	uint32_t rsv4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_RADDR_1 ;
#endif

/*****************************************************************************************/
/* Route_Address2__config                                                                */
/* Route Address 2 config  includes GPON/ETH4 RX/Txreg                                   */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_RADDR_2_RSV4_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_2_RSV4_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_2_ETH4_TX_RADDR_ETH4_TX_RADDR_VALUE             ( 0x31 )
#define SBPM_BLOCK_REGS_RADDR_2_ETH4_TX_RADDR_ETH4_TX_RADDR_VALUE_RESET_VALUE ( 0x31 )
#define SBPM_BLOCK_REGS_RADDR_2_RSV3_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_2_RSV3_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_2_ETH4_RX_RADDR_ETH4_RX_ADDR_VALUE              ( 0x11 )
#define SBPM_BLOCK_REGS_RADDR_2_ETH4_RX_RADDR_ETH4_RX_ADDR_VALUE_RESET_VALUE  ( 0x11 )
#define SBPM_BLOCK_REGS_RADDR_2_RSV2_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_2_RSV2_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_2_GPON_TX_RADDR_GPON_TX_RADDR_VALUE             ( 0x21 )
#define SBPM_BLOCK_REGS_RADDR_2_GPON_TX_RADDR_GPON_TX_RADDR_VALUE_RESET_VALUE ( 0x21 )
#define SBPM_BLOCK_REGS_RADDR_2_RSV1_RSV_VALUE                                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_2_RSV1_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_2_GPON_RX_RADDR_GPON_RX_RADDR_VALUE             ( 0x1 )
#define SBPM_BLOCK_REGS_RADDR_2_GPON_RX_RADDR_GPON_RX_RADDR_VALUE_RESET_VALUE ( 0x1 )


#define SBPM_BLOCK_REGS_RADDR_2_OFFSET ( 0x00000160 )

#define SBPM_BLOCK_REGS_RADDR_2_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_RADDR_2_OFFSET )
#define SBPM_BLOCK_REGS_RADDR_2_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_RADDR_2_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_RADDR_2_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_RADDR_2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth4_tx_raddr */
	uint32_t eth4_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth4_rx_raddr */
	uint32_t eth4_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gpon_tx_raddr */
	uint32_t gpon_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gpon_rx_raddr */
	uint32_t gpon_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_RADDR_2 ;
#else
typedef struct
{	uint32_t gpon_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gpon_rx_raddr */
	uint32_t rsv1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t gpon_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gpon_tx_raddr */
	uint32_t rsv2         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t eth4_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth4_rx_raddr */
	uint32_t rsv3         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t eth4_tx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth4_tx_raddr */
	uint32_t rsv4         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_RADDR_2 ;
#endif

/*****************************************************************************************/
/* Route_Address3__config                                                                */
/* Route Address 3 config  reg includes definition of route address of Runner A/B        */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_RADDR_3_RSV3_RSV_VALUE                            ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_3_RSV3_RSV_VALUE_RESET_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_3_MIPSD_RADDR_MIPSD_RADDR_VALUE             ( 0x6 )
#define SBPM_BLOCK_REGS_RADDR_3_MIPSD_RADDR_MIPSD_RADDR_VALUE_RESET_VALUE ( 0x6 )
#define SBPM_BLOCK_REGS_RADDR_3_RSV2_RSV_VALUE                            ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_3_RSV2_RSV_VALUE_RESET_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_3_RNRB_RADDR_RNRB_RADDR_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_3_RNRB_RADDR_RNRB_RADDR_VALUE_RESET_VALUE   ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_3_RSV1_RSV_VALUE                            ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_3_RSV1_RSV_VALUE_RESET_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_RADDR_3_RNRA_RADDR_RNRA_RADDR_VALUE               ( 0x2 )
#define SBPM_BLOCK_REGS_RADDR_3_RNRA_RADDR_RNRA_RADDR_VALUE_RESET_VALUE   ( 0x2 )


#define SBPM_BLOCK_REGS_RADDR_3_OFFSET ( 0x00000164 )

#define SBPM_BLOCK_REGS_RADDR_3_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_RADDR_3_OFFSET )
#define SBPM_BLOCK_REGS_RADDR_3_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_RADDR_3_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_RADDR_3_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_RADDR_3_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv3       	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mipsd_raddr */
	uint32_t mipsd_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv2       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rnrb_raddr */
	uint32_t rnrb_raddr 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rnra_raddr */
	uint32_t rnra_raddr 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_RADDR_3 ;
#else
typedef struct
{	uint32_t rnra_raddr 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rnra_raddr */
	uint32_t rsv1       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rnrb_raddr 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rnrb_raddr */
	uint32_t rsv2       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t mipsd_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mipsd_raddr */
	uint32_t rsv3       	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_RADDR_3 ;
#endif

/*****************************************************************************************/
/* User_Group_mapping_register_1                                                         */
/* Configuration of mappins source ports to User G                                       */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_UG_MAP_REG_1_SPARE1_SPARE1_MAP_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_SPARE1_SPARE1_MAP_VALUE_RESET_VALUE   ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_SPARE0_SPARE0_MAP_VALUE               ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_SPARE0_SPARE0_MAP_VALUE_RESET_VALUE   ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_USB1_USB_MAP_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_USB1_USB_MAP_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_USB0_USB_MAP_VALUE                    ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_USB0_USB_MAP_VALUE_RESET_VALUE        ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_PCIE1_PCIE1_MAP_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_PCIE1_PCIE1_MAP_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_PCIE0_PCIE0_MAP_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_PCIE0_PCIE0_MAP_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_MIPSD_EMAC4_MAPPING_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_MIPSD_EMAC4_MAPPING_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_EMAC4_EMAC4_MAPPING_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_EMAC4_EMAC4_MAPPING_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_UG_MAP_REG_1_OFFSET ( 0x00000168 )

#define SBPM_BLOCK_REGS_UG_MAP_REG_1_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_UG_MAP_REG_1_OFFSET )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_UG_MAP_REG_1_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_UG_MAP_REG_1_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_UG_MAP_REG_1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* spare1_map */
	uint32_t spare1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* spare0_map */
	uint32_t spare0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USB1_map */
	uint32_t usb1  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USB0_map */
	uint32_t usb0  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PCIE1_map */
	uint32_t pcie1 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PCIE0_map */
	uint32_t pcie0 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MIPSD_map */
	uint32_t mipsd 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC4_map */
	uint32_t emac4 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_UG_MAP_REG_1 ;
#else
typedef struct
{	uint32_t emac4 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC4_map */
	uint32_t mipsd 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MIPSD_map */
	uint32_t pcie0 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PCIE0_map */
	uint32_t pcie1 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PCIE1_map */
	uint32_t usb0  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USB0_map */
	uint32_t usb1  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USB1_map */
	uint32_t spare0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* spare0_map */
	uint32_t spare1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* spare1_map */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_UG_MAP_REG_1 ;
#endif

/*****************************************************************************************/
/* MIPSD_Target_address_for_Reply_message                                                */
/* MIPSD Target address for Reply message as results of Alloc request from MIPSD.        */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_RSV_DEFAULT_VALUE                                   ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_RSV_DEFAULT_VALUE_RESET_VALUE                       ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_MIPSD_REPLY_MSG_BASE_ADDR_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_MIPSD_REPLY_MSG_BASE_ADDR_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_OFFSET ( 0x0000016C )

#define SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv                      	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Target_address_for_MIPSD */
	uint32_t mipsd_reply_msg_base_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA ;
#else
typedef struct
{	uint32_t mipsd_reply_msg_base_addr	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Target_address_for_MIPSD */
	uint32_t rsv                      	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA ;
#endif

/*****************************************************************************************/
/* sbpm_mipsd_wkup_rply_set                                                              */
/* sbpm_mipsd_wkup_rply_set                                                              */
/*****************************************************************************************/

#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_RSV_DEFAULT_VALUE                             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_RSV_DEFAULT_VALUE_RESET_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_MCST_WAKE_UP_EN_DEFAULT_VALUE                 ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_MCST_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_GET_NEXT_WAKE_UP_EN_DEFAULT_VALUE             ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_GET_NEXT_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_CONNECT_WAKE_UP_EN_DEFAULT_VALUE              ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_CONNECT_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE  ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_ALLOC_WAKE_UP_EN_DEFAULT_VALUE                ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_ALLOC_WAKE_UP_EN_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_TASK_NUM_DEFAULT_VALUE                        ( 0x0 )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_TASK_NUM_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )


#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_OFFSET ( 0x00000170 )

#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_ADDRESS   	( SBPM_BLOCK_REGS_ADDRESS + SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_OFFSET )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_READ( r ) 	READ_32( ( SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_ADDRESS ), (r) )
#define SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_WRITE( v )	WRITE_32( ( SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv                	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_wake_up_en */
	uint32_t mcst_wake_up_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_wake_up_en */
	uint32_t get_next_wake_up_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_wake_up_en */
	uint32_t connect_wake_up_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_wake_up_en */
	uint32_t alloc_wake_up_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t task_num           	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET ;
#else
typedef struct
{	uint32_t task_num           	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* task_number */
	uint32_t alloc_wake_up_en   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* alloc_wake_up_en */
	uint32_t connect_wake_up_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* connect_wake_up_en */
	uint32_t get_next_wake_up_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_wake_up_en */
	uint32_t mcst_wake_up_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_wake_up_en */
	uint32_t rsv                	: 22 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET ;
#endif

typedef struct
{
	/* init_free_list */
	SBPM_BLOCK_REGS_INIT_FREE_LIST init_free_list __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_alloc */
	SBPM_BLOCK_REGS_BN_ALLOC bn_alloc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_alloc_rply */
	SBPM_BLOCK_REGS_BN_ALLOC_RPLY bn_alloc_rply __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_free_with_contxt_low */
	SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_LOW bn_free_with_contxt_low __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_free_with_contxt_high */
	SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_HIGH bn_free_with_contxt_high __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_inc */
	SBPM_BLOCK_REGS_MCST_INC mcst_inc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mcst_inc_rply */
	SBPM_BLOCK_REGS_MCST_INC_RPLY mcst_inc_rply __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_connect */
	SBPM_BLOCK_REGS_BN_CONNECT bn_connect __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_connect_rply */
	SBPM_BLOCK_REGS_BN_CONNECT_RPLY bn_connect_rply __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next */
	SBPM_BLOCK_REGS_GET_NEXT get_next __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* get_next_rply */
	SBPM_BLOCK_REGS_GET_NEXT_RPLY get_next_rply __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 12 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_free_without_contxt */
	SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT bn_free_without_contxt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_free_without_contxt_rply */
	SBPM_BLOCK_REGS_BN_FREE_WITHOUT_CONTXT_RPLY bn_free_without_contxt_rply __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bn_free_with_contxt_rply */
	SBPM_BLOCK_REGS_BN_FREE_WITH_CONTXT_RPLY bn_free_with_contxt_rply __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 4 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_SP_EN */
	SBPM_BLOCK_REGS_SBPM_SP_EN sbpm_sp_en __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Threshold */
	SBPM_BLOCK_REGS_SBPM_GL_TRSH sbpm_gl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_Threshold */
	SBPM_BLOCK_REGS_SBPM_UG0_TRSH sbpm_ug0_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG1_Threshold */
	SBPM_BLOCK_REGS_SBPM_UG1_TRSH sbpm_ug1_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG2_Threshold */
	SBPM_BLOCK_REGS_SBPM_UG2_TRSH sbpm_ug2_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG3_Threshold */
	SBPM_BLOCK_REGS_SBPM_UG3_TRSH sbpm_ug3_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG4_Threshold */
	SBPM_BLOCK_REGS_SBPM_UG4_TRSH sbpm_ug4_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG5_Threshold */
	SBPM_BLOCK_REGS_SBPM_UG5_TRSH sbpm_ug5_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG6_Threshold */
	SBPM_BLOCK_REGS_SBPM_UG6_TRSH sbpm_ug6_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG7_Threshold */
	SBPM_BLOCK_REGS_SBPM_UG7_TRSH sbpm_ug7_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_map_register_0 */
	SBPM_BLOCK_REGS_SBPM_UG_MAP_0 sbpm_ug_map_0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_dbg */
	SBPM_BLOCK_REGS_SBPM_DBG sbpm_dbg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG0_BAC */
	SBPM_BLOCK_REGS_SBPM_UG0_BAC sbpm_ug0_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG1_BAC */
	SBPM_BLOCK_REGS_SBPM_UG1_BAC sbpm_ug1_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG2_BAC */
	SBPM_BLOCK_REGS_SBPM_UG2_BAC sbpm_ug2_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG3_BAC */
	SBPM_BLOCK_REGS_SBPM_UG3_BAC sbpm_ug3_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG4_BAC */
	SBPM_BLOCK_REGS_SBPM_UG4_BAC sbpm_ug4_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG5_BAC */
	SBPM_BLOCK_REGS_SBPM_UG5_BAC sbpm_ug5_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG6_BAC */
	SBPM_BLOCK_REGS_SBPM_UG6_BAC sbpm_ug6_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG7_BAC */
	SBPM_BLOCK_REGS_SBPM_UG7_BAC sbpm_ug7_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_GL_BAC */
	SBPM_BLOCK_REGS_SBPM_GL_BAC sbpm_gl_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG0_Exclusive_threshold */
	SBPM_BLOCK_REGS_SBPM_UG0_EXCL_TRSH sbpm_ug0_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved3 [ 96 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG1_Exclusive_threshold */
	SBPM_BLOCK_REGS_SBPM_UG1_EXCL_TRSH sbpm_ug1_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG2_Exclusive_threshold */
	SBPM_BLOCK_REGS_SBPM_UG2_EXCL_TRSH sbpm_ug2_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG3_Exclusive_threshold */
	SBPM_BLOCK_REGS_SBPM_UG3_EXCL_TRSH sbpm_ug3_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG4_Exclusive_threshold */
	SBPM_BLOCK_REGS_SBPM_UG4_EXCL_TRSH sbpm_ug4_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG5_Exclusive_threshold */
	SBPM_BLOCK_REGS_SBPM_UG5_EXCL_TRSH sbpm_ug5_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG6_Exclusive_threshold */
	SBPM_BLOCK_REGS_SBPM_UG6_EXCL_TRSH sbpm_ug6_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_UG7_Exclusive_threshold */
	SBPM_BLOCK_REGS_SBPM_UG7_EXCL_TRSH sbpm_ug7_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_Status_register */
	SBPM_BLOCK_REGS_SBPM_UG_STATUS sbpm_ug_status __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_runner_status_message_control_register */
	SBPM_BLOCK_REGS_SBPM_RNR_STAT_MSG_CTRL sbpm_rnr_stat_msg_ctrl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_Target_address_for_Reply_message */
	SBPM_BLOCK_REGS_SBPM_RNR_RPLY_TA sbpm_rnr_rply_ta __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sbpm_rnr_wkup_rply_set_0 */
	SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET0 sbpm_rnr_wkup_rply_set0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sbpm_rnr_wkup_rply_set_1 */
	SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET1 sbpm_rnr_wkup_rply_set1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sbpm_rnr_wkup_rply_set_2 */
	SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET2 sbpm_rnr_wkup_rply_set2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sbpm_rnr_wkup_rply_set_3 */
	SBPM_BLOCK_REGS_SBPM_RNR_WKUP_RPLY_SET3 sbpm_rnr_wkup_rply_set3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* error_handling_params */
	SBPM_BLOCK_REGS_ERROR_HANDLING_PARAMS error_handling_params __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_ISR */
	SBPM_BLOCK_REGS_SBPM_ISR sbpm_isr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_IER */
	SBPM_BLOCK_REGS_SBPM_IER sbpm_ier __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_ITR */
	SBPM_BLOCK_REGS_SBPM_ITR sbpm_itr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_IIR_low_register */
	SBPM_BLOCK_REGS_SBPM_IIR_LOW sbpm_iir_low __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_IIR_high_register */
	SBPM_BLOCK_REGS_SBPM_IIR_HIGH sbpm_iir_high __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_DBG_VEC0 */
	SBPM_BLOCK_REGS_SBPM_DBG_VEC0 sbpm_dbg_vec0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SBPM_DBG_VEC1 */
	SBPM_BLOCK_REGS_SBPM_DBG_VEC1 sbpm_dbg_vec1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Route_Address0__config */
	SBPM_BLOCK_REGS_RADDR_0 raddr_0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Route_Address1__config */
	SBPM_BLOCK_REGS_RADDR_1 raddr_1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Route_Address2__config */
	SBPM_BLOCK_REGS_RADDR_2 raddr_2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Route_Address3__config */
	SBPM_BLOCK_REGS_RADDR_3 raddr_3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_mapping_register_1 */
	SBPM_BLOCK_REGS_UG_MAP_REG_1 ug_map_reg_1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MIPSD_Target_address_for_Reply_message */
	SBPM_BLOCK_REGS_SBPM_MIPSD_RPLY_TA sbpm_mipsd_rply_ta __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* sbpm_mipsd_wkup_rply_set */
	SBPM_BLOCK_REGS_SBPM_MIPSD_WKUP_RPLY_SET sbpm_mipsd_wkup_rply_set __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK_REGS ;

typedef struct
{
	/* regs function */
	SBPM_BLOCK_REGS regs __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
SBPM_BLOCK ;

typedef struct
{
	/* BLOCK */
	SBPM_BLOCK block __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__ 
SBPM_FOR_ALL ;
#endif /* SBPM_H_INCLUDED */

