/*
 *  arch/arm/mach-dmw/include/mach/powerdomain.h
 *
 *  Copyright (C) 2011 DSP Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __MACH_POWERDOMAIN_H
#define __MACH_POWERDOMAIN_H

#include <mach/platform.h>

enum {
	DMW_PWRDOM_CSS,
	DMW_PWRDOM_GPU,
	DMW_PWRDOM_VIDEO_ENC_DEC,
	DMW_PWRDOM_CORTEX_ETM,
	DMW_PWRDOM_CORTEX_NEON,
};

#ifdef CONFIG_DMW_PWRDOM
int dmw_pwrdom_enable(unsigned domain);
int dmw_pwrdom_disable(unsigned domain);
#else
static inline int dmw_pwrdom_enable(unsigned domain)  { return 0; }
static inline int dmw_pwrdom_disable(unsigned domain) { return 0; }
#endif

struct dmw_pwrdom_pdata {
	unsigned domain;
	char *name;
};

#endif
