/*
 * arch/arm/mach-dmw/css/coma-eeprom.c - cordless EEPROM CSS / netlink interface to user space
 *
 * Using netlink, a socket interface to Linux user space is implemented that
 * allows sending EEPROM messages between user space and cordless.
 *
 * Copyright (C) 2010 DSP Group Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "coma-service.h"

#define SERVICE_NAME		"coma-eeprom"
#define SERVICE_ID		COMA_SERVICE_EEPROM
#define NETLINK_ID		NETLINK_EEPROM
#define NETLINK_CFIFO_SIZE	10240

#define NETLINK_UNICAST

#include "netlink.c"

void eeprom_service_init(void)
{
	netlink_init();
}

void eeprom_service_exit(void)
{
	netlink_exit();
}
