/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.BitVector;
import gnu.lists.CharVector;
import gnu.lists.Consumer;
import gnu.lists.F32Vector;
import gnu.lists.F64Vector;
import gnu.lists.FVector;
import gnu.lists.IndirectIndexedSeq;
import gnu.lists.IntSequence;
import gnu.lists.Range;
import gnu.lists.S16Vector;
import gnu.lists.S32Vector;
import gnu.lists.S64Vector;
import gnu.lists.S8Vector;
import gnu.lists.SimpleVector;
import gnu.lists.SubCharSeq;
import gnu.math.ULong;
import gnu.text.Char;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Sequences {
    public static List asSequenceOrNull(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof CharSequence) {
            CharSequence cseq = (CharSequence)value;
            return new SubCharSeq(cseq, 0, cseq.length());
        }
        if (value instanceof Object[]) {
            return new FVector((Object[])value);
        }
        if (value.getClass().isArray()) {
            if (value instanceof long[]) {
                return new S64Vector((long[])value);
            }
            if (value instanceof int[]) {
                return new S32Vector((int[])value);
            }
            if (value instanceof short[]) {
                return new S16Vector((short[])value);
            }
            if (value instanceof byte[]) {
                return new S8Vector((byte[])value);
            }
            if (value instanceof double[]) {
                return new F64Vector((double[])value);
            }
            if (value instanceof float[]) {
                return new F32Vector((float[])value);
            }
            if (value instanceof boolean[]) {
                return new BitVector((boolean[])value);
            }
            if (value instanceof char[]) {
                return new CharVector((char[])value);
            }
        }
        return null;
    }

    public static IntSequence asIntSequenceOrNull(Object value) {
        List lst = Sequences.asSequenceOrNull(value);
        if (lst == null) {
            return null;
        }
        if (lst instanceof IntSequence) {
            return (IntSequence)((Object)lst);
        }
        int len = lst.size();
        int[] arr = new int[len];
        int i = 0;
        for (Object el : lst) {
            arr[i++] = ((Number)el).intValue();
        }
        return new S32Vector(arr);
    }

    public static List coerceToSequence(Object value) {
        List lst = Sequences.asSequenceOrNull(value);
        if (lst == null) {
            String msg = value == null ? "null is not a sequence" : "cannot cast a " + value.getClass().getName() + " to a sequence";
            throw new ClassCastException(msg);
        }
        return lst;
    }

    public static int getSize(Object values) {
        if (values instanceof Object[]) {
            return ((Object[])values).length;
        }
        if (values instanceof CharSequence) {
            return ((CharSequence)values).length();
        }
        if (values instanceof List) {
            return ((List)values).size();
        }
        if (values.getClass().isArray()) {
            return Array.getLength(values);
        }
        throw new ClassCastException("value is neither List or array");
    }

    public static Iterator getIterator(Object object2) {
        List list;
        if (object2 instanceof CharSequence) {
            return new CharacterIterator((CharSequence)object2);
        }
        if (!(object2 instanceof Iterable) && (list = Sequences.asSequenceOrNull(object2)) != null) {
            return list.iterator();
        }
        return ((Iterable)object2).iterator();
    }

    public static Object subList(Object base2, int fromIndex, int toIndex) {
        List lbase = (List)base2;
        if (toIndex == -1) {
            toIndex = lbase.size();
        }
        return lbase.subList(fromIndex, toIndex);
    }

    static IntSequence indirectIndexed(IntSequence base2, IntSequence indexes) {
        if (base2 == null) {
            return indexes;
        }
        int sz = indexes.size();
        if (indexes instanceof Range.IntRange) {
            Range.IntRange range = (Range.IntRange)indexes;
            int start = range.getStartInt();
            int step = range.getStepInt();
            if (base2 instanceof Range.IntRange) {
                return ((Range.IntRange)base2).subListFromRange(start, step, sz);
            }
            if (range.isUnbounded()) {
                return new ComposedIndexes(base2, range, (base2.size() - start + step - 1) / step);
            }
            if (step == 1) {
                return base2.subList(start, sz);
            }
        }
        return new ComposedIndexes(base2, indexes);
    }

    public static List indirectIndexed(List lst, IntSequence indexes) {
        if (lst instanceof SimpleVector) {
            return ((SimpleVector)lst).select(indexes);
        }
        return new IndirectIndexedSeq(lst, indexes);
    }

    public static Object drop(Object base2, int count) {
        if (count >= 0) {
            return Sequences.subList(base2, count, -1);
        }
        return Sequences.subList(base2, 0, -count);
    }

    public static Object drop(Object base2, int fromStart, int fromEnd) {
        List lbase = (List)base2;
        return Sequences.subList(base2, fromStart, lbase.size() - fromEnd);
    }

    public static void replace(List lst, int fromStart, int fromEnd, List values) {
        if (lst instanceof SimpleVector && values instanceof SimpleVector) {
            SimpleVector svec = (SimpleVector)values;
            SimpleVector dvec = (SimpleVector)lst;
            if (svec.getTag() == dvec.getTag()) {
                int sstart;
                int dstLength;
                int srcLength = svec.size();
                int grow = srcLength - (dstLength = fromEnd - fromStart);
                if (grow > 0) {
                    dvec.addSpace(fromEnd, grow);
                }
                Object dbuffer = dvec.getBuffer();
                Object sbuffer = svec.getBuffer();
                int dstart = dvec.getSegment(fromStart, srcLength);
                if (dstart >= 0 && (sstart = svec.getSegmentReadOnly(0, srcLength)) >= 0) {
                    System.arraycopy(sbuffer, sstart, dbuffer, dstart, srcLength);
                } else {
                    boolean copied;
                    int srcStart = 0;
                    boolean bl = copied = dbuffer == sbuffer;
                    if (copied) {
                        sbuffer = svec.toDataArray();
                    }
                    while (srcLength > 0) {
                        int swhere;
                        int step = srcLength;
                        long dresult = dvec.getSegment(fromStart);
                        int dwhere = (int)dresult;
                        int dsize = (int)(dresult >> 32);
                        if (dsize < step) {
                            step = dsize;
                        }
                        if (copied) {
                            swhere = srcStart;
                        } else {
                            long sresult = svec.getSegment(srcStart);
                            swhere = (int)sresult;
                            int ssize = (int)(sresult >> 32);
                            if (ssize < step) {
                                step = ssize;
                            }
                        }
                        if (step == 0) {
                            throw new Error("zero step in replace loop!");
                        }
                        System.arraycopy(sbuffer, swhere, dbuffer, dwhere, step);
                        srcLength -= step;
                        srcStart += step;
                        fromStart += step;
                    }
                }
                if (grow < 0) {
                    dvec.delete(fromEnd + grow, fromEnd);
                }
                return;
            }
        }
        int oldSize = fromEnd - fromStart;
        int newSize = values.size();
        Object[] varray = values.toArray();
        int i = 0;
        for (Object el : varray) {
            if (i < oldSize) {
                lst.set(fromStart + i, el);
            } else {
                lst.add(fromStart + i, el);
            }
            ++i;
        }
        if (i < oldSize) {
            if (lst instanceof AbstractSequence) {
                AbstractSequence alst = (AbstractSequence)((Object)lst);
                alst.removePos(alst.createPos(fromStart + i, false), oldSize - i);
            } else {
                while (i < oldSize) {
                    lst.remove(fromStart + i);
                    --oldSize;
                }
            }
        }
    }

    public static void writeUInt(int value, Consumer out) {
        if (value >= 0) {
            out.writeInt(value);
        } else {
            out.writeLong((long)value & 0xFFFFFFFFL);
        }
    }

    public static void writeULong(long value, Consumer out) {
        if (value >= 0L) {
            out.writeLong(value);
        } else {
            out.writeObject(ULong.valueOf(value));
        }
    }

    public static class ComposedIndexes
    implements IntSequence {
        IntSequence is1;
        IntSequence is2;
        int size;

        public ComposedIndexes(IntSequence is1, IntSequence is2) {
            this.is1 = is1;
            this.is2 = is2;
            this.size = -2;
        }

        public ComposedIndexes(IntSequence is1, IntSequence is2, int size) {
            this.is1 = is1;
            this.is2 = is2;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size != -2 ? this.size : this.is2.size();
        }

        @Override
        public int intAt(int index) {
            return this.is1.intAt(this.is2.intAt(index));
        }

        @Override
        public IntSequence subList(int fromIx, int toIx) {
            return new ComposedIndexes(this.is1, this.is2.subList(fromIx, toIx));
        }
    }

    public static class CharacterIterator
    implements Iterator<Char> {
        CharSequence cseq;
        int len;
        int pos;

        public CharacterIterator(CharSequence cseq) {
            this.cseq = cseq;
            this.len = cseq.length();
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.len;
        }

        @Override
        public Char next() {
            char ch2;
            int ch1;
            if (this.pos >= this.len) {
                throw new NoSuchElementException();
            }
            if ((ch1 = this.cseq.charAt(this.pos++)) >= 55296 && ch1 <= 56319 && this.pos < this.len && (ch2 = this.cseq.charAt(this.pos)) >= '\udc00' && ch2 <= '\udfff') {
                ch1 = (ch1 - 55296 << 10) + (ch2 - 56320) + 65536;
                ++this.pos;
            }
            return Char.make(ch1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

