/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Hashtable;

public class ArrayClassLoader
extends ClassLoader {
    Hashtable map = new Hashtable(100);
    URL context;

    public ArrayClassLoader() {
    }

    public ArrayClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public URL getResourceContext() {
        return this.context;
    }

    public void setResourceContext(URL uRL) {
        this.context = uRL;
    }

    public ArrayClassLoader(byte[][] byArray) {
        int n = byArray.length;
        while (--n >= 0) {
            this.addClass("lambda" + n, byArray[n]);
        }
    }

    public ArrayClassLoader(String[] stringArray, byte[][] byArray) {
        int n = byArray.length;
        while (--n >= 0) {
            this.addClass(stringArray[n], byArray[n]);
        }
    }

    public void addClass(Class clazz) {
        this.map.put(clazz.getName(), clazz);
    }

    public void addClass(String string, byte[] byArray) {
        this.map.put(string, byArray);
    }

    public void addClass(ClassType classType) {
        this.map.put(classType.getName(), classType);
    }

    protected URL findResource(String string) {
        if (this.context != null) {
            try {
                URL uRL = new URL(this.context, string);
                uRL.openConnection().connect();
                return uRL;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.findResource(string);
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.loadClass(string);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String string) throws ClassNotFoundException {
        Type type;
        Object object2 = this.map.get(string);
        if (object2 instanceof ClassType) {
            type = (ClassType)object2;
            object2 = type.isExisting() ? type.reflectClass : (Object)type.writeToArray();
        }
        if (object2 instanceof byte[]) {
            ArrayClassLoader arrayClassLoader = this;
            synchronized (arrayClassLoader) {
                object2 = this.map.get(string);
                if (object2 instanceof byte[]) {
                    byte[] byArray = (byte[])object2;
                    type = this.defineClass(string, byArray, 0, byArray.length);
                    this.map.put(string, type);
                } else {
                    type = (Class)object2;
                }
            }
        } else {
            type = object2 == null ? this.getParent().loadClass(string) : (Class)object2;
        }
        return type;
    }

    public static Package getContextPackage(String string) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader instanceof ArrayClassLoader) {
                return ((ArrayClassLoader)classLoader).getPackage(string);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Package.getPackage(string);
    }
}

