/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.DFloNum;
import gnu.math.ExponentialFormat;
import gnu.math.IntNum;
import gnu.math.RatNum;
import gnu.math.RealNum;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class FixedRealFormat
extends Format {
    private int i;
    private int d;
    public int width;
    public int scale;
    public char padChar;
    public boolean showPlus;
    public boolean internalPad;
    public char overflowChar;

    public int getMaximumFractionDigits() {
        return this.d;
    }

    public int getMinimumIntegerDigits() {
        return this.i;
    }

    public void setMaximumFractionDigits(int n) {
        this.d = n;
    }

    public void setMinimumIntegerDigits(int n) {
        this.i = n;
    }

    public void format(RatNum ratNum, boolean bl, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        int n2;
        int n3;
        String string;
        int n4;
        int n5;
        int n6 = this.getMaximumFractionDigits();
        int n7 = stringBuffer.length();
        int n8 = 1;
        if (bl) {
            stringBuffer.append('-');
        } else if (this.showPlus) {
            stringBuffer.append('+');
        } else {
            n8 = 0;
        }
        if (n6 < 0) {
            char c;
            int n9;
            double d = ratNum.doubleValue();
            n5 = (int)(Math.log(d) / ExponentialFormat.LOG10);
            n4 = n5 == Integer.MIN_VALUE ? 0 : 17 - n5;
            string = RealNum.toScaledInt(d, n4).toString();
            n3 = string.length();
            n2 = n3 - n4 + this.scale;
            n6 = this.width > 0 ? this.width - n8 - 1 - n2 : (n3 > 16 ? 16 : n3) - n2;
            if (n6 < 0) {
                n6 = 0;
            }
            stringBuffer.append(string);
            int n10 = n7 + n8;
            int n11 = n10 + n2 + n6;
            n3 = stringBuffer.length();
            if (n11 >= n3) {
                n11 = n3;
                n9 = 48;
            } else {
                n9 = stringBuffer.charAt(n11);
            }
            boolean bl2 = n9 >= 53;
            char c2 = c = bl2 ? (char)'9' : '0';
            while (n11 > n10 + n2 && stringBuffer.charAt(n11 - 1) == c) {
                --n11;
            }
            n = n11 - n10;
            n6 = n - n2;
            if (bl2 && ExponentialFormat.addOne(stringBuffer, n10, n11)) {
                n6 = 0;
                n = ++n2;
            }
            if (n6 == 0 && (this.width <= 0 || n8 + n2 + 1 < this.width)) {
                n6 = 1;
                ++n;
                stringBuffer.insert(n10 + n2, '0');
            }
            stringBuffer.setLength(n10 + n);
        } else {
            string = RealNum.toScaledInt(ratNum, n6 + this.scale).toString();
            stringBuffer.append(string);
            n = string.length();
            n2 = n - n6;
        }
        int n12 = n2 + n6;
        int n13 = this.getMinimumIntegerDigits();
        n13 = n2 >= 0 && n2 > n13 ? 0 : (n13 -= n2);
        if (n2 + n13 <= 0 && (this.width <= 0 || this.width > n6 + 1 + n8)) {
            ++n13;
        }
        n5 = n8 + n + n13 + 1;
        n4 = this.width - n5;
        n3 = n13;
        while (--n3 >= 0) {
            stringBuffer.insert(n7 + n8, '0');
        }
        if (n4 >= 0) {
            n3 = n7;
            if (this.internalPad && n8 > 0) {
                ++n3;
            }
            while (--n4 >= 0) {
                stringBuffer.insert(n3, this.padChar);
            }
        } else if (this.overflowChar != '\u0000') {
            stringBuffer.setLength(n7);
            this.i = this.width;
            while (--this.i >= 0) {
                stringBuffer.append(this.overflowChar);
            }
            return;
        }
        n3 = stringBuffer.length();
        stringBuffer.insert(n3 - n6, '.');
    }

    public void format(RatNum ratNum, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl = ratNum.isNegative();
        if (bl) {
            ratNum = (RatNum)ratNum.rneg();
        }
        this.format(ratNum, bl, stringBuffer, fieldPosition);
    }

    public void format(RealNum realNum, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (realNum instanceof RatNum) {
            this.format((RatNum)realNum, stringBuffer, fieldPosition);
        } else {
            this.format(realNum.doubleValue(), stringBuffer, fieldPosition);
        }
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.format(IntNum.make(l), stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        if (d < 0.0) {
            bl = true;
            d = -d;
        } else {
            bl = false;
        }
        this.format(DFloNum.toExact(d), bl, stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public StringBuffer format(Object object2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(((RealNum)object2).doubleValue(), stringBuffer, fieldPosition);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        throw new Error("RealFixedFormat.parse - not implemented");
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new Error("RealFixedFormat.parseObject - not implemented");
    }
}

