/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.TypeValue;
import gnu.kawa.xml.NodeType;
import gnu.lists.AbstractSequence;
import gnu.lists.GroupPredicate;
import gnu.lists.SeqPosition;
import gnu.mapping.Symbol;
import gnu.xml.XName;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ElementType
extends NodeType
implements TypeValue,
Externalizable,
GroupPredicate {
    Symbol qname;
    public static final ClassType typeElementType = ClassType.make("gnu.kawa.xml.ElementType");
    static final Method coerceMethod = typeElementType.getDeclaredMethod("coerce", 3);
    static final Method coerceOrNullMethod = typeElementType.getDeclaredMethod("coerceOrNull", 3);

    public ElementType(String string, String string2) {
        this(Symbol.make(string, string2));
    }

    public ElementType(Symbol symbol) {
        this(null, symbol);
    }

    public ElementType(String string, Symbol symbol) {
        super(string != null && string.length() > 0 ? string : "ELEMENT " + symbol + " (*)");
        this.qname = symbol;
    }

    public Type getImplementationType() {
        return Type.pointer_type;
    }

    public final String getNamespaceURI() {
        return this.qname.getNamespaceURI();
    }

    public final String getLocalName() {
        return this.qname.getLocalName();
    }

    public void emitCoerceFromObject(CodeAttr codeAttr) {
        codeAttr.emitPushString(this.qname.getNamespaceURI());
        codeAttr.emitPushString(this.qname.getLocalName());
        codeAttr.emitInvokeStatic(coerceMethod);
    }

    public Object coerceFromObject(Object object2) {
        return ElementType.coerce(object2, this.qname.getNamespaceURI(), this.qname.getLocalName());
    }

    public boolean isInstancePos(AbstractSequence abstractSequence, int n) {
        int n2 = abstractSequence.getNextKind(n);
        if (n2 == 33) {
            return this.isInstance(abstractSequence, n, abstractSequence.getNextTypeObject(n));
        }
        if (n2 == 32) {
            return this.isInstance(abstractSequence.getPosNext(n));
        }
        return false;
    }

    public boolean isInstance(AbstractSequence abstractSequence, int n, Object object2) {
        String string;
        String string2;
        String string3 = this.qname.getNamespaceURI();
        String string4 = this.qname.getLocalName();
        if (object2 instanceof XName) {
            XName xName = (XName)object2;
            string2 = xName.getNamespaceURI();
            string = xName.getLocalName();
        } else if (object2 instanceof Symbol) {
            Symbol symbol = (Symbol)object2;
            string2 = symbol.getNamespaceURI();
            string = symbol.getLocalName();
        } else {
            string2 = "";
            string = object2.toString().intern();
        }
        return !(string4 != string && string4 != null || string3 != string2 && string3 != null);
    }

    public boolean isInstance(Object object2) {
        return ElementType.coerceOrNull(object2, this.qname.getNamespaceURI(), this.qname.getLocalName()) != null;
    }

    public static SeqPosition coerceOrNull(Object object2, String string, String string2) {
        String string3;
        String string4;
        SeqPosition seqPosition = NodeType.coerceOrNull(object2, 2);
        if (seqPosition == null) {
            return null;
        }
        Object object3 = seqPosition.getNextTypeObject();
        if (object3 instanceof XName) {
            XName xName = (XName)object3;
            string4 = xName.getNamespaceURI();
            string3 = xName.getLocalName();
        } else if (object3 instanceof Symbol) {
            Symbol symbol = (Symbol)object3;
            string4 = symbol.getNamespaceURI();
            string3 = symbol.getLocalName();
        } else {
            string4 = "";
            string3 = object3.toString().intern();
        }
        if (!(string2 != string3 && string2 != null || string != string4 && string != null)) {
            return seqPosition;
        }
        return null;
    }

    public static SeqPosition coerce(Object object2, String string, String string2) {
        SeqPosition seqPosition = ElementType.coerceOrNull(object2, string, string2);
        if (seqPosition == null) {
            throw new ClassCastException();
        }
        return seqPosition;
    }

    protected void emitCoerceOrNullMethod(Variable variable, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (variable != null) {
            codeAttr.emitLoad(variable);
        }
        codeAttr.emitPushString(this.qname.getNamespaceURI());
        codeAttr.emitPushString(this.qname.getLocalName());
        codeAttr.emitInvokeStatic(coerceOrNullMethod);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string = this.getName();
        objectOutput.writeUTF(string == null ? "" : string);
        objectOutput.writeObject(this.qname);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        if (string.length() > 0) {
            this.setName(string);
        }
        this.qname = (Symbol)objectInput.readObject();
    }

    public String toString() {
        return "ElementType " + this.qname;
    }
}

