/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Symbol;

public class BufferLocalConstraint
extends Constraint {
    Constraint oldConstraint;
    boolean all;
    Buffer lastBuffer;
    Object lastValue;
    Object[] bufferBindings;

    public static void make(Symbol symbol, boolean bl) {
        BufferLocalConstraint bufferLocalConstraint;
        Constraint constraint = BufferLocalConstraint.getConstraint(symbol);
        if (constraint instanceof BufferLocalConstraint) {
            bufferLocalConstraint = (BufferLocalConstraint)constraint;
        } else {
            bufferLocalConstraint = new BufferLocalConstraint();
            bufferLocalConstraint.all = bl;
            bufferLocalConstraint.oldConstraint = constraint;
            symbol.setConstraint(bufferLocalConstraint);
        }
        if (!bl) {
            Buffer buffer = Buffer.getCurrent();
            if (bufferLocalConstraint.lastBuffer != buffer) {
                bufferLocalConstraint.save();
            }
            bufferLocalConstraint.lastBuffer = buffer;
            bufferLocalConstraint.lastValue = bufferLocalConstraint;
        }
    }

    private void save() {
        if (this.lastBuffer == null || this.lastValue == this) {
            return;
        }
        if (this.bufferBindings == null) {
            this.bufferBindings = new Object[20];
            this.bufferBindings[0] = this.lastBuffer;
            this.bufferBindings[1] = this.lastValue;
            return;
        }
        int n = this.bufferBindings.length;
        for (int i = 0; i < n; i += 2) {
            if (this.bufferBindings[i] != this.lastBuffer) continue;
            this.bufferBindings[i + 1] = this.lastValue;
            return;
        }
        Object[] objectArray = new Object[2 * n];
        System.arraycopy(this.bufferBindings, 0, objectArray, 0, n);
        objectArray[n] = this.lastBuffer;
        objectArray[n + 1] = this.lastValue;
        this.bufferBindings = objectArray;
    }

    public boolean isBound(Symbol symbol) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer == this.lastBuffer) {
            if (this.lastValue != this) {
                return true;
            }
        } else if (this.bufferBindings != null) {
            this.save();
            this.lastBuffer = buffer;
            int n = this.bufferBindings.length;
            for (int i = 0; i < n; i += 2) {
                if (this.bufferBindings[i] != buffer) continue;
                this.lastValue = this.bufferBindings[i + 1];
                if (this.lastValue == this) break;
                return true;
            }
            this.lastValue = this;
        }
        return this.oldConstraint.isBound(symbol);
    }

    public Object get(Symbol symbol, Object object2) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer == this.lastBuffer) {
            if (this.lastValue != this) {
                return this.lastValue;
            }
        } else if (this.bufferBindings != null) {
            int n = this.bufferBindings.length;
            for (int i = 0; i < n; i += 2) {
                if (this.bufferBindings[i] != buffer) continue;
                this.save();
                this.lastBuffer = buffer;
                this.lastValue = this.bufferBindings[i + 1];
                if (this.lastValue == this) break;
                return this.lastValue;
            }
        }
        this.lastValue = this.oldConstraint.get(symbol, object2);
        this.lastBuffer = buffer;
        return this.lastValue;
    }

    public void set(Symbol symbol, Object object2) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer != this.lastBuffer) {
            this.save();
            this.lastBuffer = buffer;
            int n = this.bufferBindings.length;
            int n2 = 0;
            while (true) {
                if (n2 == n) {
                    this.lastValue = this;
                    break;
                }
                if (this.bufferBindings[n2] == buffer) {
                    this.lastValue = this.bufferBindings[n2 + 1];
                    break;
                }
                n2 += 2;
            }
        }
        if (this.all || this.lastValue != this) {
            this.lastValue = object2;
            return;
        }
        this.oldConstraint.set(symbol, object2);
    }

    public Environment getEnvironment(Symbol symbol) {
        return this.oldConstraint.getEnvironment(symbol);
    }
}

