# GNU Enterprise Forms - QT 3 UI Driver - Login Handler
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: UILoginHandler.py 9956 2009-10-11 18:54:57Z reinhard $

import os.path

from gnue.common.datasources import GLoginHandler
from gnue.common.apps import GConfig, i18n
from gnue.forms.uidrivers.qt3 import dialogs, QTApp


# =============================================================================
# This class implements a login handler for QT3
# =============================================================================

class UILoginHandler(GLoginHandler.LoginHandler):
    """
    Implementation of a LoginHandler for QT3
    """

    # -------------------------------------------------------------------------
    # Constructor
    # -------------------------------------------------------------------------

    def __init__(self):

        # Make sure to have an application instance available
        self.app = QTApp.getQtApp()

    
    # -------------------------------------------------------------------------
    # Override virtual methods
    # -------------------------------------------------------------------------

    def _askLogin_(self, title, fields):

        lfields = fields [:]
        if lfields [0][2] != 'image':
            imageFile = gConfigForms('loginPNG')
            if not os.path.exists (imageFile):
                imageFile = os.path.join (os.path.normpath ( \
                    GConfig.getInstalledBase ('forms_images', 'common_images')),
                    gConfigForms ('loginPNG'))

            if os.path.exists (imageFile):
                lfields.insert (0, (None, imageFile, 'image', None, None, []))

        dialog = dialogs.InputDialog(title, lfields)
    
        try:
          dialog.exec_loop()
          result = dialog.inputData

        finally:
          del dialog

        return result
