# GNU Enterprise Forms - Curses UI Driver - Grid Line Widget
#
# Copyright 2000-2009 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: gridline.py 9956 2009-10-11 18:54:57Z reinhard $

import curses

from gnue.forms.uidrivers.curses.widgets import _base

__all__ = ['UIGridLine']

# =============================================================================
# Grid widget class
# =============================================================================

class UIGridLine(_base.ManagedBox):
    """
    Interface implementation for <gridline> widgets.
    """

    vertical = False

    # -------------------------------------------------------------------------
    # Widget creation
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):

        _base.ManagedBox._create_widget_(self, event, spacer)
        self._parent = event.container
        self._container = self._parent
        
        return self


    # -------------------------------------------------------------------------
    # Get the size hints for an entry
    # -------------------------------------------------------------------------

    def get_size_hints(self, vertical=None):

        result = _base.ManagedBox.get_size_hints(self, False)
        return (result[0], 1, 0, 0)


    # -------------------------------------------------------------------------
    # Virtual methods
    # -------------------------------------------------------------------------

    def _add_decoration_(self):
        pass

    # -------------------------------------------------------------------------

    def _vertical_offset_(self):

        result = len(self.getParent()._children) - 1
        return result

    # -------------------------------------------------------------------------

    def _add_label_(self, child, index):
        
        label = getattr(child._gfObject, 'label', '')
        if label:
            self._parent.write(child.left, self.top, label,
                    self._uiDriver.attr['background'])

# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass'  : UIGridLine,
  'provides'   : 'GFGridLine',
  'container'  : 1,
}
