# GNU Enterprise Forms - Curses UI Driver - Box Widget
#
# Copyright 2000-2009 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: box.py 9956 2009-10-11 18:54:57Z reinhard $

import curses

from _base import UIHelper, box

__all__ = ['UIBox']

# =============================================================================
# Box class
# =============================================================================

class UIBox(UIHelper):

    # -------------------------------------------------------------------------
    # Create the widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):

        UIHelper._create_widget_(self, event, spacer)

        self._parent = event.container
        self._container = self._parent

    # -------------------------------------------------------------------------
    # Define the bounding box and draw it
    # -------------------------------------------------------------------------

    def set_size_and_fit(self, width, height):

        self.width = width
        self.height = height

        attr = self._uiDriver.attr['background']

        box(self._parent, attr, self.left, self.top, self.right, self.bottom,
                self._gfObject.label)

        for child in self._children:
            child.left = self.left + child.chr_x
            child.top = self.top + child.chr_y
            child.set_size_and_fit(child.chr_w, child.chr_h)


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass'  : UIBox,
  'provides'   : 'GFBox',
  'container'  : 0,
}
