#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2007 Free Software Foundation
#
# FILE:
# utility.py
#
# DESCRIPTION:
#
# NOTES:
#


import curses

#
# utility.py
#

from constants import *

def _paintBorder(dialog, Y, X, H, W, integrateUpper = 0, 
                 caption=None, color=0, captionColor=0):
  """ draw a border with curses_graphics
  """
  Screen = dialog.SCREEN

  dialog.LoLight()
  dialog.AutoRefresh = 0

  upperRC = tiURC
  upperLC = tiULC

  if integrateUpper :
    upperRC = tiUTEE
    upperLC = tiUTEE

  # first line
  Screen.PrintAt( Y,X, chr(upperLC) + (W-2) * chr(tiHLINE) + chr(upperRC), color)

  if caption:
    Screen.PrintAt (Y,X + 2, " %s " % caption, captionColor or color)




  # "body"
  for i in range(Y+1,Y+H-1):
    Screen.PrintAt(i,X, chr(tiVLINE) + (W-2)*' ' + chr(tiVLINE), color)

  # last line
  Screen.PrintAt( Y+H-1, X, chr(tiLLC) + (W-2) * chr(tiHLINE) + chr(tiLRC), color)

  # add title-text ?
  if dialog.HasProperty("TITLETEXT"):
    Screen.PrintAt( Y, X + 2, ' ' + dialog.TITLETEXT+ ' ')

  dialog.AutoRefresh = 1


