@ECHO OFF
REM ---------------------------------------------------------------------------
REM Create an Installer Package
REM
REM $Id: setup.cmd 9736 2007-06-25 14:56:51Z johannes $
REM ---------------------------------------------------------------------------

REM ---------------------------------------------------------------------------
REM Prepare the build environment
REM ---------------------------------------------------------------------------

@ECHO Setting up the build environment ...
SET GNUE_PATH="C:\GNUE"

IF EXIST %GNUE_PATH% (
   RMDIR /S /Q %GNUE_PATH%
)
MKDIR %GNUE_PATH%
MKDIR %GNUE_PATH%\Scripts

COPY setup.py %GNUE_PATH%\Scripts
COPY gnue-common.iss %GNUE_PATH%\Scripts

REM ---------------------------------------------------------------------------
REM Install the package into python's site-packages
REM ---------------------------------------------------------------------------

CD ..\..
@ECHO Installing the package into local site-packages ...

REM NOTE: we do *not* compile the py files here, because this would add a wrong
REM path to the pyc-files, which in turn breaks translation later
python setup.py install --prefix=%GNUE_PATH% --install-lib=%GNUE_PATH%\bin --no-compile


REM ---------------------------------------------------------------------------
REM Compile everything into an exe
REM ---------------------------------------------------------------------------

CD packaging\win32

@ECHO Building EXE-File ...
PUSHD %GNUE_PATH%\Scripts

python setup.py py2exe -c -d %GNUE_PATH%\bin

POPD

REM Catch the built EXE and clean up the build environment
IF EXIST %GNUE_PATH%\dist\*.exe (
    COPY %GNUE_PATH%\dist\*.exe .
    RMDIR /S /Q %GNUE_PATH%
    @ECHO Package completed
)

:EXIT
