/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gnu.gleem.linalg.IntersectionPoint;
import gnu.gleem.linalg.Mat3f;
import gnu.gleem.linalg.MathUtil;
import gnu.gleem.linalg.Vec2f;
import gnu.gleem.linalg.Vec3f;

public class RayTriangleIntersection {
    public static final int ERROR = 0;
    public static final int NO_INTERSECTION = 1;
    public static final int INTERSECTION = 2;
    private static final float epsilon = 0.001f;

    public static int intersectRayWithTriangle(Vec3f rayOrigin, Vec3f rayDirection, Vec3f v0, Vec3f v1, Vec3f v2, IntersectionPoint intersectionPoint) {
        Vec3f O = new Vec3f(v0);
        Vec3f p2 = new Vec3f();
        p2.sub(v1, O);
        Vec3f p3 = new Vec3f();
        p3.sub(v2, O);
        Vec3f X = new Vec3f(p2);
        Vec3f Y = new Vec3f(p3);
        if (X.length() < 0.001f) {
            return 0;
        }
        X.normalize();
        Vec3f tmp = new Vec3f(X);
        tmp.scale(X.dot(Y));
        Y.sub(tmp);
        if (Y.length() < 0.001f) {
            return 0;
        }
        Y.normalize();
        Vec3f Bv = new Vec3f();
        Bv.sub(rayOrigin, O);
        Mat3f A = new Mat3f();
        A.setCol(0, X);
        A.setCol(1, Y);
        Vec3f tmpRayDir = new Vec3f(rayDirection);
        tmpRayDir.scale(-1.0f);
        A.setCol(2, tmpRayDir);
        if (Math.abs(A.determinant()) < 0.001f) {
            return 0;
        }
        A.invert();
        Vec3f B = new Vec3f();
        A.xformVec(Bv, B);
        Vec2f W = new Vec2f(B.x(), B.y());
        Vec2f[] uv = new Vec2f[]{new Vec2f(0.0f, 0.0f), new Vec2f(p2.dot(X), p2.dot(Y)), new Vec2f(p3.dot(X), p3.dot(Y))};
        if (!(Math.abs(uv[1].y()) < 0.001f)) {
            throw new RuntimeException("Math.abs(uv[1].y()) >= epsilon");
        }
        int i = 0;
        while (i < 3) {
            if (!RayTriangleIntersection.approxOnSameSide(uv[i], uv[(i + 1) % 3], uv[(i + 2) % 3], W)) {
                return 1;
            }
            ++i;
        }
        if (!(Math.abs(uv[2].y()) > 0.001f)) {
            throw new RuntimeException("Math.abs(uv[2].y()) <= epsilon");
        }
        if (!(Math.abs(uv[1].x()) > 0.001f)) {
            throw new RuntimeException("Math.abs(uv[1].x()) <= epsilon");
        }
        float b = W.y() / uv[2].y();
        float a = (W.x() - b * uv[2].x()) / uv[1].x();
        p2.scale(a);
        p3.scale(b);
        O.add(p2);
        O.add(p3);
        intersectionPoint.setIntersectionPoint(O);
        intersectionPoint.setT(B.z());
        return 2;
    }

    private static boolean approxOnSameSide(Vec2f linePt1, Vec2f linePt2, Vec2f testPt1, Vec2f testPt2) {
        float num0 = linePt2.y() - linePt1.y();
        float den0 = linePt2.x() - linePt1.x();
        float num1 = linePt1.y() - testPt1.y();
        float den1 = linePt1.x() - testPt1.x();
        float num2 = linePt1.y() - testPt2.y();
        float den2 = linePt1.x() - testPt2.x();
        if (Math.abs(den0) < 0.001f) {
            if (Math.abs(den1) < 0.001f || Math.abs(den2) < 0.001f) {
                return true;
            }
            return MathUtil.sgn(den1) == MathUtil.sgn(den2);
        }
        float m = num0 / den0;
        float val1 = testPt1.y() - linePt1.y() - m * (testPt1.x() - linePt1.x());
        float val2 = testPt2.y() - linePt1.y() - m * (testPt2.x() - linePt1.x());
        if (Math.abs(val1) < 0.001f || Math.abs(val2) < 0.001f) {
            return true;
        }
        return MathUtil.sgn(val1) == MathUtil.sgn(val2);
    }

    static {
        ERROR = 0;
        NO_INTERSECTION = 1;
        INTERSECTION = 2;
        epsilon = 0.001f;
    }
}

