/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.utils;

import com.sun.electric.database.text.Pref;
import com.sun.electric.plugins.j3d.View3DWindow;
import com.sun.electric.plugins.j3d.utils.J3DAlpha;
import com.sun.electric.plugins.j3d.utils.J3DAxis;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.util.math.DBMath;
import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;
import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public final class J3DUtils {
    public static final Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    public static final Color3f plastic = new Color3f(0.89f, 0.89f, 0.89f);
    private static Color3fObservable ambientalColor;
    private static Color3fObservable directionalColor;
    private static Color3fObservable backgroundColor;
    private static Vector3fObservable[] lights;
    public static final BoundingSphere infiniteBounds;
    private static Pref cache3DOrigZoom;
    private static Pref cache3DRot;
    private static Pref cache3DFactor;
    private static Pref cache3DAntialiasing;
    private static Pref cache3DPerspective;
    private static Pref cache3DCellBnd;
    private static Pref cache3DAxes;
    private static Pref cache3DMaxNumber;
    private static Pref cache3DAlpha;
    private static Pref cache3DLightDirs;
    public static J3DAlpha jAlpha;
    private static final int VALUES_PER_LINE = 11;
    private static double[] lastValidValues;
    private static Font3D font3D;

    public static String get3DLightDirs() {
        return cache3DLightDirs.getString();
    }

    public static void set3DLightDirs(String c) {
        cache3DLightDirs.setString(c);
        J3DUtils.setDirections(null);
    }

    public static String getFactory3DLightDirs() {
        return cache3DLightDirs.getStringFactoryValue();
    }

    public static int[] get3DColorAxes() {
        return new int[]{User.getColor(User.ColorPrefType.AXIS_X_3D), User.getColor(User.ColorPrefType.AXIS_Y_3D), User.getColor(User.ColorPrefType.AXIS_Z_3D)};
    }

    public static int get3DMaxNumNodes() {
        return cache3DMaxNumber.getInt();
    }

    public static void set3DMaxNumNodes(int num) {
        cache3DMaxNumber.setInt(num);
    }

    public static int getFactory3DMaxNumNodes() {
        return cache3DMaxNumber.getIntFactoryValue();
    }

    public static boolean is3DAxesOn() {
        return cache3DAxes.getBoolean();
    }

    public static void set3DAxesOn(boolean on) {
        cache3DAxes.setBoolean(on);
    }

    public static boolean isFactory3DAxesOn() {
        return cache3DAxes.getBooleanFactoryValue();
    }

    public static boolean is3DCellBndOn() {
        return cache3DCellBnd.getBoolean();
    }

    public static void set3DCellBndOn(boolean on) {
        cache3DCellBnd.setBoolean(on);
    }

    public static boolean isFactory3DCellBndOn() {
        return cache3DCellBnd.getBooleanFactoryValue();
    }

    public static boolean is3DPerspective() {
        return cache3DPerspective.getBoolean();
    }

    public static void set3DPerspective(boolean on) {
        cache3DPerspective.setBoolean(on);
    }

    public static boolean isFactory3DPerspective() {
        return cache3DPerspective.getBooleanFactoryValue();
    }

    public static boolean is3DAntialiasing() {
        return cache3DAntialiasing.getBoolean();
    }

    public static void set3DAntialiasing(boolean on) {
        cache3DAntialiasing.setBoolean(on);
    }

    public static boolean isFactory3DAntialiasing() {
        return cache3DAntialiasing.getBooleanFactoryValue();
    }

    public static double get3DOrigZoom() {
        return cache3DOrigZoom.getDouble();
    }

    public static void set3DOrigZoom(double value) {
        cache3DOrigZoom.setDouble(value);
    }

    public static double getFactory3DOrigZoom() {
        return cache3DOrigZoom.getDoubleFactoryValue();
    }

    public static String get3DRotation() {
        return cache3DRot.getString();
    }

    public static void set3DRotation(String value) {
        cache3DRot.setString(value);
    }

    public static String getFactory3DRotation() {
        return cache3DRot.getStringFactoryValue();
    }

    public static double get3DFactor() {
        return cache3DFactor.getDouble();
    }

    public static void set3DFactor(double value) {
        cache3DFactor.setDouble(value);
    }

    public static double getFactory3DFactor() {
        return cache3DFactor.getDoubleFactoryValue();
    }

    public static int get3DAlpha() {
        return cache3DAlpha.getInt();
    }

    public static void set3DAlpha(int value) {
        cache3DAlpha.setInt(value);
        J3DUtils.setAlpha(value);
    }

    public static int getFactory3DAlpha() {
        return cache3DAlpha.getIntFactoryValue();
    }

    public static List<ThreeDDemoKnot> readDemoDataFromFile(View3DWindow view3D) {
        String fileName = OpenFile.chooseInputFile(FileType.TEXT, null, null);
        if (fileName == null) {
            return null;
        }
        String[] possibleValues = new String[]{"Accept All", "OK", "Skip", "Cancel"};
        ArrayList<ThreeDDemoKnot> knotList = null;
        try {
            String line;
            LineNumberReader lineReader = new LineNumberReader(new FileReader(fileName));
            int response = -1;
            while ((line = lineReader.readLine()) != null) {
                if (response != 0) {
                    response = Job.getUserInterface().askForChoice("Applying following data " + line, "Action", possibleValues, possibleValues[0]);
                    if (response == 2) continue;
                    if (response == 3) break;
                }
                String[] stringValues = J3DUtils.parseValues(line, 0);
                double[] values = J3DUtils.convertValues(stringValues);
                if (knotList == null) {
                    knotList = new ArrayList<ThreeDDemoKnot>();
                }
                knotList.add(view3D.moveAndRotate(values));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return knotList;
    }

    public static double[] convertValues(String[] stringValues) {
        double[] values = new double[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            try {
                values[i] = Double.parseDouble(stringValues[i]);
            }
            catch (Exception e) {
                values[i] = lastValidValues[i];
            }
            J3DUtils.lastValidValues[i] = values[i];
            if (2 >= i || i >= 6) continue;
            values[i] = J3DUtils.convertToRadiant(values[i]);
        }
        return values;
    }

    public static String[] parseValues(String line, int lineNumner) {
        int count2 = 0;
        String[] strings = new String[11];
        StringTokenizer parse = new StringTokenizer(line, " ", false);
        while (parse.hasMoreTokens() && count2 < 11) {
            strings[count2++] = parse.nextToken();
        }
        if (count2 < 9 || count2 > 13) {
            System.out.println("Error reading capacitance file in line " + lineNumner);
        }
        return strings;
    }

    public static Vector3f[] transformIntoVectors(String dir) {
        float[][] values = new float[2][3];
        StringTokenizer parse = new StringTokenizer(dir, "()", false);
        for (int pair = 0; parse.hasMoreTokens() && pair < 2; ++pair) {
            String vector = parse.nextToken();
            StringTokenizer parseDir = new StringTokenizer(vector, " )", false);
            int count2 = 0;
            while (parseDir.hasMoreTokens() && count2 < 3) {
                String value = parseDir.nextToken();
                values[pair][count2++] = Float.parseFloat(value);
            }
        }
        Vector3f[] vectors = new Vector3f[2];
        for (int i = 0; i < 2; ++i) {
            if (values[i][0] == 0.0f && values[i][1] == 0.0f && values[i][2] == 0.0f) continue;
            vectors[i] = new Vector3f(values[i]);
        }
        return vectors;
    }

    public static void setDirections(Object initValue) {
        Vector3f[] dirs = J3DUtils.transformIntoVectors(J3DUtils.get3DLightDirs());
        for (int i = 0; i < dirs.length; ++i) {
            if (lights[i] == null) {
                J3DUtils.lights[i] = new Vector3fObservable(dirs[i]);
                continue;
            }
            if (initValue != null) continue;
            lights[i].setValue(dirs[i]);
        }
    }

    public static void setAmbientalColor(Object initValue) {
        Color3f userColor = new Color3f(new Color(User.getColor(User.ColorPrefType.AMBIENT_3D)));
        if (ambientalColor == null) {
            ambientalColor = new Color3fObservable(userColor);
        } else if (initValue == null) {
            ambientalColor.setValue(userColor);
        }
    }

    public static void setDirectionalColor(Object initValue) {
        Color3f userColor = new Color3f(new Color(User.getColor(User.ColorPrefType.DIRECTIONAL_LIGHT_3D)));
        if (directionalColor == null) {
            directionalColor = new Color3fObservable(userColor);
        } else if (initValue == null) {
            directionalColor.setValue(userColor);
        }
    }

    public static void setBackgroundColor(Object initValue) {
        Color3f userColor = new Color3f(new Color(User.getColor(User.ColorPrefType.BACKGROUND)));
        if (backgroundColor == null) {
            backgroundColor = new Color3fObservable(userColor);
        } else if (initValue == null) {
            backgroundColor.setValue(userColor);
        }
    }

    public static void createBackground(BranchGroup scene) {
        J3DUtils.setBackgroundColor(scene);
        BackgroundObserver bg = new BackgroundObserver(backgroundColor.getValue());
        backgroundColor.addObserver(bg);
        bg.setApplicationBounds((Bounds)infiniteBounds);
        scene.addChild((Node)bg);
    }

    public static void setAlpha(int speed) {
        if (jAlpha == null) {
            jAlpha = new J3DAlpha(speed, true, 0.5f);
        } else {
            jAlpha.setAlphaSpeed(speed);
        }
    }

    public static void createLights(BranchGroup scene) {
        J3DUtils.setDirectionalColor(scene);
        J3DUtils.setAmbientalColor(scene);
        J3DUtils.setDirections(scene);
        AmbientLightObserver ambientalLight = new AmbientLightObserver(ambientalColor.getValue());
        ambientalLight.setInfluencingBounds((Bounds)infiniteBounds);
        ambientalLight.setCapability(14);
        ambientalLight.setCapability(15);
        ambientalColor.addObserver(ambientalLight);
        scene.addChild((Node)ambientalLight);
        for (int i = 0; i < lights.length; ++i) {
            if (lights[i] == null || lights[i].getValue() == null || J3DUtils.lights[i].getValue().x == 0.0f && J3DUtils.lights[i].getValue().y == 0.0f && J3DUtils.lights[i].getValue().z == 0.0f) continue;
            DirectionalLightObserver directionalLight = new DirectionalLightObserver(directionalColor.getValue(), lights[i].getValue());
            directionalLight.setInfluencingBounds((Bounds)infiniteBounds);
            directionalLight.setCapability(13);
            directionalLight.setCapability(18);
            directionalLight.setCapability(19);
            directionalLight.setCapability(14);
            directionalLight.setCapability(15);
            lights[i].addObserver(directionalLight);
            directionalColor.addObserver(directionalLight);
            scene.addChild((Node)directionalLight);
        }
    }

    public static void setViewPoint(SimpleUniverse u, Canvas3D canvas, BranchGroup scene, Rectangle2D cellBnd) {
        BoundingSphere sceneBnd = (BoundingSphere)scene.getBounds();
        double radius = sceneBnd.getRadius();
        View view = u.getViewer().getView();
        if (canvas.getSceneAntialiasingAvailable() && J3DUtils.is3DAntialiasing()) {
            view.setSceneAntialiasingEnable(true);
        }
        view.setProjectionPolicy(J3DUtils.is3DPerspective() ? 1 : 0);
        if (!J3DUtils.is3DPerspective()) {
            view.setCompatibilityModeEnable(true);
        }
        Point3d c1 = new Point3d();
        sceneBnd.getCenter(c1);
        Vector3d vCenter = new Vector3d((Tuple3d)c1);
        double vDist = 1.4 * radius / Math.tan(view.getFieldOfView() / 2.0);
        Point3d c2 = new Point3d();
        sceneBnd.getCenter(c2);
        c2.z += vDist;
        vCenter.z += vDist;
        Transform3D vTrans = new Transform3D();
        vTrans.set(vCenter);
        view.setBackClipDistance((vDist + radius) * 2.0);
        view.setFrontClipDistance((vDist + radius) / 200.0);
        view.setBackClipPolicy(2);
        view.setFrontClipPolicy(2);
        if (J3DUtils.is3DPerspective()) {
            u.getViewingPlatform().getViewPlatformTransform().setTransform(vTrans);
        } else {
            Transform3D proj = new Transform3D();
            proj.ortho(cellBnd.getMinX(), cellBnd.getMinX(), cellBnd.getMinY(), cellBnd.getMaxY(), (vDist + radius) / 200.0, (vDist + radius) * 2.0);
            view.setVpcToEc(proj);
        }
    }

    public static double convertToRadiant(double degrees) {
        return Math.PI * degrees / 180.0;
    }

    public static boolean updateZValues(Shape3D shape, float origZ1, float origZ2, float z1, float z2) {
        if (DBMath.areEquals(z1, z2)) {
            return false;
        }
        GeometryArray ga = (GeometryArray)shape.getGeometry();
        ga.updateData((GeometryUpdater)new JGeometryUpdater(origZ1, origZ2, z1, z2));
        return true;
    }

    public static Node addCylinder(Point2D[] points, double distance, double thickness, Appearance ap, TransformGroup objTrans) {
        double cX = points[0].getX();
        double cY = points[0].getY();
        double radius = points[0].distance(points[1]);
        Cylinder cylinder = new Cylinder((float)radius, (float)thickness, ap);
        Vector3d bottomCenter = new Vector3d(cX, cY, distance);
        Transform3D t = new Transform3D();
        t.rotX(1.5707963267948966);
        t.setTranslation(bottomCenter);
        t.setScale(1.0);
        TransformGroup grp = new TransformGroup(t);
        grp.addChild((Node)cylinder);
        grp.setCapability(18);
        grp.setCapability(17);
        grp.setCapability(14);
        grp.setCapability(12);
        grp.setCapability(13);
        grp.setCapability(1);
        grp.setCapability(11);
        grp.setCapability(5);
        grp.setCapability(3);
        Shape3D[] shapes = new Shape3D[]{cylinder.getShape(0), cylinder.getShape(1), cylinder.getShape(2)};
        for (int i = 0; i < 3; ++i) {
            shapes[i].setCapability(1);
            shapes[i].setCapability(32);
            shapes[i].setCapability(11);
            shapes[i].setCapability(5);
            shapes[i].setCapability(14);
            shapes[i].setCapability(15);
            shapes[i].setCapability(3);
            shapes[i].setCapability(13);
            PickTool.setCapabilities((Node)shapes[i], (int)4098);
        }
        objTrans.addChild((Node)grp);
        return cylinder;
    }

    public static Shape3D addPolyhedron(Rectangle2D bounds, double distance, double thickness, Appearance ap, TransformGroup objTrans) {
        GeometryInfo gi = new GeometryInfo(2);
        double height = thickness + distance;
        Point3d[] pts = new Point3d[]{new Point3d(bounds.getMinX(), bounds.getMinY(), distance), new Point3d(bounds.getMinX(), bounds.getMaxY(), distance), new Point3d(bounds.getMaxX(), bounds.getMaxY(), distance), new Point3d(bounds.getMaxX(), bounds.getMinY(), distance), new Point3d(bounds.getMinX(), bounds.getMinY(), height), new Point3d(bounds.getMinX(), bounds.getMaxY(), height), new Point3d(bounds.getMaxX(), bounds.getMaxY(), height), new Point3d(bounds.getMaxX(), bounds.getMinY(), height)};
        int[] indices = new int[]{0, 1, 2, 3, 0, 4, 5, 1, 0, 3, 7, 4, 1, 5, 6, 2, 2, 6, 7, 3, 4, 7, 6, 5};
        gi.setCoordinates(pts);
        gi.setCoordinateIndices(indices);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        GeometryArray c = gi.getGeometryArray(true, false, false);
        c.setCapability(18);
        c.setCapability(1);
        c.setCapability(128);
        c.setCapability(21);
        c.setCapability(19);
        Shape3D box = new Shape3D((Geometry)c, ap);
        box.setCapability(1);
        box.setCapability(11);
        box.setCapability(5);
        box.setCapability(14);
        box.setCapability(15);
        box.setCapability(3);
        box.setCapability(13);
        PickTool.setCapabilities((Node)box, (int)4100);
        objTrans.addChild((Node)box);
        return box;
    }

    public static Shape3D addShape3D(Point3d[] pts, int listLen, Appearance ap, TransformGroup objTrans) {
        int numFaces = listLen + 2;
        int[] indices = new int[listLen * 6];
        int[] stripCounts = new int[numFaces];
        int[] contourCount = new int[numFaces];
        Arrays.fill(contourCount, 1);
        Arrays.fill(stripCounts, 4);
        stripCounts[0] = listLen;
        stripCounts[numFaces - 1] = listLen;
        int count2 = 0;
        int i = 0;
        while (i < listLen) {
            indices[count2++] = i++;
        }
        for (i = 0; i < listLen; ++i) {
            indices[count2++] = i;
            indices[count2++] = i + listLen;
            indices[count2++] = (i + 1) % listLen + listLen;
            indices[count2++] = (i + 1) % listLen;
        }
        for (i = 0; i < listLen; ++i) {
            indices[count2++] = (listLen - i) % listLen + listLen;
        }
        GeometryInfo gi = new GeometryInfo(5);
        gi.setCoordinates(pts);
        gi.setCoordinateIndices(indices);
        gi.setStripCounts(stripCounts);
        gi.setContourCounts(contourCount);
        NormalGenerator ng = new NormalGenerator();
        ng.setCreaseAngle((double)((float)Math.toRadians(30.0)));
        ng.generateNormals(gi);
        GeometryArray c = gi.getGeometryArray();
        c.setCapability(18);
        Shape3D box = new Shape3D((Geometry)c, ap);
        box.setCapability(1);
        box.setCapability(11);
        box.setCapability(5);
        box.setCapability(14);
        box.setCapability(15);
        box.setCapability(3);
        PickTool.setCapabilities((Node)box, (int)4100);
        objTrans.addChild((Node)box);
        return box;
    }

    public static Shape3D addLine3D(Point3d[] pts, Appearance ap, TransformGroup objTrans) {
        LineArray la = new LineArray(pts.length, 1);
        for (int i = 0; i < pts.length; ++i) {
            la.setCoordinate(i, pts[i]);
        }
        la.setCapability(18);
        Shape3D lines2 = new Shape3D((Geometry)la, ap);
        lines2.setCapability(1);
        lines2.setCapability(11);
        lines2.setCapability(5);
        lines2.setCapability(14);
        lines2.setCapability(15);
        lines2.setCapability(3);
        PickTool.setCapabilities((Node)lines2, (int)4100);
        objTrans.addChild((Node)lines2);
        return lines2;
    }

    public static Shape3D addText(String text, double x, double y, double z, Appearance ap, TransformGroup objTrans) {
        if (font3D == null) {
            font3D = new Font3D(new Font(User.getDefaultFont(), 0, 2), new FontExtrusion());
        }
        Text3D axisText = new Text3D(font3D, text);
        Shape3D label = new Shape3D((Geometry)axisText, ap);
        Transform3D textScale = new Transform3D();
        textScale.set(0.015);
        textScale.setTranslation(new Vector3d(x, y, z));
        TransformGroup axisLabelG = new TransformGroup(textScale);
        axisLabelG.addChild((Node)label);
        objTrans.addChild((Node)axisLabelG);
        return label;
    }

    public static Shape3D addPolyhedron(PathIterator pIt, double distance, double thickness, Appearance ap, TransformGroup objTrans) {
        double height = thickness + distance;
        double[] coords = new double[6];
        ArrayList<Point3d> topList = new ArrayList<Point3d>();
        ArrayList<Point3d> bottomList = new ArrayList<Point3d>();
        ArrayList<Shape3D> shapes = new ArrayList<Shape3D>();
        while (!pIt.isDone()) {
            int type = pIt.currentSegment(coords);
            if (type == 4) {
                int listLen = topList.size();
                Point3d[] pts = new Point3d[listLen * 2];
                J3DUtils.correctNormals(topList, bottomList);
                System.arraycopy(topList.toArray(), 0, pts, 0, listLen);
                System.arraycopy(bottomList.toArray(), 0, pts, listLen, listLen);
                int numFaces = listLen + 2;
                int[] indices = new int[listLen * 6];
                int[] stripCounts = new int[numFaces];
                int[] contourCount = new int[numFaces];
                Arrays.fill(contourCount, 1);
                Arrays.fill(stripCounts, 4);
                stripCounts[0] = listLen;
                stripCounts[numFaces - 1] = listLen;
                int count2 = 0;
                int i = 0;
                while (i < listLen) {
                    indices[count2++] = i++;
                }
                for (i = 0; i < listLen; ++i) {
                    indices[count2++] = i;
                    indices[count2++] = i + listLen;
                    indices[count2++] = (i + 1) % listLen + listLen;
                    indices[count2++] = (i + 1) % listLen;
                }
                for (i = 0; i < listLen; ++i) {
                    indices[count2++] = (listLen - i) % listLen + listLen;
                }
                GeometryInfo gi = new GeometryInfo(5);
                gi.setCoordinates(pts);
                gi.setCoordinateIndices(indices);
                gi.setStripCounts(stripCounts);
                gi.setContourCounts(contourCount);
                NormalGenerator ng = new NormalGenerator();
                ng.setCreaseAngle((double)((float)Math.toRadians(30.0)));
                ng.generateNormals(gi);
                GeometryArray c = gi.getGeometryArray();
                c.setCapability(18);
                Shape3D box = new Shape3D((Geometry)c, ap);
                box.setCapability(1);
                box.setCapability(11);
                box.setCapability(5);
                box.setCapability(14);
                box.setCapability(15);
                box.setCapability(3);
                PickTool.setCapabilities((Node)box, (int)4100);
                objTrans.addChild((Node)box);
                shapes.add(box);
                topList.clear();
                bottomList.clear();
            } else if (type == 0 || type == 1) {
                Point3d pt = new Point3d(coords[0], coords[1], distance);
                topList.add(pt);
                pt = new Point3d(coords[0], coords[1], height);
                bottomList.add(pt);
            }
            pIt.next();
        }
        if (shapes.size() > 1) {
            System.out.println("Error: case not handled");
        }
        return (Shape3D)shapes.get(0);
    }

    public static void correctNormals(List<Point3d> topList, List<Point3d> bottomList) {
        Point3d p0 = topList.get(0);
        Point3d p1 = new Point3d(topList.get(1));
        p1.sub((Tuple3d)p0);
        Point3d pn = new Point3d(topList.get(topList.size() - 1));
        pn.sub((Tuple3d)p0);
        Vector3d aux = new Vector3d();
        aux.cross(new Vector3d((Tuple3d)p1), new Vector3d((Tuple3d)pn));
        Point3d b0 = new Point3d(bottomList.get(0));
        b0.sub((Tuple3d)p0);
        double dot = aux.dot(new Vector3d((Tuple3d)b0));
        if (dot > 0.0) {
            Collections.reverse(topList);
            Collections.reverse(bottomList);
        }
    }

    public static KBKeyFrame getNextKBKeyFrame(float ratio, ThreeDDemoKnot knot) {
        Vector3f pos = new Vector3f(knot.xValue + 100.0f, knot.yValue + 100.0f, knot.zValue);
        Point3f point = new Point3f((Tuple3f)pos);
        Point3f scale = new Point3f(knot.scale, knot.scale, knot.scale);
        KBKeyFrame key = new KBKeyFrame(ratio, 0, point, knot.heading, knot.pitch, knot.bank, scale, 0.0f, 0.0f, 1.0f);
        return key;
    }

    public static TCBKeyFrame getNextTCBKeyFrame(float ratio, ThreeDDemoKnot knot) {
        Vector3f pos = knot.translation;
        if (pos == null) {
            pos = new Vector3f(knot.xValue, knot.yValue, knot.zValue);
        }
        Point3f point = new Point3f((Tuple3f)pos);
        Quat4f quat = knot.rotation;
        if (quat == null) {
            quat = J3DUtils.createQuaternionFromEuler(knot.rotX, knot.rotY, knot.rotZ);
        }
        Point3f scale = new Point3f(knot.scale, knot.scale, knot.scale);
        TCBKeyFrame key = new TCBKeyFrame(ratio, 0, point, quat, scale, 0.0f, 0.0f, 1.0f);
        return key;
    }

    private static Quat4f createQuaternionFromAxisAndAngle(Vector3d axis, double angle) {
        double sin_a = Math.sin(angle / 2.0);
        double cos_a = Math.cos(angle / 2.0);
        Vector4f q = new Vector4f();
        q.x = (float)(axis.x * sin_a);
        q.y = (float)(axis.y * sin_a);
        q.z = (float)(axis.z * sin_a);
        q.w = (float)cos_a;
        q.normalize();
        return new Quat4f((Tuple4f)q);
    }

    public static Quat4f createQuaternionFromEuler(double angleX, double angleY, double angleZ) {
        Quat4f qx = J3DUtils.createQuaternionFromAxisAndAngle(J3DAxis.axisX, angleX);
        Quat4f qy = J3DUtils.createQuaternionFromAxisAndAngle(J3DAxis.axisY, angleY);
        Quat4f qz = J3DUtils.createQuaternionFromAxisAndAngle(J3DAxis.axisZ, angleZ);
        qx.mul(qy);
        qx.mul(qz);
        return qx;
    }

    public static void get3DColorsInTab(Map<User.ColorPrefType, String> nameTypeSpecialMap) {
        nameTypeSpecialMap.put(User.ColorPrefType.INSTANCE_3D, "Special: 3D CELL INSTANCES");
        nameTypeSpecialMap.put(User.ColorPrefType.HIGHLIGHT_3D, "Special: 3D HIGHLIGHTED INSTANCES");
        nameTypeSpecialMap.put(User.ColorPrefType.AMBIENT_3D, "Special: 3D AMBIENT LIGHT");
        nameTypeSpecialMap.put(User.ColorPrefType.DIRECTIONAL_LIGHT_3D, "Special: 3D DIRECTIONAL LIGHT");
        nameTypeSpecialMap.put(User.ColorPrefType.AXIS_X_3D, "Special: 3D AXIS X");
        nameTypeSpecialMap.put(User.ColorPrefType.AXIS_Y_3D, "Special: 3D AXIS Y");
        nameTypeSpecialMap.put(User.ColorPrefType.AXIS_Z_3D, "Special: 3D AXIS Z");
    }

    static {
        lights = new Vector3fObservable[2];
        infiniteBounds = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
        cache3DOrigZoom = Pref.makeDoublePref("3DOrigZoom3D", User.getUserTool().prefs, 1.0);
        cache3DRot = Pref.makeStringPref("3DRotation", User.getUserTool().prefs, "(0 0 0)");
        cache3DFactor = Pref.makeDoublePref("3DScaleZ", User.getUserTool().prefs, 1.0);
        cache3DAntialiasing = Pref.makeBooleanPref("3DAntialiasing", User.getUserTool().prefs, false);
        cache3DPerspective = Pref.makeBooleanPref("3DPerspective", User.getUserTool().prefs, true);
        cache3DCellBnd = Pref.makeBooleanPref("3DCellBnd", User.getUserTool().prefs, true);
        cache3DAxes = Pref.makeBooleanPref("3DAxes", User.getUserTool().prefs, false);
        cache3DMaxNumber = Pref.makeIntPref("3DMaxNumNodes", User.getUserTool().prefs, 1000);
        cache3DAlpha = Pref.makeIntPref("3DAlpha", User.getUserTool().prefs, 20000);
        cache3DLightDirs = Pref.makeStringPref("3DLightDirs", User.getUserTool().prefs, "(-1 1 -1)(1 -1 -1)");
        jAlpha = null;
        lastValidValues = new double[11];
    }

    public static class OffScreenCanvas3D
    extends Canvas3D {
        public OffScreenCanvas3D(GraphicsConfiguration graphicsConfiguration, boolean offScreen) {
            super(graphicsConfiguration, offScreen);
        }

        BufferedImage doRender(int width, int height) {
            BufferedImage bImage = new BufferedImage(width, height, 2);
            ImageComponent2D buffer = new ImageComponent2D(2, bImage);
            this.setOffScreenBuffer(buffer);
            this.renderOffScreenBuffer();
            this.waitForOffScreenRendering();
            bImage = this.getOffScreenBuffer().getImage();
            return bImage;
        }

        public void postSwap() {
        }
    }

    public static class ThreeDDemoKnot
    implements Serializable {
        private static final long serialVersionUID = -7059885190094183408L;
        float xValue;
        float yValue;
        float zValue;
        Vector3f translation;
        float scale;
        float heading;
        float pitch;
        float bank;
        double rotZ;
        double rotY;
        double rotX;
        Quat4f rotation;

        public ThreeDDemoKnot(double xValue, double yValue, double zValue, double scale, double heading, double pitch, double bank, double rotX, double rotY, double rotZ) {
            this.xValue = (float)xValue;
            this.yValue = (float)yValue;
            this.zValue = (float)zValue;
            this.scale = (float)scale;
            this.heading = (float)heading;
            this.pitch = (float)pitch;
            this.bank = (float)bank;
            this.rotZ = rotZ;
            this.rotX = rotX;
            this.rotY = rotY;
        }

        public ThreeDDemoKnot(double scale, Vector3f trans, Quat4f rot, Shape3D shape) {
            this.scale = (float)scale;
            this.translation = trans;
            this.rotation = rot;
        }
    }

    private static class JGeometryUpdater
    implements GeometryUpdater {
        float z1;
        float z2;
        float origZ1;
        float origZ2;

        public JGeometryUpdater(float origZ1, float origZ2, float z1, float z2) {
            this.z1 = z1;
            this.z2 = z2;
            this.origZ1 = origZ1;
            this.origZ2 = origZ2;
        }

        public void updateData(Geometry geometry) {
            if (!(geometry instanceof GeometryArray)) {
                return;
            }
            GeometryArray ga = (GeometryArray)geometry;
            float[] vals = ga.getCoordRefFloat();
            for (int i = 0; i < vals.length / 3; ++i) {
                if (DBMath.areEquals(vals[i * 3 + 2], this.origZ1)) {
                    vals[i * 3 + 2] = this.z1;
                    continue;
                }
                if (!DBMath.areEquals(vals[i * 3 + 2], this.origZ2)) continue;
                vals[i * 3 + 2] = this.z2;
            }
            ga.setCoordRefFloat(vals);
        }
    }

    private static class BackgroundObserver
    extends Background
    implements Observer {
        public BackgroundObserver(Color3f color3f) {
            super(color3f);
            this.setCapability(17);
            this.setCapability(16);
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg != null && arg instanceof Color3f) {
                this.setColor((Color3f)arg);
            }
        }
    }

    private static class AmbientLightObserver
    extends AmbientLight
    implements Observer {
        public AmbientLightObserver(Color3f color3f) {
            super(color3f);
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg != null && arg instanceof Color3f) {
                this.setColor((Color3f)arg);
            }
        }
    }

    private static class Color3fObservable
    extends Observable {
        private Color3f color;

        public Color3fObservable(Color3f color) {
            this.color = color;
        }

        public void setValue(Color3f color) {
            this.color = color;
            this.setChanged();
            this.notifyObservers(color);
            this.clearChanged();
        }

        public Color3f getValue() {
            return this.color;
        }
    }

    private static class DirectionalLightObserver
    extends DirectionalLight
    implements Observer {
        public DirectionalLightObserver(Color3f color3f, Vector3f vector3f) {
            super(color3f, vector3f);
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg != null) {
                if (arg instanceof Vector3f) {
                    this.setDirection((Vector3f)arg);
                    return;
                }
                if (arg instanceof Color3f) {
                    this.setColor((Color3f)arg);
                    return;
                }
            }
        }
    }

    private static class Vector3fObservable
    extends Observable {
        private Vector3f vector;

        public Vector3fObservable(Vector3f vec) {
            this.vector = vec;
        }

        public void setValue(Vector3f vec) {
            this.vector = vec;
            this.setChanged();
            this.notifyObservers(this.vector);
            this.clearChanged();
        }

        public Vector3f getValue() {
            return this.vector;
        }
    }
}

