/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.Launcher;
import com.sun.electric.util.TextUtils;
import java.net.URL;
import javax.swing.ImageIcon;

public class Resources {
    private static final String resourceLocation = "resources/";
    private static final String plugin3D = "com.sun.electric.plugins.j3d";
    private static final String pluginJython = "org.python.util";

    public static ImageIcon getResource(Class<?> theClass, String iconName) {
        return new ImageIcon(Resources.getURLResource(theClass, iconName));
    }

    public static URL getURLResource(Class<?> theClass, String resourceName) {
        return theClass.getResource(resourceLocation + resourceName);
    }

    public static Class<?> get3DClass(String name) {
        Class<?> java3DClass = Resources.getClass("SimpleUniverse", "com.sun.j3d.utils.universe");
        if (java3DClass == null) {
            return null;
        }
        return Resources.getClass(name, plugin3D);
    }

    public static Class<?> getJythonClass(String name) {
        return Resources.getClass(name, pluginJython);
    }

    private static Class<?> getClass(String name, String plugin) {
        Class theClass = null;
        try {
            theClass = Launcher.classFromPlugins(plugin + "." + name);
        }
        catch (ClassNotFoundException e) {
            TextUtils.recordMissingComponent(name);
        }
        catch (Error e) {
            System.out.println("Error accessing plugin '" + plugin + "': " + e.getMessage());
        }
        return theClass;
    }
}

