/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.EquipmentInterface;
import com.sun.electric.tool.simulation.test.GPIB;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.Logger;
import com.sun.electric.tool.simulation.test.SimulationModel;

public class Equipment
extends Logger
implements EquipmentInterface {
    public static final int CONTROLLER_ID_NUMBER = 512;
    private int ud = -1;
    private String name;

    public Equipment(String name) {
        this.name = name;
        if (this.isDisabled()) {
            Logger.logInit("  GPIB device " + name + " not enabled for this test.");
            return;
        }
        if (Infrastructure.gpibControllers == null) {
            Infrastructure.fatal("You must set Infrastructure.gpibControllers before initializing any GPIB devices");
        }
        this.ud = GPIB.findDevice(name);
        Logger.logInit("  Initializing GPIB device: " + name + ", ud: " + this.ud);
        int board = this.ask(512);
        for (int ind = 0; ind < Infrastructure.gpibControllers.length; ++ind) {
            if (board != Infrastructure.gpibControllers[ind]) continue;
            return;
        }
        Infrastructure.fatal("Device " + name + " is on controller number " + board + ", which is not in Infrastructure.gpibControllers");
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void write(String data2) {
        if (this.isDisabled()) {
            return;
        }
        if (this.ud < 0) {
            System.out.println("can't write to uninitized device:" + this);
        }
        GPIB.ibWrite(this.ud, this.name, data2);
    }

    public String read(int length) {
        String result2;
        if (this.isDisabled()) {
            return "";
        }
        if (this.ud < 0) {
            System.out.println("can't read from uninitized device:" + this);
        }
        if ((result2 = GPIB.ibRead(this.ud, this.name, length).trim()).length() == 0) {
            Infrastructure.nonfatal("Empty string from id " + this.ud);
        }
        return result2.trim();
    }

    public String readLine() {
        return this.read(80);
    }

    public float readFloat(int length) {
        if (this.isDisabled()) {
            return 0.0f;
        }
        String s = this.read(length);
        return Float.parseFloat(s);
    }

    public int ask(int option) {
        if (this.isDisabled()) {
            return 0;
        }
        return GPIB.ibAsk(this.ud, this.name, option);
    }

    public void clear() {
        if (this.isDisabled()) {
            return;
        }
        GPIB.ibClr(this.ud, this.name);
    }

    public void command(String command) {
        if (this.isDisabled()) {
            return;
        }
        GPIB.ibCmd(this.ud, this.name, command);
    }

    public void interactive() {
        while (true) {
            String response;
            String command = Infrastructure.readln("Enter command: ");
            this.write(command);
            if (command.indexOf("?") <= 0 || (response = this.read(100)).length() <= 0) continue;
            System.out.println("response: " + response);
        }
    }

    protected boolean isDisabled() {
        return SimulationModel.isInUse();
    }

    public static void main(String[] argv) {
        Equipment pulse = new Equipment("SRS535");
        Equipment osc = new Equipment("HPINF54845A");
        osc.write("MEAS:FREQ? CHAN1");
        System.out.println("Freq:" + osc.read(30));
    }
}

