/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.ImmutableIconInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IconNodeInst
extends NodeInst {
    IconNodeInst(ImmutableNodeInst d, Cell parent) {
        super(d, parent);
    }

    @Override
    public ImmutableIconInst getD() {
        return (ImmutableIconInst)super.getD();
    }

    @Override
    public void addVar(Variable var) {
        if (this.isParam(var.getKey())) {
            throw new IllegalArgumentException(this + " already has a variable with name " + var);
        }
        super.addVar(var.withParam(false).withInherit(false));
    }

    @Override
    public Variable getVar(Variable.Key key) {
        Variable param;
        this.checkExamine();
        if (key.isAttribute() && (param = this.getParameter((Variable.AttrKey)key)) != null) {
            return param;
        }
        return this.getD().getVar(key);
    }

    @Override
    public Variable getParameterOrVariable(Variable.Key key) {
        Variable param;
        this.checkExamine();
        if (key.isAttribute() && (param = this.getParameter((Variable.AttrKey)key)) != null) {
            return param;
        }
        return this.getD().getVar(key);
    }

    @Override
    public Iterator<Variable> getParametersAndVariables() {
        if (this.getD().getNumDefinedParameters() == 0) {
            return this.getVariables();
        }
        ArrayList<Variable> vars = new ArrayList<Variable>();
        Iterator<Variable> it = this.getDefinedParameters();
        while (it.hasNext()) {
            vars.add(it.next());
        }
        it = this.getVariables();
        while (it.hasNext()) {
            vars.add(it.next());
        }
        return vars.iterator();
    }

    @Override
    public Variable getParameter(Variable.Key key) {
        if (!(key instanceof Variable.AttrKey)) {
            return null;
        }
        Variable instParam = this.getD().getDefinedParameter((Variable.AttrKey)key);
        if (instParam != null) {
            return instParam;
        }
        Cell icon = (Cell)this.getProto();
        Variable iconParam = icon.getParameter(key);
        return iconParam != null ? IconNodeInst.composeInstParam(iconParam, null) : null;
    }

    @Override
    public boolean isDefinedParameter(Variable.Key key) {
        if (!(key instanceof Variable.AttrKey)) {
            return false;
        }
        return this.getD().getDefinedParameter((Variable.AttrKey)key) != null;
    }

    @Override
    public Iterator<Variable> getParameters() {
        Cell icon = (Cell)this.getProto();
        if (!icon.hasParameters()) {
            return ArrayIterator.emptyIterator();
        }
        ArrayList<Variable> params = new ArrayList<Variable>();
        Iterator<Variable> it = icon.getParameters();
        while (it.hasNext()) {
            Variable iconParam = it.next();
            Variable instVar = this.getD().getDefinedParameter((Variable.AttrKey)iconParam.getKey());
            params.add(IconNodeInst.composeInstParam(iconParam, instVar));
        }
        return params.iterator();
    }

    @Override
    public Iterator<Variable> getDefinedParameters() {
        return this.getD().getDefinedParameters();
    }

    @Override
    public void addParameter(Variable param) {
        if (!this.isParam(param.getKey())) {
            throw new IllegalArgumentException("Parameter " + param + " is not defined on " + this.getProto());
        }
        Cell icon = (Cell)this.getProto();
        Variable iconParam = icon.getParameter(param.getKey());
        param = IconNodeInst.composeInstParam(iconParam, param);
        if (this.setD(this.getD().withParam(param), true)) {
            this.checkPossibleVariableEffects(param.getKey());
        }
    }

    @Override
    public void delParameter(Variable.Key key) {
        if (key instanceof Variable.AttrKey && this.setD(this.getD().withoutParam((Variable.AttrKey)key), true)) {
            this.checkPossibleVariableEffects(key);
        }
    }

    @Override
    public boolean isParam(Variable.Key varKey) {
        Cell icon = (Cell)this.getProto();
        return icon.isParam(varKey);
    }

    @Override
    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        Variable param = this.getParameter(varKey);
        if (param != null) {
            td = td.withParam(true).withInherit(false).withUnit(param.getUnit());
            this.addParameter(param.withTextDescriptor(td));
            return;
        }
        super.setTextDescriptor(varKey, td);
    }

    @Override
    public Variable newVar(Variable.Key key, Object value, TextDescriptor td) {
        if (this.isParam(key)) {
            this.addParameter(this.getParameter(key).withObject(value).withTextDescriptor(td));
            return this.getParameter(key);
        }
        return super.newVar(key, value, td);
    }

    @Override
    public Variable updateVar(Variable.Key key, Object value) {
        if (this.isParam(key)) {
            Variable param = this.getParameter(key);
            this.addParameter(this.getParameter(key).withObject(value));
            return this.getParameter(key);
        }
        return super.updateVar(key, value);
    }

    @Override
    public Variable updateParam(Variable.Key key, Object value) {
        if (this.isParam(key)) {
            Variable param = this.getParameter(key);
            this.addParameter(this.getParameter(key).withObject(value));
            return this.getParameter(key);
        }
        return super.updateVar(key, value);
    }

    @Override
    public Variable updateVarText(Variable.Key key, String text) {
        if (this.isParam(key)) {
            Variable param = this.getParameter(key);
            this.addParameter(this.getParameter(key).withText(text));
            return this.getParameter(key);
        }
        return super.updateVarText(key, text);
    }

    @Override
    public Variable updateVarCode(Variable.Key key, CodeExpression.Code code) {
        if (this.isParam(key)) {
            Variable param = this.getParameter(key);
            this.addParameter(this.getParameter(key).withCode(code));
            return this.getParameter(key);
        }
        return super.updateVarCode(key, code);
    }

    @Override
    public void copyVarsFrom(ElectricObject other) {
        this.checkChanging();
        Iterator<Variable> it = other.getParametersAndVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            if (this.isParam(var.getKey())) {
                this.addParameter(var.withParam(true));
                continue;
            }
            this.addVar(var.withParam(false));
        }
    }

    private static Variable composeInstParam(Variable iconParam, Variable instVar) {
        boolean display;
        boolean bl = display = !iconParam.isInterior();
        if (instVar != null) {
            return instVar.withParam(true).withInherit(false).withInterior(false).withDisplay(display).withUnit(iconParam.getUnit());
        }
        return iconParam.withInherit(false).withInterior(false).withDisplay(display);
    }
}

