/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sandbox;

import com.sun.electric.tool.user.ActivityLogger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class TechExplorerDriver {
    private final Process process;
    private final PrintWriter commandsWriter;
    private static final char MIN_LENGTH_CHAR = ' ';
    private static final char HEADER_CHAR = '\u007f';
    private static final int STRLEN_WIDTH = Integer.toString(Integer.MAX_VALUE).length();
    private static final int HEADER_LEN = 3 + STRLEN_WIDTH + 1;
    private static final int TRAILER_LEN = 3;

    public TechExplorerDriver(ProcessBuilder processBuilder, final OutputStream redirect) throws IOException {
        this.process = processBuilder.start();
        this.commandsWriter = new PrintWriter(this.process.getOutputStream());
        Thread stdErrReader = new Thread(){

            @Override
            public void run() {
                PrintWriter pw = redirect != null ? new PrintWriter(redirect) : null;
                BufferedReader reader = new BufferedReader(new InputStreamReader(TechExplorerDriver.this.process.getErrorStream()));
                String line = null;
                try {
                    while ((line = reader.readLine()) != null) {
                        if (pw == null) continue;
                        pw.println(line);
                        pw.flush();
                    }
                    reader.close();
                }
                catch (IOException e) {
                    ActivityLogger.logException(e);
                }
            }
        };
        stdErrReader.start();
        new StdOutThread().start();
    }

    public void putCommand(String cmd) {
        this.commandsWriter.println(cmd);
        this.commandsWriter.flush();
    }

    public void putCommand(String cmd, String args) {
        this.commandsWriter.println(cmd + " " + args);
        this.commandsWriter.flush();
    }

    public void closeCommands() {
        this.commandsWriter.close();
    }

    private class StdOutThread
    extends Thread {
        private byte[] buf = new byte[128];
        private DataInputStream resultsStream = new DataInputStream(new BufferedInputStream(TechExplorerDriver.access$000(TechExplorerDriver.this).getInputStream()));

        private StdOutThread() {
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.resultsStream.read()) >= 0) {
                    if (c == 127) {
                        boolean isException;
                        if (this.resultsStream.read() != 10) {
                            throw new IOException();
                        }
                        int status = this.resultsStream.read();
                        if (status == 82) {
                            isException = false;
                        } else if (status == 69) {
                            isException = true;
                        } else {
                            throw new IOException();
                        }
                        int len = 0;
                        for (int i = 0; i < STRLEN_WIDTH; ++i) {
                            int cc = this.resultsStream.read();
                            if (cc < 48 || cc > 57) {
                                throw new IOException();
                            }
                            len = len * 10 + cc - 48;
                        }
                        if (this.resultsStream.read() != 10) {
                            throw new IOException();
                        }
                        byte[] b = new byte[len];
                        this.resultsStream.readFully(b);
                        Object result = null;
                        try {
                            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(b));
                            result = in.readObject();
                            in.close();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (this.resultsStream.read() != 10) {
                            throw new IOException();
                        }
                        if (this.resultsStream.read() != 33) {
                            throw new IOException();
                        }
                        if (this.resultsStream.read() != 10) {
                            throw new IOException();
                        }
                        if (isException) {
                            System.out.println("Exception " + result);
                            ((Exception)result).printStackTrace(System.out);
                            continue;
                        }
                        System.out.println("Result " + result);
                        continue;
                    }
                    if (c >= 32 && c < 127) {
                        int len = c - 32 + 1;
                        this.readBuf(len);
                        System.out.write(this.buf, 0, len);
                        continue;
                    }
                    System.out.write(c);
                }
                this.resultsStream.close();
            }
            catch (IOException e) {
                ActivityLogger.logException(e);
            }
        }

        private void readBuf(int len) throws IOException {
            if (this.buf.length < len) {
                this.buf = new byte[Math.max(this.buf.length * 2, len)];
            }
            this.resultsStream.readFully(this.buf, 0, len);
        }
    }
}

