/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.api.NonNullApi;
import org.gradle.internal.build.event.types.DefaultInternalProblemAggregation;
import org.gradle.internal.build.event.types.DefaultProblemAggregationDetails;
import org.gradle.internal.build.event.types.DefaultProblemDescriptor;
import org.gradle.internal.build.event.types.DefaultProblemEvent;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.tooling.internal.protocol.InternalProblemAggregation;
import org.gradle.tooling.internal.protocol.InternalProblemDetails;
import org.gradle.tooling.internal.protocol.InternalProblemEvent;
import org.gradle.tooling.internal.protocol.events.InternalProblemDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.protocol.problem.InternalBasicProblemDetails;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

@NonNullApi
public class AggregatingProblemConsumer {
    private final Multimap<String, InternalProblemEvent> seenProblems = ArrayListMultimap.create();
    private final ProgressEventConsumer progressEventConsumer;
    private final Supplier<OperationIdentifier> operationIdentifierSupplier;
    private int thresholdForIntermediateSummary = 10000;

    AggregatingProblemConsumer(ProgressEventConsumer progressEventConsumer, Supplier<OperationIdentifier> operationIdentifierSupplier) {
        this.progressEventConsumer = progressEventConsumer;
        this.operationIdentifierSupplier = operationIdentifierSupplier;
    }

    void setThresholdForIntermediateSummary(int thresholdForIntermediateSummary) {
        this.thresholdForIntermediateSummary = thresholdForIntermediateSummary;
    }

    void sendProblemSummaries() {
        List<InternalProblemAggregation> problemSummaries = this.createSummaries();
        if (problemSummaries.isEmpty()) {
            this.seenProblems.clear();
            return;
        }
        DefaultProblemEvent event = new DefaultProblemEvent((InternalProblemDescriptor)new DefaultProblemDescriptor(this.operationIdentifierSupplier.get(), CurrentBuildOperationRef.instance().getId()), (InternalProblemDetails)new DefaultProblemAggregationDetails(problemSummaries));
        this.progressEventConsumer.progress((InternalProgressEvent)event);
        this.seenProblems.clear();
    }

    private List<InternalProblemAggregation> createSummaries() {
        return (List)this.seenProblems.asMap().values().stream().map(ImmutableList::copyOf).filter(values -> values.size() > 1).map(aggregatedEvents -> {
            InternalBasicProblemDetails firstProblem = (InternalBasicProblemDetails)((InternalProblemEvent)aggregatedEvents.iterator().next()).getDetails();
            return new DefaultInternalProblemAggregation(firstProblem.getCategory(), firstProblem.getLabel(), (List)aggregatedEvents);
        }).collect(ImmutableList.toImmutableList());
    }

    void emit(InternalProblemEvent problem) {
        InternalProblemDetails details = problem.getDetails();
        if (!(details instanceof InternalBasicProblemDetails)) {
            return;
        }
        InternalBasicProblemDetails basicDetails = (InternalBasicProblemDetails)details;
        String aggregationKey = basicDetails.getCategory().getCategory() + ";" + basicDetails.getLabel().getLabel();
        this.sendProgress(problem, aggregationKey);
        if (this.seenProblems.size() > this.thresholdForIntermediateSummary) {
            this.sendProblemSummaries();
        }
    }

    private void sendProgress(InternalProblemEvent problem, String aggregationKey) {
        Collection seenProblem = this.seenProblems.get((Object)aggregationKey);
        if (seenProblem.isEmpty()) {
            this.seenProblems.put((Object)aggregationKey, (Object)problem);
            this.progressEventConsumer.progress((InternalProgressEvent)problem);
        } else {
            seenProblem.add(problem);
        }
    }
}

